#! /bin/sh

# showshot.sh: Window one "field record" from file seis#.su
#              where # represents the model number.
# Outputs: wiggle image of the shot gather
#          .eps file of the shot gather
# Use:     showshot.sh  file ffid
# Example: showshot.sh   shotgathers.su 80

# Set messages on
set -x
file=$1

# Window one "field record" to a temporary file
suwind < $file key=fldr min=$2 max=$2  \
  > temp$2.su
#  suwind key=tracf min=1 max=60 > temp$2.su

# Make wiggle plot
#sugain gagc=1 wagc=0.2 < temp$2.su | suxwigb key=offset title="SP # $2 [$2]"  \
sugain < temp$2.su | suxwigb key=offset title="SP # $2 [$2]"  \
        label1=" Time (s)" x2beg=18.0 x2end=80 \
        label2="Offset (m)" perc=95 &

# Create .eps image of a shot gather
#sugain gagc=1 wagc=0.2 < temp$2.su | supswigb  key=offset title="SP # $2 [$2]"  \
sugain < temp$2.su | supswigb  key=offset title="SP # $2 [$2]"  \
        label1=" Time (s)" x2beg=18.0 x2end=80 \
        label2="Offset (m)" perc=95 > shot$2.ps &

# Remove temporary gather
rm -f temp$2.su

# Exit politely from shell
exit

