#! /bin/sh

# showshot.sh: Window one cdp from data file
# Outputs: wiggle image of the shot gather
#          .eps file of the shot gather
# Use:     showcdp.sh file cdp
# Example: showshot.sh  cdpgathes.su 150

# Set messages on
set -x
file=$1

# Window one "field record" to a temporary file
suwind < $file key=cdp min=$2 max=$2 tmin=0.0 tmax=0.2 > temp$2.su

# Make wiggle plot
sugain < temp$2.su \
 | suxwigb title="CDP # $2 [$2]"  key=offset\
        label1=" Time (s)" label2="Offset" \
	perc=95 &

# Create .eps image of a shot gather
sugain  < temp$2.su \
 | supswigp title="CDP # $2 [$2]" key=offset \
         label1="Time (s)" label2="Offset(m)" \
         perc=95 > cdp$2.eps &

# Remove temporary gather
rm -f temp$2.su

# Exit politely from shell
exit

