#!/bin/sh

## Sample jobs for processing short course at Northwestern U., Aug 2010
## Part 1: eaqrthquake examples.
#######################################################################

## list all events by loading their parameters in trace headers:

sia list-events.job

## plot a map of all stations:

sia map-stations.job

## plot a map of all events

sia map-events.job

## make two 0.5-degree wide "corridors":

sia make-corridor.job 1 DB/corridor1.txt 0.5
sia make-corridor.job 2 DB/corridor2.txt 0.5

# create corridor maps (corridor #2 looks more interesting)

sia map-corridor.job 1
sia map-corridor.job 2

# obtain waveform data from new IRIS web service:

sia get_IRIS_data.job P 109C "B*" Ball

# extract from the database a receiver-function station gather

sia station_gather.job 109C

# plot receiver-function section from one station:

sia plot-rf.job 109C 3 PS

