function [a] = write_kml_preamble(fid)
% Function to write the preamble to a KML file
% We define three styles of placemarks, which only differ in color
%
% Input:
%  fid = fileid we will write to
%
% Output
%  XLM written to fid
%
a = -1;
%
% write XML preamble
%
c = fprintf(fid,'%s\n','<?xml version="1.0" encoding="UTF-8"?>');
c = fprintf(fid,'%s\n','<kml xmlns="http://www.opengis.net/kml/2.2"');
c = fprintf(fid,'%s\n','xmlns:gx="http://www.google.com/kml/ext/2.2">');
c = fprintf(fid,'%s\n','<Document>');
%
% create three placemark styles  - one red, one green, one blue
% label these styles TA01, TA02, and TA03
%
for i = 1:3
c = fprintf(fid,'%s%02d%s\n','<Style id="TA',i,'">');
%
% set the style for the placemark list on the left side of the google earth display
%
c = fprintf(fid,'%s\n','    <ListStyle>');
c = fprintf(fid,'%s\n','        <ItemIcon>');
c = fprintf(fid,'%s\n','            <href>http://maps.google.com/mapfiles/kml/shapes/shaded_dot.png</href>');
c = fprintf(fid,'%s\n','        </ItemIcon>');
c = fprintf(fid,'%s\n','    </ListStyle>');
%
% set the style for the balloon you get when you click on the placemark 
%
c = fprintf(fid,'%s\n','    <BalloonStyle>');
c = fprintf(fid,'%s\n','        <bgColor>ffffffff</bgColor>');
c = fprintf(fid,'%s\n','        <textColor>ff000000</textColor>');
c = fprintf(fid,'%s\n','        <text>$[description]</text>');
c = fprintf(fid,'%s\n','    </BalloonStyle>');
%
% set all colors to zero
%
r = lower(dec2hex(0,2));
g = lower(dec2hex(0,2));
b = lower(dec2hex(0,2));
%
% now, set just the color we are interested in
%
if i == 1
    r = lower(dec2hex(255,2));
elseif i == 2
    g = lower(dec2hex(255,2));
else
    b = lower(dec2hex(255,2));
end
%
% now, set the style for the actual placemark icon that appears on the map
%
c = fprintf(fid,'%s\n','    <IconStyle>');
c = fprintf(fid,'%s%s%s%s%s\n','         <color>ff',b,g,r,'</color>');
c = fprintf(fid,'%s\n','         <colorMode>normal</colorMode>');
c = fprintf(fid,'%s\n','         <scale>0.7</scale>');
c = fprintf(fid,'%s\n','        <Icon>');
c = fprintf(fid,'%s\n','            <href>http://maps.google.com/mapfiles/kml/shapes/shaded_dot.png</href>');
c = fprintf(fid,'%s\n','        </Icon>');
c = fprintf(fid,'%s\n','    </IconStyle>');
c = fprintf(fid,'%s\n','</Style>');
a = 0;
end;

