function [a] = write_kml_locs(fid,sta_name,tstart,tend,lat,lon,col)
% Function to write out a set of TA stations as Google Earth placemarks
%
% assumes you have already called write_kml_preamble to set up the KML
% preamble and set the placemark definitions that are used below.
%
% Input:
%   fid = fileid
%   sta_name = array of station names
%   tstart = array of station installation dates
%   tend = array of station end dates
%   lat  = station latitudes
%   lon = station longitudes
%
% Output:
%   KML code written to fid
%
a = -1;

for i = 1:length(lat)
[iy1,imo1,id1,ih1,im1,ss1] = datevec(tstart(i));
[iy2,imo2,id2,ih2,im2,ss2] = datevec(tend(i));

    if isfinite(lon(i))
    c = fprintf(fid,'%s%s%s\n','<Placemark id="TA-',sta_name{i},'">'); % provide an identifier for this placemark
%
% next two lines define text used in the lefhand panel that appears on the
% google earth display
    c = fprintf(fid,'%s%s%s\n','       <name>', sta_name{i},'</name>');  % this is text that appears in the left side of the google earth display
    c = fprintf(fid,'%s%4d%s%4d%s\n','       <Snippet maxLines="1">', iy1,' - ',iy2,'</Snippet>'); % additional text that appears on the left panel
%
% select the style of this placemark    
    c = fprintf(fid,'%s%02d%s\n','    <styleUrl>#TA',col(i),'</styleUrl>');  % select placemark style based on values in col()
%
% here is where we define the timespan of this symbol    
    c = fprintf(fid,'%s\n','    <TimeSpan>');
    c = fprintf(fid,'%s%d%s%02d%s%02d%s%02d%s%02d%s%02d%s\n','        <begin>',iy1,'-',imo1,'-',id1,'T',ih1,':',im1,':',ss1,'Z</begin>');
    c = fprintf(fid,'%s%d%s%02d%s%02d%s%02d%s%02d%s%02d%s\n','        <end>  ',iy2,'-',imo2,'-',id2,'T',ih2,':',im2,':',ss2,'Z</end>');
    c = fprintf(fid,'%s\n','    </TimeSpan>');
%
% set coordinates of the placemark    
    c = fprintf(fid,'%s\n','    <Point>');
    c = fprintf(fid,'%s\n','    <altitudeMode>absolute</altitudeMode>');
% note that we are using a bogus altitude, so we can use an oblique view
% to see vertical separation of the different styles of placemarks
    c = fprintf(fid,'%s%f%s%f%s%d%s\n','        <coordinates>',lon(i),',',lat(i),',',col(i)*10000,'</coordinates>');
    c = fprintf(fid,'%s\n','    </Point>');
%
% text that appears in the balloon if you click on a placemark 
    c = fprintf(fid,'%s%s%s\n','    <description><![CDATA[',sta_name{i},']]></description>');
    c = fprintf(fid,'%s\n','</Placemark>');
    end;
end;
a = 0;


