/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class MatTauP_Time
extends TauP_Time {
    protected void readTauModel() throws TauModelException, OptionalDataException, StreamCorruptedException, IOException, InvalidClassException, FileNotFoundException {
        try {
            TauModel tModLoad = TauModelLoader.load((String)this.modelName, (String)this.toolProps.getProperty("taup.model.path"));
            if (tModLoad != null) {
                this.tMod = tModLoad;
                this.tModDepth = this.tMod;
                this.modelName = this.tMod.sMod.vMod.getModelName();
            }
        }
        catch (ClassNotFoundException e) {
            Alert.error((String)"Caught ClassNotFoundException", (String)String.valueOf(String.valueOf(e.getMessage()).concat(String.valueOf("\nThere must be something wrong with your installation of TauP.\n"))).concat(String.valueOf("Exiting.")));
            return;
        }
        catch (InvalidClassException e) {
            Alert.error((String)String.valueOf(String.valueOf("Model file ").concat(String.valueOf(this.modelName))).concat(String.valueOf(" is not compatible with the current version.")), (String)"Recreate using taup_create.");
        }
    }

    public void init() throws IOException {
        if (this.phaseNames.size() == 0) {
            if (this.toolProps.containsKey("taup.phase.file")) {
                if (this.toolProps.containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException e) {
                    Alert.warning((String)String.valueOf("Caught IOException while attempting to reading phase file ").concat(String.valueOf(this.toolProps.getProperty("taup.phase.file"))), (String)e.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
            }
        }
        this.depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null) {
            this.modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException ee) {
                Alert.error((String)"Caught TauModelException", (String)ee.getMessage());
            }
            catch (FileNotFoundException ee) {
                Alert.error((String)String.valueOf(String.valueOf("Can't find saved model file for model ").concat(String.valueOf(this.modelName))).concat(String.valueOf(".")), (String)"");
                return;
            }
            catch (InvalidClassException ee) {
                Alert.error((String)String.valueOf(String.valueOf("Model file ").concat(String.valueOf(this.modelName))).concat(String.valueOf(" is not compatible with the current version.")), (String)"Recreate using taup_create.");
                return;
            }
        }
        this.dos = null;
    }

    public void printResult(DataOutputStream dos) throws IOException {
        if (dos == null) {
            return;
        }
        BufferedWriter s = new BufferedWriter(new OutputStreamWriter(dos));
        this.printResult(s);
        ((Writer)s).flush();
    }

    public static Arrival[] run_time(String[] args) throws OptionalDataException, ClassNotFoundException, StreamCorruptedException, IOException, FileNotFoundException {
        Arrival[] arrivals = null;
        try {
            long prevTime = 0L;
            prevTime = System.currentTimeMillis();
            MatTauP_Time tauPTime = new MatTauP_Time();
            String[] noComprendoArgs = tauPTime.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                for (int i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    Arrival[] arrivalArray = arrivals;
                    return arrivalArray;
                }
                String outStringA = "I don't understand the following arguments, continuing:";
                String outStringB = "";
                for (int i = 0; i < noComprendoArgs.length; ++i) {
                    outStringB = String.valueOf(outStringB).concat(String.valueOf(String.valueOf(noComprendoArgs[i]).concat(String.valueOf(" "))));
                }
                Alert.warning((String)outStringA, (String)outStringB);
                noComprendoArgs = null;
            }
            long currTime = System.currentTimeMillis();
            prevTime = System.currentTimeMillis();
            tauPTime.init();
            currTime = System.currentTimeMillis();
            if (tauPTime.DEBUG) {
                Alert.info((String)String.valueOf("taup model read time=").concat(String.valueOf(currTime - prevTime)));
            }
            tauPTime.start();
            arrivals = tauPTime.getArrivals();
            tauPTime.destroy();
            Arrival[] arrivalArray = arrivals;
            return arrivalArray;
        }
        catch (TauModelException e) {
            Alert.error((String)"Caught TauModelException", (String)e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            Alert.error((String)"Caught TauPException", (String)e.getMessage());
            e.printStackTrace();
        }
        return arrivals;
    }
}

