/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.LatLon;
import edu.sc.seis.TauP.MatArrival;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Pierce;
import edu.sc.seis.TauP.TauP_Time;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class MatTauP_Pierce
extends TauP_Pierce {
    protected MatArrival[] matArrivals;

    protected MatTauP_Pierce() {
    }

    public void init() throws IOException {
        if (this.phaseNames.size() == 0) {
            if (this.toolProps.containsKey("taup.phase.file")) {
                if (this.toolProps.containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException e) {
                    Alert.warning((String)String.valueOf("Caught IOException while attempting to reading phase file ").concat(String.valueOf(this.toolProps.getProperty("taup.phase.file"))), (String)e.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
            }
        }
        ((TauP_Time)this).depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null) {
            ((TauP_Time)this).modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException ee) {
                Alert.error((String)"Caught TauModelException", (String)ee.getMessage());
            }
            catch (FileNotFoundException ee) {
                Alert.error((String)String.valueOf(String.valueOf("Can't find saved model file for model ").concat(String.valueOf(this.modelName))).concat(String.valueOf(".")), (String)"");
                return;
            }
            catch (InvalidClassException ee) {
                Alert.error((String)String.valueOf(String.valueOf("Model file ").concat(String.valueOf(this.modelName))).concat(String.valueOf(" is not compatible with the current version.")), (String)"Recreate using taup_create.");
                return;
            }
        }
        ((TauP_Time)this).dos = null;
    }

    public void printResult(DataOutputStream dos) throws IOException {
        Writer s = null;
        this.printResult(s);
    }

    public void printResult(Writer out) throws IOException {
        boolean longWayRound = false;
        this.matArrivals = new MatArrival[this.arrivals.size()];
        for (int i = 0; i < this.arrivals.size(); ++i) {
            Arrival currArrival = (Arrival)this.arrivals.elementAt(i);
            this.matArrivals[i] = new MatArrival(currArrival);
            this.matArrivals[i].matPath.init_path(currArrival.pierce.length);
            longWayRound = false;
            if (currArrival.dist * (double)180 / Math.PI % (double)360 > (double)180) {
                longWayRound = true;
            }
            double prevDepth = currArrival.pierce[0].depth;
            for (int j = 0; j < currArrival.pierce.length; ++j) {
                double calcTime = currArrival.pierce[j].time;
                double calcDist = currArrival.pierce[j].dist * 180.0 / Math.PI;
                if (longWayRound && calcDist != 0.0) {
                    calcDist *= -1.0;
                }
                double nextDepth = j < currArrival.pierce.length - 1 ? currArrival.pierce[j + 1].depth : currArrival.pierce[j].depth;
                if (!this.onlyTurnPoints && !this.onlyRevPoints && !this.onlyUnderPoints && !this.onlyAddPoints || this.onlyAddPoints && this.isAddDepth(currArrival.pierce[j].depth) || this.onlyRevPoints && (prevDepth - currArrival.pierce[j].depth) * (currArrival.pierce[j].depth - nextDepth) < 0.0 || this.onlyTurnPoints && j != 0 && prevDepth - currArrival.pierce[j].depth <= 0.0 && currArrival.pierce[j].depth - nextDepth >= 0.0 || this.onlyUnderPoints && prevDepth - currArrival.pierce[j].depth >= 0.0 && currArrival.pierce[j].depth - nextDepth <= 0.0) {
                    this.matArrivals[i].matPath.p[j] = currArrival.pierce[j].p;
                    this.matArrivals[i].matPath.time[j] = calcTime;
                    this.matArrivals[i].matPath.dist[j] = calcDist;
                    this.matArrivals[i].matPath.depth[j] = currArrival.pierce[j].depth;
                    this.matArrivals[i].matPath.lat[j] = this.calcLatLon((double)calcDist).lat;
                    this.matArrivals[i].matPath.lon[j] = this.calcLatLon((double)calcDist).lon;
                }
                prevDepth = currArrival.pierce[j].depth;
            }
        }
    }

    protected LatLon calcLatLon(double calcDist) {
        double lat = 0.0;
        double lon = 0.0;
        LatLon pathCoord = new LatLon();
        if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
            lat = SphericalCoords.latFor((double)this.eventLat, (double)this.eventLon, (double)calcDist, (double)this.azimuth);
            lon = SphericalCoords.lonFor((double)this.eventLat, (double)this.eventLon, (double)calcDist, (double)this.azimuth);
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
            lat = SphericalCoords.latFor((double)this.stationLat, (double)this.stationLon, (double)(this.degrees - calcDist), (double)this.backAzimuth);
            lon = SphericalCoords.lonFor((double)this.stationLat, (double)this.stationLon, (double)(this.degrees - calcDist), (double)this.backAzimuth);
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
            ((TauP_Time)this).azimuth = SphericalCoords.azimuth((double)this.eventLat, (double)this.eventLon, (double)this.stationLat, (double)this.stationLon);
            ((TauP_Time)this).backAzimuth = SphericalCoords.azimuth((double)this.stationLat, (double)this.stationLon, (double)this.eventLat, (double)this.eventLon);
            lat = SphericalCoords.latFor((double)this.eventLat, (double)this.eventLon, (double)calcDist, (double)this.azimuth);
            lon = SphericalCoords.lonFor((double)this.eventLat, (double)this.eventLon, (double)calcDist, (double)this.azimuth);
        }
        pathCoord.lat = lat;
        pathCoord.lon = lon;
        return pathCoord;
    }

    public static MatArrival[] run_pierce(String[] args) throws OptionalDataException, ClassNotFoundException, StreamCorruptedException, IOException, FileNotFoundException {
        MatArrival[] matArrivals = null;
        try {
            MatTauP_Pierce tauPPierce = new MatTauP_Pierce();
            String[] noComprendoArgs = tauPPierce.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    MatArrival[] matArrivalArray = matArrivals;
                    return matArrivalArray;
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(String.valueOf(noComprendoArgs[i]).concat(String.valueOf(" ")));
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.out.println();
                    MatArrival[] matArrivalArray = matArrivals;
                    return matArrivalArray;
                }
                System.out.println();
                noComprendoArgs = null;
            }
            if (tauPPierce.DEBUG) {
                System.out.println(String.valueOf("Done reading ").concat(String.valueOf(tauPPierce.modelName)));
            }
            tauPPierce.init();
            tauPPierce.start();
            matArrivals = tauPPierce.matArrivals;
            tauPPierce.destroy();
            MatArrival[] matArrivalArray = matArrivals;
            return matArrivalArray;
        }
        catch (TauModelException e) {
            System.out.println(String.valueOf("Caught TauModelException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println(String.valueOf("Caught TauPException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
        return matArrivals;
    }

    public static void main(String[] args) throws OptionalDataException, ClassNotFoundException, StreamCorruptedException, IOException, FileNotFoundException {
        MatArrival[] matArrivals = null;
        try {
            MatTauP_Pierce tauPPierce = new MatTauP_Pierce();
            String[] noComprendoArgs = tauPPierce.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(String.valueOf(noComprendoArgs[i]).concat(String.valueOf(" ")));
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                noComprendoArgs = null;
            }
            if (tauPPierce.DEBUG) {
                System.out.println(String.valueOf("Done reading ").concat(String.valueOf(tauPPierce.modelName)));
            }
            tauPPierce.init();
            tauPPierce.start();
            matArrivals = tauPPierce.matArrivals;
            tauPPierce.destroy();
        }
        catch (TauModelException e) {
            System.out.println(String.valueOf("Caught TauModelException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println(String.valueOf("Caught TauPException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
    }
}

