/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TT_Curve;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Curve;
import edu.sc.seis.TauP.TauP_Time;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class MatTauP_Curve
extends TauP_Curve {
    protected TT_Curve[] tt_curve;

    protected MatTauP_Curve() {
    }

    public void init() throws IOException {
        if (this.phaseNames.size() == 0) {
            if (this.toolProps.containsKey("taup.phase.file")) {
                if (this.toolProps.containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException e) {
                    Alert.warning((String)String.valueOf("Caught IOException while attempting to reading phase file ").concat(String.valueOf(this.toolProps.getProperty("taup.phase.file"))), (String)e.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
            }
        }
        ((TauP_Time)this).depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null) {
            ((TauP_Time)this).modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException ee) {
                Alert.error((String)"Caught TauModelException", (String)ee.getMessage());
            }
            catch (FileNotFoundException ee) {
                Alert.error((String)String.valueOf(String.valueOf("Can't find saved model file for model ").concat(String.valueOf(this.modelName))).concat(String.valueOf(".")), (String)"");
                return;
            }
            catch (InvalidClassException ee) {
                Alert.error((String)String.valueOf(String.valueOf("Model file ").concat(String.valueOf(this.modelName))).concat(String.valueOf(" is not compatible with the current version.")), (String)"Recreate using taup_create.");
                return;
            }
        }
        ((TauP_Time)this).dos = null;
    }

    public void printResult(DataOutputStream dos) throws IOException {
        Writer s = null;
        this.printResult(s);
    }

    public void printResult(Writer out) throws IOException {
        double maxTime = -1.7976931348623157E308;
        double minTime = Double.MAX_VALUE;
        this.tt_curve = new TT_Curve[this.phases.size()];
        for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
            SeismicPhase phase = (SeismicPhase)this.phases.elementAt(phaseNum);
            double[] dist = phase.getDist();
            double[] time = phase.getTime();
            double[] rayParams = phase.getRayParams();
            this.tt_curve[phaseNum] = new TT_Curve(dist.length);
            this.tt_curve[phaseNum].phaseName = phase.getName();
            this.tt_curve[phaseNum].sourceDepth = this.depth;
            this.tt_curve[phaseNum].rayParam = rayParams;
            block1: for (int i = 0; i < dist.length; ++i) {
                int j;
                Arrival[] phaseArrivals;
                double arcDistance = Math.acos(Math.cos(dist[i]));
                double timeReduced = this.reduceTime ? time[i] - arcDistance / this.reduceVel : time[i];
                this.tt_curve[phaseNum].time[i] = timeReduced;
                this.tt_curve[phaseNum].dist[i] = 57.29577951308232 * arcDistance;
                if (i < dist.length - 1 && rayParams[i] == rayParams[i + 1] && rayParams.length > 2) {
                    System.out.println(String.valueOf(String.valueOf("  Shadow Zone detected for phase ").concat(String.valueOf(phase.getName()))).concat(String.valueOf("\n")));
                    continue;
                }
                if (i < dist.length - 1 && Math.sin(dist[i]) > 0.0 && Math.sin(dist[i + 1]) < 0.0) {
                    phase.calcTime(180.0);
                    phaseArrivals = phase.getArrivals();
                    for (j = 0; j < phaseArrivals.length; ++j) {
                        if (!((phase.rayParams[i] - phaseArrivals[j].rayParam) * (phaseArrivals[j].rayParam - phase.rayParams[i + 1]) > 0.0)) continue;
                        if (this.reduceTime) {
                            System.out.println(String.valueOf(String.valueOf("180.0  ").concat(String.valueOf((float)(phaseArrivals[j].time - Math.PI / this.reduceVel)))).concat(String.valueOf("\n")));
                            break;
                        }
                        System.out.println(String.valueOf(String.valueOf("180.0  ").concat(String.valueOf((float)phaseArrivals[j].time))).concat(String.valueOf("\n")));
                        break;
                    }
                }
                if (i >= dist.length - 1 || !(Math.sin(dist[i]) < 0.0) || !(Math.sin(dist[i + 1]) > 0.0)) continue;
                phase.calcTime(0.0);
                phaseArrivals = phase.getArrivals();
                for (j = 0; j < phaseArrivals.length; ++j) {
                    if (!((phase.rayParams[i] - phaseArrivals[j].rayParam) * (phaseArrivals[j].rayParam - phase.rayParams[i + 1]) > 0.0)) continue;
                    System.out.println(String.valueOf(String.valueOf("0.0  ").concat(String.valueOf((float)phaseArrivals[j].time))).concat(String.valueOf("\n")));
                    continue block1;
                }
            }
        }
    }

    public static TT_Curve[] run_curve(String[] args) throws OptionalDataException, ClassNotFoundException, StreamCorruptedException, IOException, FileNotFoundException {
        TT_Curve[] tt_curve = null;
        boolean doInteractive = true;
        try {
            int i;
            MatTauP_Curve tauPCurve = new MatTauP_Curve();
            tauPCurve.outFile = "taup_curve.gmt";
            String[] noComprendoArgs = tauPCurve.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    TT_Curve[] tT_CurveArray = tt_curve;
                    return tT_CurveArray;
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(String.valueOf(noComprendoArgs[i]).concat(String.valueOf(" ")));
                    if (!noComprendoArgs[i].equals("-help")) continue;
                    System.out.println();
                    TT_Curve[] tT_CurveArray = tt_curve;
                    return tT_CurveArray;
                }
                System.out.println();
                noComprendoArgs = null;
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i] != "-h") continue;
                doInteractive = false;
            }
            if (tauPCurve.DEBUG) {
                System.out.println(String.valueOf("Done reading ").concat(String.valueOf(tauPCurve.modelName)));
            }
            tauPCurve.init();
            if (doInteractive) {
                tauPCurve.start();
            } else {
                tauPCurve.depthCorrect(Double.valueOf(tauPCurve.toolProps.getProperty("taup.source.depth", "0.0")));
                tauPCurve.calculate(tauPCurve.degrees);
                tauPCurve.printResult(tauPCurve.dos);
            }
            tt_curve = tauPCurve.tt_curve;
            tauPCurve.destroy();
            TT_Curve[] tT_CurveArray = tt_curve;
            return tT_CurveArray;
        }
        catch (TauModelException e) {
            System.out.println(String.valueOf("Caught TauModelException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
            return tt_curve;
        }
    }

    public static void main(String[] args) throws OptionalDataException, ClassNotFoundException, StreamCorruptedException, IOException, FileNotFoundException {
        boolean doInteractive = true;
        try {
            int i;
            MatTauP_Curve tauPCurve = new MatTauP_Curve();
            tauPCurve.outFile = "taup_curve.gmt";
            String[] noComprendoArgs = tauPCurve.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(String.valueOf(noComprendoArgs[i]).concat(String.valueOf(" ")));
                    if (!noComprendoArgs[i].equals("-help")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                noComprendoArgs = null;
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i] != "-h") continue;
                doInteractive = false;
            }
            if (tauPCurve.DEBUG) {
                System.out.println(String.valueOf("Done reading ").concat(String.valueOf(tauPCurve.modelName)));
            }
            tauPCurve.init();
            if (doInteractive) {
                tauPCurve.start();
            } else {
                tauPCurve.depthCorrect(Double.valueOf(tauPCurve.toolProps.getProperty("taup.source.depth", "0.0")));
                tauPCurve.calculate(tauPCurve.degrees);
                tauPCurve.printResult(tauPCurve.dos);
            }
            TT_Curve[] tt_curve = tauPCurve.tt_curve;
            tauPCurve.destroy();
        }
        catch (TauModelException e) {
            System.out.println(String.valueOf("Caught TauModelException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
    }
}

