/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.Vector;

public class VelocityModel
implements Cloneable,
Serializable {
    protected String modelName = "unknown";
    protected String fileType = "nd";
    protected double radiusOfEarth = 6371.0;
    protected double mohoDepth = 35.0;
    protected double cmbDepth = 2889.0;
    protected double iocbDepth = 5153.9;
    protected double meanDensity = 5517.0;
    protected double G = 6.67E-11;
    protected double minRadius = 0.0;
    protected double maxRadius = 6371.0;
    protected boolean spherical = true;
    protected static int vectorLength = 16;
    protected Vector layer = new Vector(vectorLength);

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String string) {
        this.modelName = string.length() > 0 ? string : "unknown";
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public void setRadiusOfEarth(double d) {
        this.radiusOfEarth = d;
    }

    public double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public double[] getDisconDepths() {
        double[] dArray = new double[this.getNumLayers() + 2];
        int n = 0;
        dArray[n++] = this.getVelocityLayer((int)0).topDepth;
        int n2 = 0;
        while (n2 < this.getNumLayers() - 1) {
            VelocityLayer velocityLayer = this.getVelocityLayer(n2);
            VelocityLayer velocityLayer2 = this.getVelocityLayer(n2 + 1);
            if (velocityLayer.botPVelocity != velocityLayer2.topPVelocity || velocityLayer.botSVelocity != velocityLayer2.topSVelocity) {
                dArray[n++] = velocityLayer.botDepth;
            }
            ++n2;
        }
        dArray[n++] = this.getVelocityLayer((int)(this.getNumLayers() - 1)).botDepth;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    public double getMohoDepth() {
        return this.mohoDepth;
    }

    public void setMohoDepth(double d) {
        this.mohoDepth = d;
    }

    public double getCmbDepth() {
        return this.cmbDepth;
    }

    public void setCmbDepth(double d) {
        this.cmbDepth = d;
    }

    public double getIocbDepth() {
        return this.iocbDepth;
    }

    public void setIocbDepth(double d) {
        this.iocbDepth = d;
    }

    public double getMeanDensity() {
        return this.meanDensity;
    }

    public void setMeanDensity(double d) {
        this.meanDensity = d;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(double d) {
        this.minRadius = d;
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(double d) {
        this.maxRadius = d;
    }

    public double getG() {
        return this.G;
    }

    public void setG(double d) {
        this.G = d;
    }

    public boolean getSpherical() {
        return this.spherical;
    }

    public void setSpherical(boolean bl) {
        this.spherical = bl;
    }

    public VelocityLayer getVelocityLayerClone(int n) {
        return (VelocityLayer)((VelocityLayer)this.layer.elementAt(n)).clone();
    }

    public VelocityLayer getVelocityLayer(int n) {
        return (VelocityLayer)this.layer.elementAt(n);
    }

    public int getNumLayers() {
        return this.layer.size();
    }

    /*
     * Unable to fully structure code
     */
    public int layerNumberAbove(double var1_1) throws NoSuchLayerException {
        var3_2 = this.getVelocityLayer(0);
        if (var1_1 == var3_2.topDepth) {
            return 0;
        }
        var4_3 = 0;
        var5_4 = this.getNumLayers() - 1;
        var6_5 = 0;
        var7_6 = false;
        if (!(var1_1 < var3_2.topDepth) && !(this.getVelocityLayer((int)var5_4).botDepth < var1_1)) ** GOTO lbl19
        throw new NoSuchLayerException(var1_1);
lbl-1000:
        // 1 sources

        {
            var6_5 = Math.round((float)(var4_3 + var5_4) / 2.0f);
            var3_2 = this.getVelocityLayer(var6_5);
            if (var3_2.topDepth >= var1_1) {
                var5_4 = var6_5 - 1;
                continue;
            }
            if (var3_2.botDepth < var1_1) {
                var4_3 = var6_5 + 1;
                continue;
            }
            var7_6 = true;
lbl19:
            // 4 sources

            ** while (!var7_6)
        }
lbl20:
        // 1 sources

        return var6_5;
    }

    /*
     * Unable to fully structure code
     */
    public int layerNumberBelow(double var1_1) throws NoSuchLayerException {
        var3_2 = this.getVelocityLayer(0);
        var4_3 = 0;
        var5_4 = this.getNumLayers() - 1;
        var6_5 = 0;
        var7_6 = false;
        if (var1_1 == var3_2.topDepth) {
            return 0;
        }
        if (this.getVelocityLayer((int)var5_4).botDepth == var1_1) {
            return var5_4;
        }
        if (!(var1_1 < var3_2.topDepth) && !(this.getVelocityLayer((int)var5_4).botDepth < var1_1)) ** GOTO lbl21
        throw new NoSuchLayerException(var1_1);
lbl-1000:
        // 1 sources

        {
            var6_5 = Math.round((float)(var4_3 + var5_4) / 2.0f);
            var3_2 = this.getVelocityLayer(var6_5);
            if (var3_2.topDepth > var1_1) {
                var5_4 = var6_5 - 1;
                continue;
            }
            if (var3_2.botDepth <= var1_1) {
                var4_3 = var6_5 + 1;
                continue;
            }
            var7_6 = true;
lbl21:
            // 4 sources

            ** while (!var7_6)
        }
lbl22:
        // 1 sources

        return var6_5;
    }

    public double evaluateAbove(double d, char c) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer velocityLayer = this.getVelocityLayer(this.layerNumberAbove(d));
        return velocityLayer.evaluateAt(d, c);
    }

    public double evaluateBelow(double d, char c) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer velocityLayer = this.getVelocityLayer(this.layerNumberBelow(d));
        return velocityLayer.evaluateAt(d, c);
    }

    public double evaluateAtTop(int n, char c) throws NoSuchMatPropException {
        VelocityLayer velocityLayer = this.getVelocityLayer(n);
        return velocityLayer.evaluateAtTop(c);
    }

    public double evaluateAtBottom(int n, char c) throws NoSuchMatPropException {
        VelocityLayer velocityLayer = this.getVelocityLayer(n);
        return velocityLayer.evaluateAtBottom(c);
    }

    public double depthAtTop(int n) {
        VelocityLayer velocityLayer = this.getVelocityLayer(n);
        return velocityLayer.topDepth;
    }

    public double depthAtBottom(int n) throws NoSuchMatPropException {
        VelocityLayer velocityLayer = this.getVelocityLayer(n);
        return velocityLayer.botDepth;
    }

    public void replaceLayers(VelocityLayer[] velocityLayerArray, boolean bl, boolean bl2) throws NoSuchLayerException {
        VelocityLayer velocityLayer;
        int n = this.layerNumberBelow(velocityLayerArray[0].topDepth);
        VelocityLayer velocityLayer2 = this.getVelocityLayer(n);
        int n2 = this.layerNumberAbove(velocityLayerArray[velocityLayerArray.length - 1].botDepth);
        VelocityLayer velocityLayer3 = this.getVelocityLayer(n2);
        if (bl) {
            try {
                velocityLayerArray[0].topPVelocity = velocityLayer2.evaluateAt(velocityLayerArray[0].topDepth, 'P');
                velocityLayerArray[0].topSVelocity = velocityLayer2.evaluateAt(velocityLayerArray[0].topDepth, 'S');
            }
            catch (NoSuchMatPropException noSuchMatPropException) {
                System.err.println("Caught NoSuchMatPropException: " + noSuchMatPropException.getMessage());
                noSuchMatPropException.printStackTrace();
            }
        }
        if (bl2) {
            try {
                velocityLayerArray[velocityLayerArray.length - 1].botPVelocity = velocityLayer3.evaluateAt(velocityLayerArray[velocityLayerArray.length - 1].botDepth, 'P');
                velocityLayerArray[velocityLayerArray.length - 1].botSVelocity = velocityLayer3.evaluateAt(velocityLayerArray[velocityLayerArray.length - 1].botDepth, 'S');
            }
            catch (NoSuchMatPropException noSuchMatPropException) {
                System.err.println("Caught NoSuchMatPropException: " + noSuchMatPropException.getMessage());
                noSuchMatPropException.printStackTrace();
            }
        }
        if (velocityLayer2.botDepth > velocityLayerArray[0].topDepth) {
            velocityLayer = (VelocityLayer)velocityLayer2.clone();
            try {
                velocityLayer2.botPVelocity = velocityLayer2.evaluateAt(velocityLayerArray[0].topDepth, 'P');
                velocityLayer2.botSVelocity = velocityLayer2.evaluateAt(velocityLayerArray[0].topDepth, 'S');
                velocityLayer2.botDepth = velocityLayerArray[0].topDepth;
            }
            catch (NoSuchMatPropException noSuchMatPropException) {
                System.err.println("Caught NoSuchMatPropException: " + noSuchMatPropException.getMessage());
                noSuchMatPropException.printStackTrace();
            }
            velocityLayer.topPVelocity = velocityLayer2.botPVelocity;
            velocityLayer.topSVelocity = velocityLayer2.botSVelocity;
            velocityLayer.topDepth = velocityLayer2.botDepth;
            this.layer.insertElementAt(velocityLayer, n + 1);
            ++n2;
            ++n;
        }
        if (velocityLayer3.botDepth > velocityLayerArray[velocityLayerArray.length - 1].botDepth) {
            velocityLayer = (VelocityLayer)velocityLayer3.clone();
            try {
                velocityLayer3.botPVelocity = velocityLayer3.evaluateAt(velocityLayerArray[velocityLayerArray.length - 1].botDepth, 'P');
                velocityLayer3.botSVelocity = velocityLayer3.evaluateAt(velocityLayerArray[velocityLayerArray.length - 1].botDepth, 'S');
                velocityLayer3.botDepth = velocityLayerArray[velocityLayerArray.length - 1].botDepth;
            }
            catch (NoSuchMatPropException noSuchMatPropException) {
                System.err.println("Caught NoSuchMatPropException: " + noSuchMatPropException.getMessage());
                noSuchMatPropException.printStackTrace();
            }
            velocityLayer.topPVelocity = velocityLayer3.botPVelocity;
            velocityLayer.topSVelocity = velocityLayer3.botSVelocity;
            velocityLayer.topDepth = velocityLayer3.botDepth;
            this.layer.insertElementAt(velocityLayer, n2 + 1);
            ++n2;
        }
        int n3 = n;
        while (n3 <= n2) {
            this.layer.removeElementAt(n);
            ++n3;
        }
        int n4 = 0;
        while (n4 < velocityLayerArray.length) {
            this.layer.insertElementAt(velocityLayerArray[n4], n + n4);
            ++n4;
        }
        this.validate();
    }

    public void printGMT(String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        this.printGMT(dataOutputStream);
        dataOutputStream.close();
    }

    public void printGMT(DataOutputStream dataOutputStream) throws IOException {
        VelocityLayer velocityLayer;
        double d = 0.0;
        double d2 = -1.0;
        double d3 = -1.0;
        dataOutputStream.writeBytes("> P velocity for " + this.modelName + "  below\n");
        int n = 0;
        while (n < this.getNumLayers()) {
            velocityLayer = this.getVelocityLayer(n);
            if (velocityLayer.topPVelocity != d2) {
                dataOutputStream.writeBytes((float)velocityLayer.topDepth + " " + (float)velocityLayer.topPVelocity + "\n");
            }
            dataOutputStream.writeBytes((float)velocityLayer.botDepth + " " + (float)velocityLayer.botPVelocity + "\n");
            d2 = velocityLayer.botPVelocity;
            ++n;
        }
        dataOutputStream.writeBytes("> S velocity for " + this.modelName + "  below\n");
        int n2 = 0;
        while (n2 < this.getNumLayers()) {
            velocityLayer = this.getVelocityLayer(n2);
            if (velocityLayer.topSVelocity != d3) {
                dataOutputStream.writeBytes((float)velocityLayer.topDepth + " " + (float)velocityLayer.topSVelocity + "\n");
            }
            dataOutputStream.writeBytes((float)velocityLayer.botDepth + " " + (float)velocityLayer.botSVelocity + "\n");
            d3 = velocityLayer.botSVelocity;
            ++n2;
        }
    }

    public boolean validate() {
        if (this.radiusOfEarth <= 0.0) {
            System.err.println("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
            return false;
        }
        if (this.mohoDepth < 0.0) {
            System.err.println("mohoDepth is not non-negative. mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth < this.mohoDepth) {
            System.err.println("cmbDepth < mohoDepth. cmbDepth = " + this.cmbDepth + " mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth <= 0.0) {
            System.err.println("cmbDepth is not positive. cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth < this.cmbDepth) {
            System.err.println("iocbDepth < cmbDepth. iocbDepth = " + this.iocbDepth + " cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth <= 0.0) {
            System.err.println("iocbDepth is not positive. iocbDepth = " + this.iocbDepth);
            return false;
        }
        if (this.minRadius < 0.0) {
            System.err.println("minRadius is not non-negative. minRadius = " + this.minRadius);
            return false;
        }
        if (this.maxRadius <= 0.0) {
            System.err.println("maxRadius is not positive. maxRadius = " + this.maxRadius);
            return false;
        }
        if (this.maxRadius <= this.minRadius) {
            System.err.println("maxRadius <= minRadius. maxRadius = " + this.maxRadius + " minRadius = " + this.minRadius);
            return false;
        }
        VelocityLayer velocityLayer = this.getVelocityLayer(0);
        VelocityLayer velocityLayer2 = new VelocityLayer();
        velocityLayer2.botDepth = velocityLayer.topDepth;
        velocityLayer2.botPVelocity = velocityLayer.topPVelocity;
        velocityLayer2.botSVelocity = velocityLayer.topSVelocity;
        velocityLayer2.botDensity = velocityLayer.topDensity;
        int n = 0;
        while (n < this.getNumLayers()) {
            velocityLayer = this.getVelocityLayer(n);
            if (velocityLayer2.botDepth != velocityLayer.topDepth) {
                System.err.println("There is a gap in the velocity model between layers " + (n - 1) + " and " + n);
                System.err.println("prevVelocityLayer=" + velocityLayer2);
                System.err.println("currVelocityLayer=" + velocityLayer);
                return false;
            }
            if (velocityLayer.botDepth == velocityLayer.topDepth) {
                System.err.println("There is a zero thickness layer in the velocity model at layer " + n);
                System.err.println("prevVelocityLayer=" + velocityLayer2);
                System.err.println("currVelocityLayer=" + velocityLayer);
                return false;
            }
            if (velocityLayer.topPVelocity <= 0.0 || velocityLayer.botPVelocity <= 0.0) {
                System.err.println("There is a negative P velocity layer in the velocity model at layer " + n);
                return false;
            }
            if (velocityLayer.topSVelocity < 0.0 || velocityLayer.botSVelocity < 0.0) {
                System.err.println("There is a negative S velocity layer in the velocity model at layer " + n);
                return false;
            }
            if (velocityLayer.topPVelocity != 0.0 && velocityLayer.botPVelocity == 0.0 || velocityLayer.topPVelocity == 0.0 && velocityLayer.botPVelocity != 0.0) {
                System.err.println("There is a layer that goes to zero P velocity without a discontinuity in the velocity model at layer " + n + "\nThis would cause a divide by zero within this " + "depth range. Try making the velocity small, followed by a " + "discontinuity to zero velocity.");
                return false;
            }
            if (velocityLayer.topSVelocity != 0.0 && velocityLayer.botSVelocity == 0.0 || velocityLayer.topSVelocity == 0.0 && velocityLayer.botSVelocity != 0.0) {
                System.err.println("There is a layer that goes to zero S velocity without a discontinuity in the velocity model at layer " + n + "\nThis would cause a divide by zero within this " + "depth range. Try making the velocity small, followed by a " + "discontinuity to zero velocity.");
                return false;
            }
            velocityLayer2 = velocityLayer;
            ++n;
        }
        return true;
    }

    public String toString() {
        String string = "modelName=" + this.modelName + "\n" + "\n radiusOfEarth=" + this.radiusOfEarth + "\n mohoDepth=" + this.mohoDepth + "\n cmbDepth=" + this.cmbDepth + "\n iocbDepth=" + this.iocbDepth + "\n meanDensity=" + this.meanDensity + "\n G=" + this.G + "\n minRadius=" + this.minRadius + "\n maxRadius=" + this.maxRadius + "\n spherical=" + this.spherical;
        string = string + "\ngetNumLayers()=" + this.getNumLayers() + "\n";
        return string;
    }

    public Object clone() {
        try {
            VelocityModel velocityModel = (VelocityModel)super.clone();
            velocityModel.layer = new Vector(this.getNumLayers());
            int n = 0;
            while (n < this.getNumLayers()) {
                velocityModel.layer.addElement(this.getVelocityLayerClone(n));
                ++n;
            }
            return velocityModel;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void print() {
        int n = 0;
        while (n < this.getNumLayers()) {
            System.out.println(this.getVelocityLayer(n));
            ++n;
        }
    }

    public void readVelocityFile(String string) throws IOException, VelocityModelException {
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        String string2 = string.substring(n + 1);
        this.modelName = string2.endsWith("tvel") ? string2.substring(0, string2.length() - 5) : (string2.endsWith(".nd") ? string2.substring(0, string2.length() - 3) : (string2.startsWith("GB.") ? string2.substring(3, string2.length()) : string2));
        if (this.fileType.equalsIgnoreCase("nd")) {
            this.readNDFile(string);
        } else if (this.fileType.equalsIgnoreCase("tvel")) {
            this.readTVelFile(string);
        } else {
            throw new VelocityModelException("What type of velocity file, .tvel or .nd?");
        }
        boolean bl = this.fixDisconDepths();
    }

    public void readCubicSplineFile(String string, String string2) throws IOException {
        System.err.println("readCubicSplineFile not yet implemented.");
    }

    public void readTVelFile(String string) throws IOException, VelocityModelException {
        double d;
        FileReader fileReader = new FileReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
        streamTokenizer.commentChar(35);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.parseNumbers();
        while (streamTokenizer.nextToken() != 10) {
        }
        while (streamTokenizer.nextToken() != 10) {
        }
        int n = 0;
        VelocityLayer velocityLayer = new VelocityLayer(n);
        streamTokenizer.nextToken();
        double d2 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d3 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d4 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != 10) {
            d = streamTokenizer.nval;
            streamTokenizer.nextToken();
        } else {
            d = 5571.0;
        }
        if (streamTokenizer.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + n + " tokenIn=" + streamTokenizer);
        }
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != -1) {
            velocityLayer.topDepth = d2;
            velocityLayer.topPVelocity = d3;
            velocityLayer.topSVelocity = d4;
            velocityLayer.topDensity = d;
            velocityLayer.botDepth = d2 = streamTokenizer.nval;
            streamTokenizer.nextToken();
            velocityLayer.botPVelocity = d3 = streamTokenizer.nval;
            streamTokenizer.nextToken();
            velocityLayer.botSVelocity = d4 = streamTokenizer.nval;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != 10) {
                velocityLayer.botDensity = d = streamTokenizer.nval;
                streamTokenizer.nextToken();
            }
            if (streamTokenizer.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + n + " tokenIn=" + streamTokenizer);
            }
            streamTokenizer.nextToken();
            if (velocityLayer.topDepth == velocityLayer.botDepth) continue;
            this.layer.addElement(velocityLayer);
            velocityLayer = new VelocityLayer(++n);
        }
        this.radiusOfEarth = d2;
        this.maxRadius = d2;
    }

    public void readNDFile(String string) throws IOException, VelocityModelException {
        FileReader fileReader = new FileReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
        streamTokenizer.commentChar(35);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.parseNumbers();
        int n = 0;
        VelocityLayer velocityLayer = new VelocityLayer(n);
        double d = 2.6;
        double d2 = 1000.0;
        double d3 = 2000.0;
        streamTokenizer.nextToken();
        double d4 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d5 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d6 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != 10) {
            d = streamTokenizer.nval;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != 10) {
                d2 = streamTokenizer.nval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 10) {
                    d3 = streamTokenizer.nval;
                    streamTokenizer.nextToken();
                }
            }
        }
        if (streamTokenizer.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + n + " tokenIn=" + streamTokenizer);
        }
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != -1) {
            if (streamTokenizer.ttype == -3) {
                if (streamTokenizer.sval.equalsIgnoreCase("mantle")) {
                    this.mohoDepth = d4;
                }
                if (streamTokenizer.sval.equalsIgnoreCase("outer-core")) {
                    this.cmbDepth = d4;
                }
                if (streamTokenizer.sval.equalsIgnoreCase("inner-core")) {
                    this.iocbDepth = d4;
                }
                while (streamTokenizer.ttype != 10) {
                    streamTokenizer.nextToken();
                }
                streamTokenizer.nextToken();
            }
            velocityLayer.topDepth = d4;
            velocityLayer.topPVelocity = d5;
            velocityLayer.topSVelocity = d6;
            velocityLayer.topDensity = d;
            velocityLayer.topQp = d2;
            velocityLayer.topQs = d3;
            velocityLayer.botDepth = d4 = streamTokenizer.nval;
            streamTokenizer.nextToken();
            velocityLayer.botPVelocity = d5 = streamTokenizer.nval;
            streamTokenizer.nextToken();
            velocityLayer.botSVelocity = d6 = streamTokenizer.nval;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != 10) {
                velocityLayer.botDensity = d = streamTokenizer.nval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 10) {
                    velocityLayer.botQp = d2 = streamTokenizer.nval;
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 10) {
                        velocityLayer.botQs = d3 = streamTokenizer.nval;
                        streamTokenizer.nextToken();
                    }
                }
            }
            if (streamTokenizer.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + n + " tokenIn=" + streamTokenizer);
            }
            streamTokenizer.nextToken();
            if (velocityLayer.topDepth == velocityLayer.botDepth) continue;
            this.layer.addElement(velocityLayer);
            velocityLayer = new VelocityLayer(++n);
        }
        this.radiusOfEarth = d4;
        this.maxRadius = d4;
    }

    public boolean fixDisconDepths() {
        boolean bl = false;
        double d = 65.0;
        double d2 = this.radiusOfEarth;
        double d3 = this.radiusOfEarth - 100.0;
        double d4 = 0.0;
        double d5 = this.radiusOfEarth;
        double d6 = this.radiusOfEarth;
        int n = 0;
        while (n < this.getNumLayers() - 1) {
            VelocityLayer velocityLayer = this.getVelocityLayer(n);
            VelocityLayer velocityLayer2 = this.getVelocityLayer(n + 1);
            if (velocityLayer.botPVelocity != velocityLayer2.topPVelocity || velocityLayer.botSVelocity != velocityLayer2.topSVelocity) {
                if (Math.abs(this.mohoDepth - velocityLayer.botDepth) < d) {
                    d4 = velocityLayer.botDepth;
                    d = Math.abs(this.mohoDepth - velocityLayer.botDepth);
                }
                if (Math.abs(this.cmbDepth - velocityLayer.botDepth) < d2) {
                    d5 = velocityLayer.botDepth;
                    d2 = Math.abs(this.cmbDepth - velocityLayer.botDepth);
                }
                if (velocityLayer.botSVelocity == 0.0 && velocityLayer2.topSVelocity > 0.0 && Math.abs(this.iocbDepth - velocityLayer.botDepth) < d3) {
                    d6 = velocityLayer.botDepth;
                    d3 = Math.abs(this.iocbDepth - velocityLayer.botDepth);
                }
            }
            ++n;
        }
        if (this.mohoDepth != d4 || this.cmbDepth != d5 || this.iocbDepth != d6) {
            bl = true;
        }
        this.mohoDepth = d4;
        this.cmbDepth = d5;
        this.iocbDepth = d5 != d6 ? d6 : this.radiusOfEarth;
        return bl;
    }

    public VelocityModel earthFlattenTransform() throws VelocityModelException {
        VelocityModel velocityModel = (VelocityModel)this.clone();
        velocityModel.spherical = false;
        velocityModel.layer = new Vector(vectorLength);
        int n = 0;
        while (n < this.getNumLayers()) {
            VelocityLayer velocityLayer = this.getVelocityLayerClone(n);
            velocityLayer.topDepth = this.radiusOfEarth * Math.log(velocityLayer.topDepth / this.radiusOfEarth);
            velocityLayer.botDepth = this.radiusOfEarth * Math.log(velocityLayer.botDepth / this.radiusOfEarth);
            velocityLayer.topPVelocity = this.radiusOfEarth * velocityLayer.topPVelocity / velocityLayer.topDepth;
            velocityLayer.botPVelocity = this.radiusOfEarth * velocityLayer.botPVelocity / velocityLayer.botDepth;
            velocityLayer.topSVelocity = this.radiusOfEarth * velocityLayer.topSVelocity / velocityLayer.topDepth;
            velocityLayer.botSVelocity = this.radiusOfEarth * velocityLayer.botSVelocity / velocityLayer.botDepth;
            velocityModel.layer.addElement(velocityLayer);
            ++n;
        }
        return velocityModel;
    }

    public void writeToStream(String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        this.writeToStream(dataOutputStream);
        dataOutputStream.close();
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getClass().getName().length());
        dataOutputStream.writeBytes(this.getClass().getName());
        dataOutputStream.writeInt(this.modelName.length());
        dataOutputStream.writeBytes(this.modelName);
        dataOutputStream.writeDouble(this.radiusOfEarth);
        dataOutputStream.writeDouble(this.mohoDepth);
        dataOutputStream.writeDouble(this.cmbDepth);
        dataOutputStream.writeDouble(this.iocbDepth);
        dataOutputStream.writeDouble(this.meanDensity);
        dataOutputStream.writeDouble(this.G);
        dataOutputStream.writeDouble(this.minRadius);
        dataOutputStream.writeDouble(this.maxRadius);
        dataOutputStream.writeBoolean(this.spherical);
        dataOutputStream.writeInt(this.layer.size());
        int n = 0;
        while (n < this.layer.size()) {
            ((VelocityLayer)this.layer.elementAt(n)).writeToStream(dataOutputStream);
            ++n;
        }
    }

    public static VelocityModel readFromStream(String string) throws FileNotFoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        VelocityModel velocityModel = VelocityModel.readFromStream(dataInputStream);
        dataInputStream.close();
        return velocityModel;
    }

    public static VelocityModel readFromStream(DataInputStream dataInputStream) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.read(byArray);
        Class<?> clazz = Class.forName(new String(byArray));
        VelocityModel velocityModel = (VelocityModel)clazz.newInstance();
        byte[] byArray2 = new byte[dataInputStream.readInt()];
        dataInputStream.read(byArray2);
        velocityModel.modelName = new String(byArray2);
        velocityModel.radiusOfEarth = dataInputStream.readDouble();
        velocityModel.mohoDepth = dataInputStream.readDouble();
        velocityModel.cmbDepth = dataInputStream.readDouble();
        velocityModel.iocbDepth = dataInputStream.readDouble();
        velocityModel.meanDensity = dataInputStream.readDouble();
        velocityModel.G = dataInputStream.readDouble();
        velocityModel.minRadius = dataInputStream.readDouble();
        velocityModel.maxRadius = dataInputStream.readDouble();
        velocityModel.spherical = dataInputStream.readBoolean();
        int n = dataInputStream.readInt();
        velocityModel.layer = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            velocityModel.layer.addElement(VelocityLayer.readFromStream(dataInputStream));
            ++n2;
        }
        return velocityModel;
    }

    public static void main(String[] stringArray) {
        block6: {
            VelocityModel velocityModel = new VelocityModel();
            String string = stringArray.length >= 1 ? stringArray[0] : "iasp91.tvel";
            boolean bl = true;
            try {
                try {
                    velocityModel.readVelocityFile(string);
                    System.out.println("Done reading.");
                    if (!velocityModel.validate()) {
                        System.out.println("FAILED VELOCITY MODEL VALIDATION!");
                    }
                    velocityModel.printGMT(velocityModel.modelName + ".gmt");
                }
                catch (IOException iOException) {
                    System.out.println("Tried to read!\n Caught IOException " + iOException.getMessage());
                    Object var7_5 = null;
                    System.out.println("Done!\n");
                    break block6;
                }
                catch (VelocityModelException velocityModelException) {
                    System.out.println("Tried to read!\n Caught VelocityModelException " + velocityModelException.getMessage());
                    velocityModelException.printStackTrace();
                    Object var7_6 = null;
                    System.out.println("Done!\n");
                }
                Object var7_4 = null;
                System.out.println("Done!\n");
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                System.out.println("Done!\n");
                throw throwable;
            }
        }
    }
}

