/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.NoSuchMatPropException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class VelocityLayer
implements Cloneable,
Serializable {
    private int myLayerNumber;
    public double topDepth;
    public double botDepth;
    public double topPVelocity;
    public double botPVelocity;
    public double topSVelocity;
    public double botSVelocity;
    public double topDensity = 2.6;
    public double botDensity = 2.6;
    public double topQp = 1000.0;
    public double botQp = 1000.0;
    public double topQs = 2000.0;
    public double botQs = 2000.0;

    public VelocityLayer() {
        this.myLayerNumber = 0;
    }

    public VelocityLayer(int n) {
        this.myLayerNumber = n;
    }

    public Object clone() {
        try {
            VelocityLayer velocityLayer = (VelocityLayer)super.clone();
            return velocityLayer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public double evaluateAtBottom(char c) throws NoSuchMatPropException {
        double d;
        switch (c) {
            case 'P': 
            case 'p': {
                d = this.botPVelocity;
                break;
            }
            case 'S': 
            case 's': {
                d = this.botSVelocity;
                break;
            }
            case 'D': 
            case 'R': 
            case 'd': 
            case 'r': {
                d = this.botDensity;
                break;
            }
            default: {
                throw new NoSuchMatPropException(c);
            }
        }
        return d;
    }

    public double evaluateAtTop(char c) throws NoSuchMatPropException {
        double d;
        switch (c) {
            case 'P': 
            case 'p': {
                d = this.topPVelocity;
                break;
            }
            case 'S': 
            case 's': {
                d = this.topSVelocity;
                break;
            }
            case 'D': 
            case 'R': 
            case 'd': 
            case 'r': {
                d = this.topDensity;
                break;
            }
            default: {
                throw new NoSuchMatPropException(c);
            }
        }
        return d;
    }

    public double evaluateAt(double d, char c) throws NoSuchMatPropException {
        double d2;
        switch (c) {
            case 'P': 
            case 'p': {
                double d3 = (this.botPVelocity - this.topPVelocity) / (this.botDepth - this.topDepth);
                d2 = d3 * (d - this.topDepth) + this.topPVelocity;
                break;
            }
            case 'S': 
            case 's': {
                double d4 = (this.botSVelocity - this.topSVelocity) / (this.botDepth - this.topDepth);
                d2 = d4 * (d - this.topDepth) + this.topSVelocity;
                break;
            }
            case 'D': 
            case 'R': 
            case 'd': 
            case 'r': {
                double d5 = (this.botDensity - this.topDensity) / (this.botDepth - this.topDepth);
                d2 = d5 * (d - this.topDepth) + this.topDensity;
                break;
            }
            default: {
                System.out.println("I don't understand this material property: " + c + "\nUse one of P p S s R r D d");
                throw new NoSuchMatPropException(c);
            }
        }
        return d2;
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getClass().getName().length());
        dataOutputStream.writeBytes(this.getClass().getName());
        dataOutputStream.writeInt(this.myLayerNumber);
        dataOutputStream.writeDouble(this.topDepth);
        dataOutputStream.writeDouble(this.botDepth);
        dataOutputStream.writeDouble(this.topPVelocity);
        dataOutputStream.writeDouble(this.botPVelocity);
        dataOutputStream.writeDouble(this.topSVelocity);
        dataOutputStream.writeDouble(this.botSVelocity);
        dataOutputStream.writeDouble(this.topDensity);
        dataOutputStream.writeDouble(this.botDensity);
        dataOutputStream.writeDouble(this.topQp);
        dataOutputStream.writeDouble(this.botQp);
        dataOutputStream.writeDouble(this.topQs);
        dataOutputStream.writeDouble(this.botQs);
    }

    public static VelocityLayer readFromStream(DataInputStream dataInputStream) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.read(byArray);
        Class<?> clazz = Class.forName(new String(byArray));
        VelocityLayer velocityLayer = (VelocityLayer)clazz.newInstance();
        velocityLayer.myLayerNumber = dataInputStream.readInt();
        velocityLayer.topDepth = dataInputStream.readDouble();
        velocityLayer.botDepth = dataInputStream.readDouble();
        velocityLayer.topPVelocity = dataInputStream.readDouble();
        velocityLayer.botPVelocity = dataInputStream.readDouble();
        velocityLayer.topSVelocity = dataInputStream.readDouble();
        velocityLayer.botSVelocity = dataInputStream.readDouble();
        velocityLayer.topDensity = dataInputStream.readDouble();
        velocityLayer.botDensity = dataInputStream.readDouble();
        velocityLayer.topQp = dataInputStream.readDouble();
        velocityLayer.botQp = dataInputStream.readDouble();
        velocityLayer.topQs = dataInputStream.readDouble();
        velocityLayer.botQs = dataInputStream.readDouble();
        return velocityLayer;
    }

    public String toString() {
        String string = this.myLayerNumber + " " + this.topDepth + " " + this.botDepth;
        string = string + " P " + this.topPVelocity + " " + this.botPVelocity;
        string = string + " S " + this.topSVelocity + " " + this.botSVelocity;
        string = string + " Density " + this.topDensity + " " + this.botDensity;
        return string;
    }
}

