/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.Version;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class TauP_Time {
    public boolean DEBUG = false;
    public boolean verbose = false;
    protected String modelName = "iasp91";
    protected TauModel tMod;
    protected transient TauModel tModDepth;
    protected Vector phases = new Vector(10);
    protected Vector phaseNames = new Vector(10);
    protected double depth = 0.0;
    protected double degrees = Double.MAX_VALUE;
    protected double azimuth = Double.MAX_VALUE;
    protected double backAzimuth = Double.MAX_VALUE;
    protected double stationLat = Double.MAX_VALUE;
    protected double stationLon = Double.MAX_VALUE;
    protected double eventLat = Double.MAX_VALUE;
    protected double eventLon = Double.MAX_VALUE;
    protected Vector arrivals = new Vector(10);
    protected boolean GUI = false;
    protected boolean onlyPrintRayP = false;
    protected boolean onlyPrintTime = false;
    protected String outFile = "";
    protected DataOutputStream dos;
    protected Properties toolProps;
    protected Outputs outForms;

    public TauP_Time() {
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception exception) {
            Alert.warning("Unable to load properties, using defaults.", exception.getMessage());
            this.toolProps = new Properties();
        }
        this.outForms = new Outputs(this.toolProps);
    }

    public TauP_Time(TauModel tauModel) throws TauModelException {
        this();
        this.tMod = tauModel;
        this.tModDepth = tauModel;
        this.modelName = tauModel.sMod.vMod.getModelName();
    }

    public TauP_Time(String string) throws TauModelException {
        this();
        try {
            this.loadTauModel(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TauModelException("FileNotFoundException:" + fileNotFoundException.getMessage());
        }
        catch (InvalidClassException invalidClassException) {
            throw new TauModelException("InvalidClassException:" + invalidClassException.getMessage());
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new TauModelException("StreamCorruptedException:" + streamCorruptedException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            throw new TauModelException("OptionalDataException:" + optionalDataException.getMessage());
        }
        catch (IOException iOException) {
            throw new TauModelException("IOException:" + iOException.getMessage());
        }
    }

    public String[] getPhaseNames() {
        String[] stringArray = new String[this.phaseNames.size()];
        int n = 0;
        while (n < this.phaseNames.size()) {
            stringArray[n] = ((PhaseName)this.phaseNames.elementAt(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public String getPhaseNameString() {
        if (this.getNumPhases() == 0) {
            return "";
        }
        String string = ((PhaseName)this.phaseNames.elementAt(0)).getName();
        int n = 1;
        while (n < this.getNumPhases()) {
            string = string + "," + ((PhaseName)this.phaseNames.elementAt(n)).getName();
            ++n;
        }
        return string;
    }

    public void setPhaseNames(String[] stringArray) {
        this.phaseNames.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.appendPhaseName(stringArray[n]);
            ++n;
        }
    }

    public void setPhaseNames(PhaseName[] phaseNameArray) {
        this.phaseNames.removeAllElements();
        int n = 0;
        while (n < phaseNameArray.length) {
            this.phaseNames.addElement(phaseNameArray[n]);
            ++n;
        }
    }

    public synchronized void appendPhaseName(String string) {
        if (string.equalsIgnoreCase("ttp") || string.equalsIgnoreCase("tts") || string.equalsIgnoreCase("ttbasic") || string.equalsIgnoreCase("tts+") || string.equalsIgnoreCase("ttp+") || string.equalsIgnoreCase("ttall")) {
            if (string.equalsIgnoreCase("ttp") || string.equalsIgnoreCase("ttp+") || string.equalsIgnoreCase("ttbasic") || string.equalsIgnoreCase("ttall")) {
                this.appendPhaseName(new PhaseName("p"));
                this.appendPhaseName(new PhaseName("P"));
                this.appendPhaseName(new PhaseName("Pn"));
                this.appendPhaseName(new PhaseName("Pdiff"));
                this.appendPhaseName(new PhaseName("PKP"));
                this.appendPhaseName(new PhaseName("PKiKP"));
                this.appendPhaseName(new PhaseName("PKIKP"));
            }
            if (string.equalsIgnoreCase("tts") || string.equalsIgnoreCase("tts+") || string.equalsIgnoreCase("ttbasic") || string.equalsIgnoreCase("ttall")) {
                this.appendPhaseName(new PhaseName("s"));
                this.appendPhaseName(new PhaseName("S"));
                this.appendPhaseName(new PhaseName("Sn"));
                this.appendPhaseName(new PhaseName("Sdiff"));
                this.appendPhaseName(new PhaseName("SKS"));
                this.appendPhaseName(new PhaseName("SKIKS"));
            }
            if (string.equalsIgnoreCase("ttp+") || string.equalsIgnoreCase("ttbasic") || string.equalsIgnoreCase("ttall")) {
                this.appendPhaseName(new PhaseName("PcP"));
                this.appendPhaseName(new PhaseName("pP"));
                this.appendPhaseName(new PhaseName("pPdiff"));
                this.appendPhaseName(new PhaseName("pPKP"));
                this.appendPhaseName(new PhaseName("pPKIKP"));
                this.appendPhaseName(new PhaseName("pPKiKP"));
                this.appendPhaseName(new PhaseName("sP"));
                this.appendPhaseName(new PhaseName("sPdiff"));
                this.appendPhaseName(new PhaseName("sPKP"));
                this.appendPhaseName(new PhaseName("sPKIKP"));
                this.appendPhaseName(new PhaseName("sPKiKP"));
            }
            if (string.equalsIgnoreCase("tts+") || string.equalsIgnoreCase("ttbasic") || string.equalsIgnoreCase("ttall")) {
                this.appendPhaseName(new PhaseName("sS"));
                this.appendPhaseName(new PhaseName("sSdiff"));
                this.appendPhaseName(new PhaseName("sSKS"));
                this.appendPhaseName(new PhaseName("sSKIKS"));
                this.appendPhaseName(new PhaseName("ScS"));
                this.appendPhaseName(new PhaseName("pS"));
                this.appendPhaseName(new PhaseName("pSdiff"));
                this.appendPhaseName(new PhaseName("pSKS"));
                this.appendPhaseName(new PhaseName("pSKIKS"));
            }
            if (string.equalsIgnoreCase("ttbasic") || string.equalsIgnoreCase("ttall")) {
                this.appendPhaseName(new PhaseName("ScP"));
                this.appendPhaseName(new PhaseName("SKP"));
                this.appendPhaseName(new PhaseName("SKIKP"));
                this.appendPhaseName(new PhaseName("PKKP"));
                this.appendPhaseName(new PhaseName("PKIKKIKP"));
                this.appendPhaseName(new PhaseName("SKKP"));
                this.appendPhaseName(new PhaseName("SKIKKIKP"));
                this.appendPhaseName(new PhaseName("PP"));
                this.appendPhaseName(new PhaseName("PKPPKP"));
                this.appendPhaseName(new PhaseName("PKIKPPKIKP"));
            }
            if (string.equalsIgnoreCase("ttall")) {
                this.appendPhaseName(new PhaseName("SKiKP"));
                this.appendPhaseName(new PhaseName("PP"));
                this.appendPhaseName(new PhaseName("ScS"));
                this.appendPhaseName(new PhaseName("PcS"));
                this.appendPhaseName(new PhaseName("PKS"));
                this.appendPhaseName(new PhaseName("PKIKS"));
                this.appendPhaseName(new PhaseName("PKKS"));
                this.appendPhaseName(new PhaseName("PKIKKIKS"));
                this.appendPhaseName(new PhaseName("SKKS"));
                this.appendPhaseName(new PhaseName("SKIKKIKS"));
                this.appendPhaseName(new PhaseName("SKSSKS"));
                this.appendPhaseName(new PhaseName("SKIKSSKIKS"));
                this.appendPhaseName(new PhaseName("SS"));
                this.appendPhaseName(new PhaseName("SP"));
                this.appendPhaseName(new PhaseName("PS"));
            }
        } else {
            this.appendPhaseName(new PhaseName(string));
        }
    }

    public synchronized void appendPhaseName(PhaseName phaseName) {
        boolean bl = true;
        if (phaseName.name == null || phaseName.name.length() == 0) {
            return;
        }
        int n = 0;
        while (n < this.phaseNames.size()) {
            if (((PhaseName)this.phaseNames.elementAt(n)).equals(phaseName)) {
                bl = false;
                return;
            }
            ++n;
        }
        if (bl) {
            this.phaseNames.addElement(phaseName);
        }
    }

    public int getNumPhases() {
        return this.phaseNames.size();
    }

    public void clearPhaseNames() {
        this.phases.removeAllElements();
        this.phaseNames.removeAllElements();
    }

    public double getSourceDepth() {
        return Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
    }

    public void setSourceDepth(double d) {
        this.depth = d;
        ((Hashtable)this.toolProps).put("taup.source.depth", Double.toString(d));
    }

    public String getTauModelName() {
        return this.modelName;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public void setTauModel(TauModel tauModel) {
        this.tMod = tauModel;
        this.tModDepth = tauModel;
        this.modelName = tauModel.sMod.vMod.getModelName();
        ((Hashtable)this.toolProps).put("taup.model.name", this.modelName);
    }

    public void loadTauModel(String string) throws FileNotFoundException, InvalidClassException, IOException, StreamCorruptedException, OptionalDataException, TauModelException {
        this.modelName = string;
        this.readTauModel();
        this.modelName = this.tMod.sMod.vMod.getModelName();
    }

    public double[] getDisconDepths() {
        return this.tMod.sMod.vMod.getDisconDepths();
    }

    public void clearArrivals() {
        this.arrivals.removeAllElements();
    }

    public int getNumArrivals() {
        return this.arrivals.size();
    }

    public Arrival getArrival(int n) {
        return (Arrival)((Arrival)this.arrivals.elementAt(n)).clone();
    }

    public Arrival[] getArrivals() {
        Arrival[] arrivalArray = new Arrival[this.arrivals.size()];
        int n = 0;
        while (n < this.arrivals.size()) {
            arrivalArray[n] = (Arrival)((Arrival)this.arrivals.elementAt(n)).clone();
            ++n;
        }
        return arrivalArray;
    }

    protected void readTauModel() throws FileNotFoundException, InvalidClassException, IOException, StreamCorruptedException, OptionalDataException, TauModelException {
        try {
            TauModel tauModel = TauModelLoader.load(this.modelName, this.toolProps.getProperty("taup.model.path"));
            if (tauModel != null) {
                this.tModDepth = this.tMod = tauModel;
                this.modelName = this.tMod.sMod.vMod.getModelName();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Alert.error("Caught ClassNotFoundException", classNotFoundException.getMessage() + "\nThere must be something wrong with your installation of TauP.\n" + "Exiting.");
            System.exit(1);
        }
        catch (InvalidClassException invalidClassException) {
            Alert.error("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create.");
        }
    }

    protected void readPhaseFile(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
        streamTokenizer.commentChar(35);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(91, 91);
        streamTokenizer.wordChars(93, 93);
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.sval != null) {
                this.parsePhaseList(streamTokenizer.sval);
                continue;
            }
            if (!this.DEBUG) continue;
            Alert.info("Token.sval was null! nval=" + streamTokenizer.nval);
        }
    }

    public void parsePhaseList(String string) {
        int n = 0;
        string = string.replace(' ', ',');
        int n2 = string.indexOf(",,", n);
        while (n2 != -1) {
            string = string.substring(0, n2) + string.substring(n2 + 1);
            n2 = string.indexOf(",,", n);
        }
        if (string.charAt(0) == ',') {
            if (string.length() > 1) {
                string = string.substring(1);
            } else {
                return;
            }
        }
        if (string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        while (n < string.length()) {
            String string2;
            n2 = string.indexOf(44, n);
            if (n2 != -1) {
                string2 = string.substring(n, n2);
                n = n2 + 1;
            } else {
                string2 = string.substring(n);
                n = string.length();
            }
            n2 = string2.indexOf(45);
            if (n2 == -1) {
                this.appendPhaseName(string2);
                continue;
            }
            if (n2 == string2.length() - 2 && Character.isDigit(string2.charAt(string2.length() - 1))) {
                this.appendPhaseName(new PhaseName(string2.substring(0, n2), Integer.valueOf(string2.substring(n2 + 1, string2.length()))));
                continue;
            }
            Alert.warning("Problem with phase=" + string2, "Skipping this phase.");
        }
    }

    public double[] parseDegreeList(String string) {
        int n = 0;
        int n2 = 0;
        double[] dArray = new double[string.length()];
        while (n < string.length()) {
            String string2;
            int n3 = string.indexOf(44, n);
            if (n3 != -1) {
                string2 = string.substring(n, n3);
                dArray[n2] = Double.valueOf(string2);
                n = n3 + 1;
                ++n2;
                continue;
            }
            string2 = string.substring(n);
            dArray[n2] = Double.valueOf(string2);
            n = string.length();
            ++n2;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        dArray = dArray2;
        return dArray;
    }

    protected String[] parseCmdLineArgs(String[] stringArray) throws IOException {
        int n = 0;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-help")) {
                this.printUsage();
                stringArray2[n2++] = stringArray[n];
            } else if (stringArray[n].equalsIgnoreCase("-version")) {
                Alert.info(Version.getVersion());
                stringArray2[n2++] = stringArray[n];
            } else if (stringArray[n].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            } else if (stringArray[n].equalsIgnoreCase("-debug")) {
                this.verbose = true;
                this.DEBUG = true;
            } else if (stringArray[n].equalsIgnoreCase("-gui")) {
                this.GUI = true;
            } else if (stringArray[n].equalsIgnoreCase("-rayp")) {
                this.onlyPrintRayP = true;
                this.onlyPrintTime = false;
            } else if (stringArray[n].equalsIgnoreCase("-time")) {
                this.onlyPrintTime = true;
                this.onlyPrintRayP = false;
            } else if (n < stringArray.length - 1) {
                if (stringArray[n].equalsIgnoreCase("-mod") || stringArray[n].equalsIgnoreCase("-model")) {
                    ((Hashtable)this.toolProps).put("taup.model.name", stringArray[n + 1]);
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-h")) {
                    ((Hashtable)this.toolProps).put("taup.source.depth", stringArray[n + 1]);
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-deg")) {
                    this.degrees = Double.valueOf(stringArray[n + 1]);
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-km")) {
                    this.degrees = Double.valueOf(stringArray[n + 1]) / 6371.0 * 180.0 / Math.PI;
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-az")) {
                    this.azimuth = Double.valueOf(stringArray[n + 1]);
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-baz")) {
                    this.backAzimuth = Double.valueOf(stringArray[n + 1]);
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-o")) {
                    this.outFile = stringArray[n + 1];
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-ph")) {
                    if (bl) {
                        ((Hashtable)this.toolProps).put("taup.phase.list", this.toolProps.getProperty("taup.phase.list", "") + "," + stringArray[n + 1]);
                    } else {
                        ((Hashtable)this.toolProps).put("taup.phase.list", stringArray[n + 1]);
                    }
                    bl = true;
                    ++n;
                } else if (stringArray[n].equalsIgnoreCase("-pf")) {
                    bl2 = true;
                    ((Hashtable)this.toolProps).put("taup.phase.file", stringArray[n + 1]);
                    ++n;
                } else if (n < stringArray.length - 2) {
                    if (stringArray[n].equalsIgnoreCase("-sta") || stringArray[n].equalsIgnoreCase("-station")) {
                        this.stationLat = Double.valueOf(stringArray[n + 1]);
                        this.stationLon = Double.valueOf(stringArray[n + 2]);
                        n += 2;
                    } else if (stringArray[n].equalsIgnoreCase("-evt") || stringArray[n].equalsIgnoreCase("-event")) {
                        this.eventLat = Double.valueOf(stringArray[n + 1]);
                        this.eventLon = Double.valueOf(stringArray[n + 2]);
                        n += 2;
                    } else {
                        stringArray2[n2++] = stringArray[n];
                    }
                } else {
                    stringArray2[n2++] = stringArray[n];
                }
            } else {
                stringArray2[n2++] = stringArray[n];
            }
            ++n;
        }
        if (bl2 || bl) {
            if (bl2 && !bl) {
                ((Hashtable)this.toolProps).remove("taup.phase.list");
            }
            if (!bl2 && bl) {
                ((Hashtable)this.toolProps).remove("taup.phase.file");
            }
        }
        if (n2 > 0) {
            String[] stringArray3 = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray3, 0, n2);
            return stringArray3;
        }
        return new String[0];
    }

    public synchronized void sortArrivals() {
        if (this.arrivals.size() < 2) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            bl = true;
            Arrival arrival = (Arrival)this.arrivals.elementAt(0);
            int n = 0;
            while (n < this.arrivals.size() - 1) {
                Arrival arrival2 = arrival;
                arrival = (Arrival)this.arrivals.elementAt(n + 1);
                if (arrival2.time > arrival.time) {
                    bl = false;
                    this.arrivals.setElementAt(arrival, n);
                    this.arrivals.setElementAt(arrival2, n + 1);
                    arrival = arrival2;
                }
                ++n;
            }
        }
    }

    public void calculate(double d) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.calcTime(d);
    }

    public void calcTime(double d) {
        this.degrees = d;
        this.arrivals.removeAllElements();
        int n = 0;
        while (n < this.phases.size()) {
            SeismicPhase seismicPhase = (SeismicPhase)this.phases.elementAt(n);
            seismicPhase.setDEBUG(this.DEBUG);
            seismicPhase.calcTime(d);
            Arrival[] arrivalArray = seismicPhase.getArrivals();
            int n2 = 0;
            while (n2 < arrivalArray.length) {
                this.arrivals.addElement(arrivalArray[n2]);
                ++n2;
            }
            ++n;
        }
        this.sortArrivals();
    }

    public void depthCorrect(double d) throws TauModelException {
        if (this.tModDepth == null || this.tModDepth.getSourceDepth() != d) {
            this.tModDepth = this.tMod.depthCorrect(d);
            this.clearArrivals();
            this.recalcPhases();
        }
        this.setSourceDepth(d);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void recalcPhases() {
        Vector<SeismicPhase> vector = new Vector<SeismicPhase>(this.phases.size());
        int n = 0;
        while (true) {
            block13: {
                SeismicPhase seismicPhase;
                if (n >= this.phaseNames.size()) {
                    this.phases = vector;
                    return;
                }
                String string = ((PhaseName)this.phaseNames.elementAt((int)n)).name;
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.phases.size()) {
                    seismicPhase = (SeismicPhase)this.phases.elementAt(n2);
                    if (seismicPhase.name.equals(string)) {
                        this.phases.removeElementAt(n2);
                        if (seismicPhase.sourceDepth == this.depth && seismicPhase.tMod.equals(this.tModDepth)) {
                            vector.addElement(seismicPhase);
                            bl = true;
                            if (!this.verbose) break;
                            Alert.info(seismicPhase.toString());
                            break;
                        }
                    }
                    ++n2;
                }
                if (!bl) {
                    Object var9_8;
                    try {
                        block12: {
                            try {
                                seismicPhase = new SeismicPhase(string, this.tModDepth);
                                seismicPhase.setDEBUG(this.DEBUG);
                                seismicPhase.init();
                                vector.addElement(seismicPhase);
                                if (!this.verbose) break block12;
                                Alert.info(seismicPhase.toString());
                            }
                            catch (TauModelException tauModelException) {
                                Alert.warning("Error with phase=" + string, tauModelException.getMessage() + "\nSkipping this phase");
                                var9_8 = null;
                                if (this.verbose) {
                                    Alert.info("-----------------");
                                }
                                break block13;
                            }
                        }
                        var9_8 = null;
                        if (!this.verbose) break block13;
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (this.verbose) {
                            Alert.info("-----------------");
                        }
                        throw throwable;
                    }
                    Alert.info("-----------------");
                }
            }
            ++n;
        }
    }

    public void printResult(DataOutputStream dataOutputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(dataOutputStream));
        this.printResult(bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    public void printResult(Writer writer) throws IOException {
        int n = 5;
        int n2 = 5;
        int n3 = 0;
        while (n3 < this.arrivals.size()) {
            if (((Arrival)this.arrivals.elementAt((int)n3)).name.length() > n) {
                n = ((Arrival)this.arrivals.elementAt((int)n3)).name.length();
            }
            if (((Arrival)this.arrivals.elementAt((int)n3)).puristName.length() > n2) {
                n2 = ((Arrival)this.arrivals.elementAt((int)n3)).puristName.length();
            }
            ++n3;
        }
        Format format = new Format("%-" + n + "s");
        Format format2 = new Format("%-" + n2 + "s");
        if (!this.onlyPrintRayP && !this.onlyPrintTime) {
            writer.write("\nModel: " + this.modelName + "\n");
            writer.write("Distance   Depth   " + format.form("Phase") + "   Travel    Ray Param   Purist    Purist\n");
            writer.write("  (deg)     (km)   " + format.form("Name ") + "   Time (s)  p (s/deg)  Distance   Name\n");
            int n4 = 0;
            while (n4 < n + n2 + 54) {
                writer.write("-");
                ++n4;
            }
            writer.write("\n");
            int n5 = 0;
            while (n5 < this.arrivals.size()) {
                Arrival arrival = (Arrival)this.arrivals.elementAt(n5);
                writer.write(this.outForms.formatDistance(arrival.getModuloDistDeg()) + this.outForms.formatDepth(this.depth) + "   ");
                writer.write(format.form(arrival.name));
                writer.write("  " + this.outForms.formatTime(arrival.time) + "  " + this.outForms.formatRayParam(Math.PI / 180 * arrival.rayParam) + "   ");
                writer.write(this.outForms.formatDistance(arrival.getDistDeg()));
                if (arrival.name.equals(arrival.puristName)) {
                    writer.write("  = ");
                } else {
                    writer.write("  * ");
                }
                writer.write(format2.form(arrival.puristName) + "\n");
                ++n5;
            }
        } else if (this.onlyPrintTime) {
            int n6 = 0;
            while (n6 < this.arrivals.size()) {
                Arrival arrival = (Arrival)this.arrivals.elementAt(n6);
                writer.write(String.valueOf((float)arrival.time) + " ");
                ++n6;
            }
            writer.write("\n");
        } else if (this.onlyPrintRayP) {
            int n7 = 0;
            while (n7 < this.arrivals.size()) {
                Arrival arrival = (Arrival)this.arrivals.elementAt(n7);
                writer.write(String.valueOf((float)(Math.PI / 180 * arrival.rayParam)) + " ");
                ++n7;
            }
            writer.write("\n");
        }
        writer.write("\n");
    }

    public void init() throws IOException {
        if (this.phaseNames.size() == 0) {
            if (((Hashtable)this.toolProps).containsKey("taup.phase.file")) {
                if (((Hashtable)this.toolProps).containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException iOException) {
                    Alert.warning("Caught IOException while attempting to reading phase file " + this.toolProps.getProperty("taup.phase.file"), iOException.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
            }
        }
        this.depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null || this.tMod.sMod.vMod.getModelName() != this.toolProps.getProperty("taup.model.name", "iasp91")) {
            this.modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException tauModelException) {
                Alert.error("Caught TauModelException", tauModelException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                Alert.error("Can't find saved model file for model " + this.modelName + ".", "");
                System.exit(1);
            }
            catch (InvalidClassException invalidClassException) {
                Alert.error("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create.");
                System.exit(1);
            }
        }
        this.dos = this.outFile != null && this.outFile.length() != 0 ? new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile))) : new DataOutputStream(System.out);
    }

    public void printHelp() {
        Alert.info("Enter:\nh for new depth\nr to recalculate\np to append phases, \nc to clear phases\nl to list phases\ns for new station lat lon\ne for new event lat lon\na for new azimuth\nb for new back azimuth\nm for new model or \nq to quit.\n");
    }

    /*
     * Unable to fully structure code
     */
    public void start() throws IOException, TauModelException, TauPException {
        block70: {
            block69: {
                if (this.degrees == 1.7976931348623157E308 && (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308 || this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308)) break block69;
                if (this.degrees == 1.7976931348623157E308) {
                    this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                    this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                    this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                }
                this.depthCorrect(this.depth);
                this.calculate(this.degrees);
                this.printResult(this.dos);
                break block70;
            }
            var2_1 = 0L;
            var6_2 = 100;
            var7_3 = this.depth;
            this.depthCorrect(this.depth);
            var9_4 = new StreamTokenizer(new InputStreamReader(System.in));
            var9_4.parseNumbers();
            var9_4.wordChars(44, 44);
            var9_4.wordChars(95, 95);
            var9_4.wordChars(94, 94);
            var9_4.ordinaryChar(47);
            var9_4.wordChars(47, 47);
            var9_4.commentChar(35);
            this.printHelp();
            do {
                switch (var6_2) {
                    case 104: {
                        System.out.print("Enter Depth: ");
                        var9_4.nextToken();
                        var7_3 = var9_4.nval;
                        if (var7_3 < 0.0 || var7_3 > this.tMod.getRadiusOfEarth()) {
                            Alert.warning("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().", "depth = " + var7_3 + " getRadiusOfEarth= " + this.tMod.getRadiusOfEarth());
                            break;
                        }
                        var2_1 = System.currentTimeMillis();
                        this.depthCorrect(var7_3);
                        var4_5 = System.currentTimeMillis();
                        if (this.verbose) {
                            Alert.info("depthCorrect time=" + (var4_5 - var2_1));
                        }
                        var6_2 = 100;
                        break;
                    }
                    case 100: {
                        System.out.print("Enter Distance or Option [hrpclseabmq]: ");
                        var9_4.nextToken();
                        if (var9_4.ttype == -2) {
                            this.degrees = var9_4.nval;
                            if (this.DEBUG) {
                                Alert.info("degrees=" + this.degrees);
                            }
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                            break;
                        }
                        if (var9_4.ttype == -1 || var9_4.ttype == -3 && (var9_4.sval.equalsIgnoreCase("q") || var9_4.sval.equalsIgnoreCase("quit") || var9_4.sval.equalsIgnoreCase("exit") || var9_4.sval.equalsIgnoreCase("bye"))) {
                            var6_2 = 113;
                            break;
                        }
                        if (var9_4.ttype == -3) {
                            if (var9_4.sval.equalsIgnoreCase("l")) {
                                var6_2 = 108;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("c")) {
                                var6_2 = 99;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("s")) {
                                var6_2 = 115;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("e")) {
                                var6_2 = 101;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("a")) {
                                var6_2 = 97;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("b")) {
                                var6_2 = 98;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("r")) {
                                var6_2 = 114;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("p")) {
                                var6_2 = 112;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("m")) {
                                var6_2 = 109;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("h")) {
                                var6_2 = 104;
                                break;
                            }
                            if (var9_4.sval.equalsIgnoreCase("?")) {
                                this.printHelp();
                                break;
                            }
                            Alert.warning("I don't understand this option", var9_4.sval);
                            this.printHelp();
                            break;
                        }
                        this.printHelp();
                        break;
                    }
                    case 114: {
                        if (this.degrees != 1.7976931348623157E308) {
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        var6_2 = 100;
                        break;
                    }
                    case 112: {
                        System.out.print("Enter phases (ie P,p,PcP,S): ");
                        var9_4.ordinaryChars(48, 57);
                        var9_4.ordinaryChar(46);
                        var9_4.ordinaryChar(45);
                        var9_4.wordChars(48, 57);
                        var9_4.wordChars(46, 46);
                        var9_4.wordChars(45, 45);
                        var9_4.ordinaryChar(32);
                        var9_4.wordChars(32, 32);
                        var9_4.nextToken();
                        if (var9_4.ttype == -3) {
                            this.parsePhaseList(var9_4.sval);
                            this.recalcPhases();
                        } else {
                            Alert.warning("Input phases not recognized.", "Please retry.");
                        }
                        var9_4.parseNumbers();
                        var9_4.ordinaryChar(32);
                        var9_4.whitespaceChars(32, 32);
                        var6_2 = 100;
                        break;
                    }
                    case 108: {
                        var10_6 = this.phaseNames.size();
                        var11_7 = var10_6 + " phases.";
                        Alert.info(var11_7);
                        var11_7 = "";
                        var12_8 = 0;
                        while (var12_8 < var10_6) {
                            var11_7 = var11_7 + ((PhaseName)this.phaseNames.elementAt((int)var12_8)).name;
                            if (var12_8 < var10_6 - 1) {
                                var11_7 = var11_7 + ",";
                            }
                            ++var12_8;
                        }
                        Alert.info(var11_7);
                        var6_2 = 100;
                        break;
                    }
                    case 99: {
                        this.clearPhaseNames();
                        var6_2 = 112;
                        break;
                    }
                    case 97: {
                        System.out.print("Enter azimuth: ");
                        var9_4.nextToken();
                        if (var9_4.ttype == -2) {
                            this.azimuth = var9_4.nval;
                            this.stationLat = 1.7976931348623157E308;
                            this.stationLon = 1.7976931348623157E308;
                            if (this.DEBUG) {
                                Alert.info("azimuth=" + this.azimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + var9_4 + " instead.");
                            this.printHelp();
                            break;
                        }
                        if (this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308) {
                            var6_2 = 101;
                        } else if (this.degrees == 1.7976931348623157E308) {
                            var6_2 = 100;
                        } else {
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        var6_2 = 100;
                        break;
                    }
                    case 98: {
                        System.out.print("Enter back azimuth: ");
                        var9_4.nextToken();
                        if (var9_4.ttype == -2) {
                            this.backAzimuth = var9_4.nval;
                            this.eventLat = 1.7976931348623157E308;
                            this.eventLon = 1.7976931348623157E308;
                            if (this.DEBUG) {
                                Alert.info("backAzimuth=" + this.backAzimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + var9_4 + " instead");
                            this.printHelp();
                            break;
                        }
                        if (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308) {
                            var6_2 = 115;
                        } else if (this.degrees == 1.7976931348623157E308) {
                            var6_2 = 100;
                        } else {
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        var6_2 = 100;
                        break;
                    }
                    case 101: {
                        System.out.print("Enter event lat and lon: ");
                        var9_4.nextToken();
                        if (var9_4.ttype == -2) {
                            this.eventLat = var9_4.nval;
                            if (this.DEBUG) {
                                Alert.info("eventLat=" + this.eventLat);
                            }
                            var9_4.nextToken();
                            if (var9_4.ttype == -2) {
                                this.eventLon = var9_4.nval;
                                if (this.DEBUG) {
                                    Alert.info("eventLon=" + this.eventLon);
                                }
                            } else {
                                this.printHelp();
                            }
                        } else {
                            this.printHelp();
                        }
                        if (this.stationLat != 1.7976931348623157E308 && this.stationLon != 1.7976931348623157E308) {
                            this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        var6_2 = 100;
                        break;
                    }
                    case 115: {
                        System.out.print("Enter station lat and lon: ");
                        var9_4.nextToken();
                        if (var9_4.ttype != -2) ** GOTO lbl232
                        this.stationLat = var9_4.nval;
                        if (this.DEBUG) {
                            Alert.info("stationLat=" + this.stationLat);
                        }
                        var9_4.nextToken();
                        if (var9_4.ttype == -2) {
                            this.stationLon = var9_4.nval;
                            if (this.DEBUG) {
                                Alert.info("stationLon=" + this.stationLon);
                            }
                        } else {
                            this.printHelp();
                            break;
lbl232:
                            // 1 sources

                            this.printHelp();
                            break;
                        }
                        if (this.eventLat != 1.7976931348623157E308 && this.eventLon != 1.7976931348623157E308) {
                            this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        var6_2 = 100;
                        break;
                    }
                    case 109: {
                        var9_4.ordinaryChars(48, 57);
                        var9_4.wordChars(48, 57);
                        var9_4.ordinaryChars(46, 46);
                        var9_4.wordChars(46, 46);
                        var9_4.ordinaryChars(45, 45);
                        var9_4.wordChars(45, 45);
                        var13_9 = this.modelName;
                        var14_10 = this.tMod;
                        var15_11 = this.tModDepth;
                        System.out.print("Enter model name: ");
                        var9_4.nextToken();
                        if (var9_4.ttype == -3) {
                            this.modelName = var9_4.sval;
                        }
                        var9_4.ordinaryChars(48, 57);
                        var9_4.ordinaryChars(46, 46);
                        var9_4.ordinaryChars(45, 45);
                        var9_4.parseNumbers();
                        if (!this.modelName.equals(var13_9)) {
                            try {
                                this.readTauModel();
                                this.depthCorrect(this.depth);
                            }
                            catch (FileNotFoundException var16_12) {
                                Alert.warning("I can't find model file " + this.modelName, "Still using model " + var13_9 + ".");
                                this.modelName = var13_9;
                                this.tMod = var14_10;
                                this.tModDepth = var15_11;
                            }
                            catch (InvalidClassException var17_13) {
                                Alert.warning("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create. Still using model " + var13_9 + ".");
                                this.modelName = var13_9;
                                this.tMod = var14_10;
                                this.tModDepth = var15_11;
                            }
                        }
                        var6_2 = 100;
                        break;
                    }
                    case 113: {
                        return;
                    }
                }
            } while (var9_4.ttype == -2 || var9_4.ttype != -3 || var9_4.ttype == -3 && !var9_4.sval.equalsIgnoreCase("q"));
        }
    }

    public void destroy() throws IOException {
        if (this.dos != null) {
            this.dos.close();
        }
    }

    public void printStdUsageHead() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        Alert.info("Usage: " + string.toLowerCase() + " [arguments]");
        Alert.info("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        Alert.info("\nArguments are:");
    }

    public void printStdUsage() {
        this.printStdUsageHead();
        Alert.info("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\nDistance is given by:\n\n-deg degrees       -- distance in degrees,\n-km kilometers     -- distance in kilometers,\n                      assumes radius of earth is 6371km,\n\nor by giving the station and event latitude and lonitude,\n                      assumes a spherical earth,\n\n-sta[tion] lat lon -- sets the station latitude and longitude\n-evt       lat lon -- sets the event latitude and longitude\n\n");
    }

    public void printStdUsageTail() {
        Alert.info("\n-o outfile         -- output is redirected to \"outfile\"\n-debug             -- enable debugging output\n-verbose           -- enable verbose output\n-version           -- print the version\n-help              -- print this out, but you already know that!\n");
    }

    public void printUsage() {
        this.printStdUsage();
        Alert.info("-rayp              -- only output the ray parameter\n-time              -- only output travel time");
        this.printStdUsageTail();
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            long l = 0L;
            l = System.currentTimeMillis();
            TauP_Time tauP_Time = new TauP_Time();
            String[] stringArray2 = tauP_Time.parseCmdLineArgs(stringArray);
            if (stringArray2.length > 0) {
                int n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals("-help") || stringArray2[n].equals("-version")) {
                        System.exit(0);
                    }
                    ++n;
                }
                String string = "I don't understand the following arguments, continuing:";
                String string2 = "";
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    string2 = string2 + stringArray2[n2] + " ";
                    ++n2;
                }
                Alert.warning(string, string2);
                stringArray2 = null;
            }
            long l2 = System.currentTimeMillis();
            l = System.currentTimeMillis();
            tauP_Time.init();
            l2 = System.currentTimeMillis();
            if (tauP_Time.DEBUG) {
                Alert.info("taup model read time=" + (l2 - l));
            }
            tauP_Time.start();
            tauP_Time.destroy();
        }
        catch (TauModelException tauModelException) {
            Alert.error("Caught TauModelException", tauModelException.getMessage());
            tauModelException.printStackTrace();
        }
        catch (TauPException tauPException) {
            Alert.error("Caught TauPException", tauPException.getMessage());
            tauPException.printStackTrace();
        }
    }
}

