/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.SacTimeSeries;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;

public class TauP_SetSac
extends TauP_Time {
    protected Vector sacFileNames = new Vector(10);
    protected boolean evdpkm = false;

    public boolean getEvdpkm() {
        return this.evdpkm;
    }

    public void setEvdpkm(boolean bl) {
        this.evdpkm = bl;
    }

    public void setSacFileNames(String[] stringArray) {
        this.sacFileNames.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.sacFileNames.addElement(stringArray[n]);
            ++n;
        }
    }

    protected TauP_SetSac() {
    }

    public TauP_SetSac(TauModel tauModel) throws TauModelException {
        super(tauModel);
    }

    public TauP_SetSac(String string) throws TauModelException {
        super(string);
    }

    protected void setSacVarNums() {
        boolean[] blArray = new boolean[10];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.phaseNames.size() && n2 < 10) {
            if (((PhaseName)this.phaseNames.elementAt((int)n2)).sacTNum != -1) {
                blArray[((PhaseName)this.phaseNames.elementAt((int)n2)).sacTNum] = true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.phaseNames.size()) {
            if (((PhaseName)this.phaseNames.elementAt((int)n3)).sacTNum == -1) {
                int n4 = 0;
                while (n4 < blArray.length && blArray[n4]) {
                    ++n4;
                }
                if (n4 < 10) {
                    ((PhaseName)this.phaseNames.elementAt((int)n3)).sacTNum = n4;
                    blArray[n4] = true;
                }
            }
            ++n3;
        }
    }

    public void calculate(double d) {
        this.recalcPhases();
        this.calcTime(d);
    }

    public void init() throws IOException {
        super.init();
        this.setSacVarNums();
    }

    /*
     * Unable to fully structure code
     */
    public void start() throws IOException, TauModelException {
        var1_1 = new SacTimeSeries();
        var5_2 = 0;
        while (var5_2 < this.sacFileNames.size()) {
            block30: {
                block33: {
                    block32: {
                        block31: {
                            block29: {
                                System.out.println((String)this.sacFileNames.elementAt(var5_2));
                                var1_1.read((String)this.sacFileNames.elementAt(var5_2));
                                if (var1_1.evdp != -12345.0f) break block29;
                                System.out.println("Depth not set in " + (String)this.sacFileNames.elementAt(var5_2) + ", skipping");
                                break block30;
                            }
                            if (var1_1.o != -12345.0f) break block31;
                            System.out.println("O marker not set in " + (String)this.sacFileNames.elementAt(var5_2) + ", skipping");
                            break block30;
                        }
                        if (var1_1.gcarc == -12345.0f) break block32;
                        if (this.verbose) {
                            System.out.println("Using gcarc: " + var1_1.gcarc);
                        }
                        var3_4 = var1_1.gcarc;
                        ** GOTO lbl34
                    }
                    if (var1_1.dist == -12345.0f) break block33;
                    if (this.verbose) {
                        System.out.println("Using dist: " + var1_1.dist);
                    }
                    var3_4 = (double)var1_1.dist / 6371.0 * 180.0 / 3.141592653589793;
                    ** GOTO lbl34
                }
                if (var1_1.stla == -12345.0f || var1_1.stlo == -12345.0f || var1_1.evla == -12345.0f || var1_1.evlo == -12345.0f) {
                    Alert.warning("Can't get a distance, all distance fields are undef.", "skipping " + (String)this.sacFileNames.elementAt(var5_2));
                } else {
                    if (this.verbose) {
                        System.out.println("Using stla,stlo, evla,evlo to calculate");
                    }
                    Alert.warning("Warning: Sac header gcarc is not set,", "using lat and lons to calculate distance.");
                    Alert.warning("No ellipticity correction will be applied.", "This may introduce errors. Please see the manual.");
                    var3_4 = SphericalCoords.distance(var1_1.stla, var1_1.stlo, var1_1.evla, var1_1.evlo);
lbl34:
                    // 3 sources

                    if (!(this.evdpkm && this.depth == (double)var1_1.evdp || !this.evdpkm && this.depth == (double)(1000.0f * var1_1.evdp))) {
                        if (!this.evdpkm && var1_1.evdp != 0.0f && (double)var1_1.evdp < 1000.0) {
                            Alert.warning("Sac header evdp is < 1000 in " + (String)this.sacFileNames.elementAt(var5_2), "If the depth is in kilometers instead of meters (default), you should use the -evdpkm flag");
                        }
                        if (this.evdpkm) {
                            this.depthCorrect(var1_1.evdp);
                        } else {
                            this.depthCorrect((double)var1_1.evdp / 1000.0);
                        }
                    }
                    if (this.verbose) {
                        System.out.println(this.sacFileNames.elementAt(var5_2) + " searching for " + this.getPhaseNameString());
                    }
                    this.calculate(var3_4);
                    if (this.verbose) {
                        System.out.println(this.sacFileNames.elementAt(var5_2) + " " + this.arrivals.size() + " arrivals found.");
                    }
                    var6_5 = this.arrivals.size() - 1;
                    while (var6_5 >= 0) {
                        var2_3 = -1;
                        var7_6 = this.phaseNames.size() - 1;
                        while (var7_6 >= 0) {
                            if (this.getArrival((int)var6_5).name.equals(((PhaseName)this.phaseNames.elementAt((int)var7_6)).name)) {
                                var2_3 = var7_6;
                                break;
                            }
                            --var7_6;
                        }
                        if (var2_3 != -1) {
                            if (this.verbose) {
                                System.out.println(this.sacFileNames.elementAt(var5_2) + " phase found " + this.getArrival((int)var6_5).name + " -> t" + ((PhaseName)this.phaseNames.elementAt((int)var2_3)).sacTNum + ", travel time=" + (float)this.getArrival((int)var6_5).time);
                            }
                            switch (((PhaseName)this.phaseNames.elementAt((int)var2_3)).sacTNum) {
                                case 0: {
                                    var1_1.t0 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt0 = this.getArrival((int)var6_5).name;
                                    System.out.println("0 " + var1_1.t0 + "  " + var1_1.kt0);
                                    break;
                                }
                                case 1: {
                                    var1_1.t1 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt1 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 2: {
                                    var1_1.t2 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt2 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 3: {
                                    var1_1.t3 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt3 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 4: {
                                    var1_1.t4 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt4 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 5: {
                                    var1_1.t5 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt5 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 6: {
                                    var1_1.t6 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt6 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 7: {
                                    var1_1.t7 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt7 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 8: {
                                    var1_1.t8 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt8 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                                case 9: {
                                    var1_1.t9 = var1_1.o + (float)this.getArrival((int)var6_5).time;
                                    var1_1.kt9 = this.getArrival((int)var6_5).name;
                                    break;
                                }
                            }
                        }
                        --var6_5;
                    }
                    var1_1.write((String)this.sacFileNames.elementAt(var5_2));
                }
            }
            ++var5_2;
        }
    }

    public void printStdUsage() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        System.out.println("Usage: " + string.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("-ph phase list     -- comma separated phase list,\n                      use phase-# to specify the sac header,\n                      for example, ScS-8 puts ScS in t8\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n");
    }

    public void printStdUsageTail() {
        System.out.println("\n-debug             -- enable debugging output\n-verbose           -- enable verbose output\n-version           -- print the version\n-help              -- print this out, but you already know that!\n");
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-evdpkm            -- sac depth header is in km, default is meters\n");
        this.printStdUsageTail();
        System.out.println("sacfilename [sacfilename ...]");
        System.out.println("\nEx: taup_setsac -mod S_prem -ph S-8,ScS-9 wmq.r wmq.t wmq.z");
        System.out.println("puts the first S arrival in T8 and ScS in T9");
    }

    public String[] parseCmdLineArgs(String[] stringArray) throws IOException {
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = super.parseCmdLineArgs(stringArray);
        String[] stringArray3 = new String[stringArray2.length];
        while (n < stringArray2.length) {
            if (stringArray2[n].equalsIgnoreCase("-evdpkm")) {
                this.evdpkm = true;
            } else if (stringArray2[n].equals("-help")) {
                stringArray3[n2++] = stringArray2[n];
            } else {
                File file = new File(stringArray2[n]);
                if (file.exists() && file.isFile() && file.canRead()) {
                    this.sacFileNames.addElement(stringArray2[n]);
                } else {
                    stringArray3[n2++] = stringArray2[n];
                }
            }
            ++n;
        }
        if (n2 > 0) {
            String[] stringArray4 = new String[n2];
            System.arraycopy(stringArray3, 0, stringArray4, 0, n2);
            return stringArray4;
        }
        return new String[0];
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        TauP_SetSac tauP_SetSac = new TauP_SetSac();
        if (stringArray.length == 0) {
            tauP_SetSac.printUsage();
            System.exit(1);
        } else {
            try {
                String[] stringArray2 = tauP_SetSac.parseCmdLineArgs(stringArray);
                if (stringArray2.length > 0) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        if (stringArray2[n].equals("-help") || stringArray2[n].equals("-version")) {
                            System.exit(0);
                        }
                        ++n;
                    }
                    System.out.println("I don't understand the following arguments, continuing:");
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        System.out.print(stringArray2[n2] + " ");
                        if (stringArray2[n2].equals("-help") || stringArray2[n2].equals("-version")) {
                            System.out.println();
                            System.exit(0);
                        }
                        ++n2;
                    }
                    System.out.println();
                    stringArray2 = null;
                }
                if (tauP_SetSac.DEBUG) {
                    System.out.println("Done reading " + tauP_SetSac.modelName);
                }
                tauP_SetSac.init();
                tauP_SetSac.start();
            }
            catch (TauModelException tauModelException) {
                System.out.println("Caught TauModelException: " + tauModelException.getMessage());
                tauModelException.printStackTrace();
            }
        }
    }
}

