/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class TauP_Pierce
extends TauP_Time {
    protected boolean onlyTurnPoints = false;
    protected boolean onlyRevPoints = false;
    protected boolean onlyUnderPoints = false;
    protected boolean onlyAddPoints = false;
    protected double[] addDepth = new double[0];

    protected TauP_Pierce() {
    }

    public TauP_Pierce(TauModel tauModel) throws TauModelException {
        super(tauModel);
    }

    public TauP_Pierce(String string) throws TauModelException {
        super(string);
    }

    public void setOnlyTurnPoints(boolean bl) {
        this.onlyTurnPoints = bl;
    }

    public void setOnlyRevPoints(boolean bl) {
        this.onlyRevPoints = bl;
    }

    public void setOnlyUnderPoints(boolean bl) {
        this.onlyUnderPoints = bl;
    }

    public void setOnlyAddPoints(boolean bl) {
        this.onlyAddPoints = bl;
    }

    public void setAddDepths(String string) {
        this.addDepth = this.parseAddDepthsList(string);
    }

    public void appendAddDepths(String string) {
        double[] dArray = this.parseAddDepthsList(string);
        double[] dArray2 = new double[this.addDepth.length + dArray.length];
        System.arraycopy(this.addDepth, 0, dArray2, 0, this.addDepth.length);
        System.arraycopy(dArray, 0, dArray2, this.addDepth.length, dArray.length);
        this.addDepth = dArray2;
    }

    protected double[] parseAddDepthsList(String string) {
        int n = 0;
        int n2 = 0;
        string = string.replace(' ', ',');
        int n3 = string.indexOf(",,", n);
        while (n3 != -1) {
            string = string.substring(0, n3) + string.substring(n3 + 1);
            n3 = string.indexOf(",,", n);
        }
        if (string.charAt(0) == ',') {
            if (string.length() > 1) {
                string = string.substring(1);
            } else {
                return new double[0];
            }
        }
        if (string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        double[] dArray = new double[string.length()];
        while (n < string.length()) {
            String string2;
            n3 = string.indexOf(44, n);
            if (n3 != -1) {
                string2 = string.substring(n, n3);
                dArray[n2] = Double.valueOf(string2);
                n = n3 + 1;
                ++n2;
                continue;
            }
            string2 = string.substring(n);
            dArray[n2] = Double.valueOf(string2);
            n = string.length();
            ++n2;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        dArray = dArray2;
        return dArray;
    }

    public void depthCorrect(double d) throws TauModelException {
        TauModel tauModel = (TauModel)this.tMod.clone();
        TauModel tauModel2 = this.tModDepth;
        boolean bl = false;
        if (this.tModDepth.sourceDepth == d) {
            if (this.addDepth != null) {
                double[] dArray = this.tModDepth.getBranchDepths();
                int n = 0;
                while (n < this.addDepth.length) {
                    int n2 = 0;
                    while (n2 < dArray.length) {
                        if (this.addDepth[n] == dArray[n2]) break;
                        bl = true;
                        ++n2;
                    }
                    if (!bl) {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
        } else {
            bl = true;
        }
        if (!bl) {
            super.depthCorrect(d);
            return;
        }
        this.tModDepth = null;
        try {
            if (this.addDepth != null) {
                int n = 0;
                while (n < this.addDepth.length) {
                    this.tMod = this.tMod.splitBranch(this.addDepth[n]);
                    ++n;
                }
            }
        }
        catch (TauModelException tauModelException) {
            System.err.println("depthCorrect: caught TauModelException: " + tauModelException.getMessage() + "\nSkipping added depth" + " pierce points.");
            this.tMod = tauModel;
            this.tMod = tauModel2;
        }
        super.depthCorrect(d);
        this.tMod = tauModel;
    }

    public void calculate(double d) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.clearArrivals();
        this.calcPierce(d);
    }

    protected void calcPierce(double d) {
        this.degrees = d;
        int n = 0;
        while (n < this.phases.size()) {
            SeismicPhase seismicPhase = (SeismicPhase)this.phases.elementAt(n);
            try {
                seismicPhase.setDEBUG(this.DEBUG);
                seismicPhase.calcTime(d);
                if (seismicPhase.hasArrivals()) {
                    seismicPhase.calcPierce(this.tModDepth);
                    Arrival[] arrivalArray = seismicPhase.getArrivals();
                    int n2 = 0;
                    while (n2 < arrivalArray.length) {
                        this.arrivals.addElement(arrivalArray[n2]);
                        ++n2;
                    }
                }
            }
            catch (TauModelException tauModelException) {
                System.err.println("Caught TauModelException: " + tauModelException.getMessage());
                System.err.println("Skipping phase " + seismicPhase.getName());
            }
            ++n;
        }
    }

    public void printResult(Writer writer) throws IOException {
        boolean bl = false;
        int n = 0;
        while (n < this.arrivals.size()) {
            Arrival arrival = (Arrival)this.arrivals.elementAt(n);
            writer.write("> " + arrival.name + " at " + this.outForms.formatTime(arrival.time) + " seconds at " + this.outForms.formatDistance(arrival.getDistDeg()) + " degrees for a " + this.outForms.formatDepth(arrival.sourceDepth) + " km deep source in the " + this.modelName + " model.\n");
            bl = false;
            if (arrival.dist * 180.0 / Math.PI % 360.0 > 180.0) {
                bl = true;
            }
            double d = arrival.pierce[0].depth;
            int n2 = 0;
            while (n2 < arrival.pierce.length) {
                double d2 = arrival.pierce[n2].time;
                double d3 = arrival.pierce[n2].dist * 180.0 / Math.PI;
                if (bl && d3 != 0.0) {
                    d3 *= -1.0;
                }
                double d4 = n2 < arrival.pierce.length - 1 ? arrival.pierce[n2 + 1].depth : arrival.pierce[n2].depth;
                if (!this.onlyTurnPoints && !this.onlyRevPoints && !this.onlyUnderPoints && !this.onlyAddPoints || this.onlyAddPoints && this.isAddDepth(arrival.pierce[n2].depth) || this.onlyRevPoints && (d - arrival.pierce[n2].depth) * (arrival.pierce[n2].depth - d4) < 0.0 || this.onlyTurnPoints && n2 != 0 && d - arrival.pierce[n2].depth <= 0.0 && arrival.pierce[n2].depth - d4 >= 0.0 || this.onlyUnderPoints && d - arrival.pierce[n2].depth >= 0.0 && arrival.pierce[n2].depth - d4 <= 0.0) {
                    double d5;
                    double d6;
                    writer.write(this.outForms.formatDistance(d3));
                    writer.write(this.outForms.formatDepth(arrival.pierce[n2].depth));
                    writer.write(this.outForms.formatDepth(arrival.pierce[n2].time));
                    if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
                        d6 = SphericalCoords.latFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        d5 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d5));
                    } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
                        d6 = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - d3, this.backAzimuth);
                        d5 = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - d3, this.backAzimuth);
                        writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d5));
                    } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
                        this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                        this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                        d6 = SphericalCoords.latFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        d5 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d5));
                    }
                    writer.write("\n");
                }
                d = arrival.pierce[n2].depth;
                ++n2;
            }
            ++n;
        }
    }

    public synchronized boolean isAddDepth(double d) {
        int n = 0;
        while (n < this.addDepth.length) {
            if (d == this.addDepth[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-az azimuth        -- sets the azimuth (event to station)\n                      used to output lat and lon of pierce points\n                      if the event lat lon and distance are also\n                      given. Calculated if station and event\n                      lat and lon are given.");
        System.out.println("-baz backazimuth   -- sets the back azimuth (station to event)\n                      used to output lat and lon of pierce points\n                      if the station lat lon and distance are also\n                      given. Calculated if station and event\n                      lat and lon are given.\n");
        System.out.println("-rev               -- only prints underside and bottom turn points, e.g. ^ and v");
        System.out.println("-turn              -- only prints bottom turning points, e.g. v");
        System.out.println("-under             -- only prints underside reflection points, e.g. ^\n");
        System.out.println("-pierce depth      -- adds depth for calculating pierce points");
        System.out.println("-nodiscon          -- only prints pierce points for the depths added with -pierce\n");
        this.printStdUsageTail();
    }

    public String[] parseCmdLineArgs(String[] stringArray) throws IOException {
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = super.parseCmdLineArgs(stringArray);
        String[] stringArray3 = new String[stringArray2.length];
        while (n < stringArray2.length) {
            if (stringArray2[n].equalsIgnoreCase("-turn")) {
                this.onlyTurnPoints = true;
            } else if (stringArray2[n].equalsIgnoreCase("-rev")) {
                this.onlyRevPoints = true;
            } else if (stringArray2[n].equalsIgnoreCase("-under")) {
                this.onlyUnderPoints = true;
            } else if (stringArray2[n].equalsIgnoreCase("-pierce") && n < stringArray2.length - 1) {
                this.appendAddDepths(stringArray2[n + 1]);
                ++n;
            } else if (stringArray2[n].equalsIgnoreCase("-nodiscon")) {
                this.onlyAddPoints = true;
            } else {
                stringArray3[n2++] = stringArray2[n].equals("-help") ? stringArray2[n] : stringArray2[n];
            }
            ++n;
        }
        if (n2 > 0) {
            String[] stringArray4 = new String[n2];
            System.arraycopy(stringArray3, 0, stringArray4, 0, n2);
            return stringArray4;
        }
        return new String[0];
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            TauP_Pierce tauP_Pierce = new TauP_Pierce();
            String[] stringArray2 = tauP_Pierce.parseCmdLineArgs(stringArray);
            if (stringArray2.length > 0) {
                int n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals("-help") || stringArray2[n].equals("-version")) {
                        System.exit(0);
                    }
                    ++n;
                }
                System.out.println("I don't understand the following arguments, continuing:");
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    System.out.print(stringArray2[n2] + " ");
                    if (stringArray2[n2].equals("-help") || stringArray2[n2].equals("-version")) {
                        System.out.println();
                        System.exit(0);
                    }
                    ++n2;
                }
                System.out.println();
                stringArray2 = null;
            }
            if (tauP_Pierce.DEBUG) {
                System.out.println("Done reading " + tauP_Pierce.modelName);
            }
            tauP_Pierce.init();
            tauP_Pierce.start();
            tauP_Pierce.destroy();
        }
        catch (TauModelException tauModelException) {
            System.out.println("Caught TauModelException: " + tauModelException.getMessage());
            tauModelException.printStackTrace();
        }
        catch (TauPException tauPException) {
            System.out.println("Caught TauPException: " + tauPException.getMessage());
            tauPException.printStackTrace();
        }
    }
}

