/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;

public class TauP_Peek {
    TauModel tMod;

    public void readTauModel(String string) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        this.tMod = TauModel.readModel(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        String string = stringArray.length == 2 && (stringArray[0].equals("-mod") || stringArray[0].equals("-model")) ? stringArray[1] : "iasp91.taup";
        boolean bl = false;
        double d = 0.0;
        try {
            try {
                TauP_Peek tauP_Peek = new TauP_Peek();
                tauP_Peek.readTauModel(string);
                TauModel tauModel = tauP_Peek.tMod;
                SeismicPhase seismicPhase = new SeismicPhase("S", tauModel);
                seismicPhase.init();
                StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(System.in));
                streamTokenizer.parseNumbers();
                System.out.print("seismic (p)hase or (t)au model or (s)lowness model or (v)elocity model or tau (b)ranch? ");
                int n = 116;
                streamTokenizer.nextToken();
                block20: while (streamTokenizer.nval != -1.0 && !streamTokenizer.sval.equalsIgnoreCase("q")) {
                    if (streamTokenizer.sval.equalsIgnoreCase("t")) {
                        n = 116;
                    } else if (streamTokenizer.sval.equalsIgnoreCase("b")) {
                        n = 98;
                    } else if (streamTokenizer.sval.equalsIgnoreCase("s")) {
                        n = 115;
                    } else if (streamTokenizer.sval.equalsIgnoreCase("v")) {
                        n = 118;
                    } else if (streamTokenizer.sval.equalsIgnoreCase("p")) {
                        n = 112;
                    } else if (streamTokenizer.sval.equalsIgnoreCase("r")) {
                        n = 114;
                    } else {
                        System.out.println("Unrecognized model type: " + (char)n);
                        System.out.println("Using (t)au model.");
                        n = 116;
                    }
                    block2 : switch (n) {
                        case 82: 
                        case 114: {
                            System.out.println("Enter source depth");
                            streamTokenizer.nextToken();
                            d = streamTokenizer.nval;
                            tauModel = tauP_Peek.tMod.depthCorrect(d);
                            double[] dArray = tauModel.getRayParams();
                            int n2 = 0;
                            while (true) {
                                if (n2 >= dArray.length) {
                                    n = 84;
                                    break block2;
                                }
                                System.out.print(dArray[n2] + "  ");
                                if (n2 % 5 == 0) {
                                    System.out.println();
                                }
                                ++n2;
                            }
                        }
                        case 84: 
                        case 116: {
                            System.out.println("spherical=" + tauP_Peek.tMod.spherical + " sourceDepth=" + tauP_Peek.tMod.getSourceDepth() + " radiusOfEarth=" + tauP_Peek.tMod.getRadiusOfEarth() + " DEBUG=" + tauP_Peek.tMod.DEBUG + " rayParams.length=" + tauP_Peek.tMod.rayParams.length + " tauBranches[0].length=" + tauP_Peek.tMod.tauBranches[0].length + " tauBranches[1].length=" + tauP_Peek.tMod.tauBranches[1].length);
                            int n3 = 0;
                            while (true) {
                                if (n3 >= tauP_Peek.tMod.getNumBranches()) {
                                    System.out.println("Enter source depth");
                                    streamTokenizer.nextToken();
                                    d = streamTokenizer.nval;
                                    tauModel = tauP_Peek.tMod.depthCorrect(d);
                                    System.out.println("Enter branch rayNum");
                                    break block2;
                                }
                                System.out.println("peek.tMod.tauBranches[0][" + n3 + "].dist.length=" + tauP_Peek.tMod.tauBranches[0][n3].dist.length + " peek.tMod.tauBranches[1][" + n3 + "].dist.length=" + tauP_Peek.tMod.tauBranches[1][n3].dist.length);
                                ++n3;
                            }
                        }
                        case 83: 
                        case 115: {
                            System.out.println(tauP_Peek.tMod.sMod);
                            System.out.println("Enter slowness layer");
                            break;
                        }
                        case 86: 
                        case 118: {
                            System.out.println(tauP_Peek.tMod.sMod.vMod);
                            System.out.println("Enter velocity layer");
                            break;
                        }
                        case 80: 
                        case 112: {
                            System.out.println("Enter depth");
                            streamTokenizer.nextToken();
                            d = streamTokenizer.nval;
                            tauModel = tauP_Peek.tMod.depthCorrect(d);
                            System.out.println("Enter phase name");
                            streamTokenizer.nextToken();
                            seismicPhase = new SeismicPhase(streamTokenizer.sval, tauModel);
                            seismicPhase.setDEBUG(true);
                            seismicPhase.init();
                            System.out.println("Enter degrees");
                            break;
                        }
                        case 66: 
                        case 98: {
                            System.out.println("Enter source depth");
                            streamTokenizer.nextToken();
                            d = streamTokenizer.nval;
                            tauModel = tauP_Peek.tMod.depthCorrect(d);
                            System.out.println("Enter Branch");
                            break;
                        }
                        default: {
                            System.out.println("Unrecognized model type: " + (char)n);
                            System.out.println("Using (t)au model.");
                            n = 116;
                        }
                    }
                    streamTokenizer.nextToken();
                    while (true) {
                        if (streamTokenizer.ttype != -2) {
                            System.out.print("(t)au model or (s)lowness model or (v)elocity model? ");
                            streamTokenizer.nextToken();
                            continue block20;
                        }
                        block10 : switch (n) {
                            case 84: 
                            case 116: {
                                int n4 = (int)streamTokenizer.nval;
                                streamTokenizer.nextToken();
                                int n5 = (int)streamTokenizer.nval;
                                if (n4 >= tauModel.getNumBranches() || n5 >= tauModel.rayParams.length) {
                                    System.out.println("Out of bounds!");
                                } else {
                                    System.out.println("ray parameter=" + tauModel.rayParams[n5] + " distance=" + tauModel.tauBranches[0][n4].dist[n5] + " time=" + tauModel.tauBranches[0][n4].time[n5] + " tau=" + tauModel.tauBranches[0][n4].tau[n5]);
                                    System.out.println("ray parameter=" + tauModel.rayParams[n5] + " distance=" + tauModel.tauBranches[1][n4].dist[n5] + " time=" + tauModel.tauBranches[1][n4].time[n5] + " tau=" + tauModel.tauBranches[1][n4].tau[n5]);
                                }
                                System.out.println("Enter branch rayNum");
                                break;
                            }
                            case 83: 
                            case 115: {
                                int n6 = (int)streamTokenizer.nval;
                                if (n6 >= tauP_Peek.tMod.sMod.getNumLayers(true)) {
                                    System.out.println("P wave Out of bounds!");
                                } else {
                                    System.out.println(tauP_Peek.tMod.sMod.getSlownessLayer(n6, true));
                                }
                                if (n6 >= tauP_Peek.tMod.sMod.getNumLayers(false)) {
                                    System.out.println("S wave Out of bounds!");
                                } else {
                                    System.out.println(tauP_Peek.tMod.sMod.getSlownessLayer(n6, false));
                                }
                                System.out.println("Enter slowness layer");
                                break;
                            }
                            case 66: 
                            case 98: {
                                int n4 = (int)streamTokenizer.nval;
                                if (n4 >= tauModel.getNumBranches()) {
                                    System.out.println("Out of bounds!");
                                } else {
                                    System.out.println(tauModel.tauBranches[0][n4]);
                                    System.out.println(tauModel.tauBranches[1][n4]);
                                }
                                System.out.println("Enter Branch");
                                break;
                            }
                            case 86: 
                            case 118: {
                                int n6 = (int)streamTokenizer.nval;
                                if (n6 >= tauP_Peek.tMod.sMod.vMod.getNumLayers()) {
                                    System.out.println("Out of bounds!");
                                } else {
                                    System.out.println(tauP_Peek.tMod.sMod.vMod.getVelocityLayerClone(n6));
                                }
                                System.out.println("Enter velocity layer");
                                break;
                            }
                            case 80: 
                            case 112: {
                                seismicPhase.calcTime(streamTokenizer.nval);
                                seismicPhase.calcPierce(tauModel);
                                System.out.println("MaxRayParamIndex=" + seismicPhase.getMaxRayParamIndex() + " MinRayParamIndex=" + seismicPhase.getMinRayParamIndex());
                                Arrival[] arrivalArray = seismicPhase.getArrivals();
                                int n7 = 0;
                                while (true) {
                                    if (n7 >= arrivalArray.length) {
                                        System.out.println("Enter degrees");
                                        break block10;
                                    }
                                    System.out.println(arrivalArray[n7]);
                                    ++n7;
                                }
                            }
                        }
                        streamTokenizer.nextToken();
                    }
                }
            }
            catch (TauModelException tauModelException) {
                System.out.println("Caught TauModelException " + tauModelException.getMessage());
                tauModelException.printStackTrace();
                Object var19_20 = null;
                System.out.println("Done!\n");
                return;
            }
            catch (IOException iOException) {
                System.out.println("Tried to read!\n Caught IOException " + iOException.getMessage());
                Object var19_21 = null;
                System.out.println("Done!\n");
                return;
            }
            Object var19_19 = null;
            System.out.println("Done!\n");
            return;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            System.out.println("Done!\n");
            throw throwable;
        }
    }
}

