/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Pierce;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class TauP_Path
extends TauP_Pierce {
    protected float mapWidth = 6.0f;
    protected boolean gmtScript = false;
    protected double maxPathInc = 1.0;
    protected static Format float8_4 = new Format("%8.4f");

    protected TauP_Path() {
        this.outFile = null;
    }

    public TauP_Path(TauModel tauModel) throws TauModelException {
        super(tauModel);
        this.outFile = null;
    }

    public TauP_Path(String string) throws TauModelException {
        super(string);
        this.outFile = null;
    }

    public TauP_Path(TauModel tauModel, String string) throws TauModelException {
        super(tauModel);
        this.setOutFileBase(string);
    }

    public TauP_Path(String string, String string2) throws TauModelException {
        super(string);
        this.setOutFileBase(string2);
    }

    public void setOutFileBase(String string) {
        this.outFile = string != null && string.length() != 0 ? string + ".gmt" : "taup_path.gmt";
    }

    public void setMapWidth() {
        this.mapWidth = this.mapWidth;
    }

    public float getMapWidth() {
        return this.mapWidth;
    }

    public boolean getGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean bl) {
        this.gmtScript = bl;
    }

    public double getMaxPathInc() {
        return this.maxPathInc;
    }

    public void setMaxPathInc(double d) {
        this.maxPathInc = d;
    }

    public void calculate(double d) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.clearArrivals();
        this.calcPath(d);
    }

    public void calcPath(double d) {
        this.degrees = d;
        int n = 0;
        while (n < this.phases.size()) {
            SeismicPhase seismicPhase = (SeismicPhase)this.phases.elementAt(n);
            seismicPhase.setDEBUG(this.DEBUG);
            seismicPhase.calcTime(d);
            if (seismicPhase.hasArrivals()) {
                seismicPhase.calcPath(this.tModDepth);
                Arrival[] arrivalArray = seismicPhase.getArrivals();
                int n2 = 0;
                while (n2 < arrivalArray.length) {
                    this.arrivals.addElement(arrivalArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void printResult(Writer writer) throws IOException {
        double d = this.tModDepth.getRadiusOfEarth();
        Format format = new Format("%12.5f");
        int n = 0;
        while (n < this.arrivals.size()) {
            Arrival arrival = (Arrival)this.arrivals.elementAt(n);
            writer.write("> " + arrival.name + " at " + this.outForms.formatDistance(arrival.getDistDeg()) + " degrees for a " + this.outForms.formatDepth(arrival.sourceDepth) + " km deep source in the " + this.modelName + " model.\n");
            boolean bl = false;
            if (arrival.dist * 180.0 / Math.PI % 360.0 > 180.0) {
                bl = true;
            }
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = arrival.sourceDepth;
            int n2 = 0;
            while (n2 < arrival.path.length) {
                d2 = arrival.path[n2].time;
                double d5 = d4 = arrival.path[n2].depth;
                d3 = arrival.path[n2].dist * 180.0 / Math.PI;
                if (bl && d3 != 0.0) {
                    d3 = -1.0 * d3;
                }
                writer.write(this.outForms.formatDistance(d3) + "  " + this.outForms.formatDepth(d - d4));
                if (!this.gmtScript) {
                    writer.write("  " + this.outForms.formatTime(d2));
                    this.printLatLon(writer, d3);
                }
                writer.write("\n");
                if (n2 < arrival.path.length - 1 && arrival.rayParam != 0.0 && 57.29577951308232 * (arrival.path[n2 + 1].dist - arrival.path[n2].dist) > this.maxPathInc) {
                    int n3 = (int)Math.ceil((arrival.path[n2 + 1].dist - arrival.path[n2].dist) * 180.0 / Math.PI / this.maxPathInc);
                    int n4 = 1;
                    while (n4 < n3) {
                        d2 += (arrival.path[n2 + 1].time - arrival.path[n2].time) / (double)n3;
                        d3 = bl ? (d3 -= (arrival.path[n2 + 1].dist - arrival.path[n2].dist) / (double)n3 * 180.0 / Math.PI) : (d3 += (arrival.path[n2 + 1].dist - arrival.path[n2].dist) / (double)n3 * 180.0 / Math.PI);
                        d4 = d5 + (double)n4 * (arrival.path[n2 + 1].depth - d5) / (double)n3;
                        writer.write(this.outForms.formatDistance(d3) + "  " + this.outForms.formatDepth(d - d4));
                        if (!this.gmtScript) {
                            writer.write("  " + this.outForms.formatTime(d2));
                            this.printLatLon(writer, d3);
                        }
                        writer.write("\n");
                        ++n4;
                    }
                }
                d5 = arrival.path[n2].depth;
                ++n2;
            }
            ++n;
        }
    }

    protected void printLatLon(Writer writer, double d) throws IOException {
        if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
            double d2 = SphericalCoords.latFor(this.eventLat, this.eventLon, d, this.azimuth);
            double d3 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d, this.azimuth);
            writer.write("  " + this.outForms.formatLatLon(d2) + "  " + this.outForms.formatLatLon(d3));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
            double d4 = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - d, this.backAzimuth);
            double d5 = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - d, this.backAzimuth);
            writer.write("  " + this.outForms.formatLatLon(d4) + "  " + this.outForms.formatLatLon(d5));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
            double d6 = SphericalCoords.latFor(this.eventLat, this.eventLon, d, this.azimuth);
            double d7 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d, this.azimuth);
            writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d7));
        }
    }

    public void init() throws IOException {
        super.init();
        if (this.gmtScript) {
            String string;
            if (this.outFile == null) {
                this.outFile = "taup_path.gmt";
                string = "taup_path.ps";
            } else {
                string = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
            }
            this.dos.writeBytes("#!/bin/sh\n");
            this.dos.writeBytes("#\n# This script will plot ray paths using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, to the last psxy, as well as the last line.\n#\n");
            this.dos.writeBytes("/bin/rm -f " + string + "\n\n");
            this.dos.writeBytes("# draw surface and label distances.\npsbasemap -K -P -R0/360/0/6371 -JP" + this.mapWidth + " -B30p/500N > " + string + "\n\n");
            this.dos.writeBytes("# draw circles for branches, note these are scaled for a \n# map using -JP" + this.mapWidth + "\n" + "psxy -K -O -P -R -JP -Sc -A >> " + string + " <<ENDLAYERS\n");
            int n = 0;
            while (n < 2) {
                this.dos.writeBytes("0.0 0.0 " + (float)(this.tMod.getRadiusOfEarth() * (double)this.mapWidth / this.tMod.getRadiusOfEarth()) + "\n");
                int n2 = 0;
                while (n2 < this.tMod.tauBranches[n].length) {
                    this.dos.writeBytes("0.0 0.0 " + (float)((this.tMod.getRadiusOfEarth() - this.tMod.tauBranches[n][n2].getBotDepth()) * (double)this.mapWidth / this.tMod.getRadiusOfEarth()) + "\n");
                    ++n2;
                }
                ++n;
            }
            this.dos.writeBytes("ENDLAYERS\n\n");
            this.dos.writeBytes("# draw paths\n");
            this.dos.writeBytes("psxy -P -R -O -JP -M -A >> " + string + " <<END\n");
        }
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-gmt             -- outputs path as a complete GMT script.");
        this.printStdUsageTail();
    }

    public String[] parseCmdLineArgs(String[] stringArray) throws IOException {
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = super.parseCmdLineArgs(stringArray);
        String[] stringArray3 = new String[stringArray2.length];
        while (n < stringArray2.length) {
            if (stringArray2[n].equalsIgnoreCase("-gmt")) {
                this.gmtScript = true;
            } else {
                stringArray3[n2++] = stringArray2[n].equals("-help") ? stringArray2[n] : stringArray2[n];
            }
            ++n;
        }
        if (n2 > 0) {
            String[] stringArray4 = new String[n2];
            System.arraycopy(stringArray3, 0, stringArray4, 0, n2);
            return stringArray4;
        }
        return new String[0];
    }

    public void start() throws IOException, TauModelException, TauPException {
        super.start();
    }

    public void destroy() throws IOException {
        if (this.gmtScript) {
            this.dos.writeBytes("END\n");
        }
        super.destroy();
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            TauP_Path tauP_Path = new TauP_Path();
            tauP_Path.setOutFileBase("taup_path");
            String[] stringArray2 = tauP_Path.parseCmdLineArgs(stringArray);
            if (stringArray2.length > 0) {
                int n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals("-help") || stringArray2[n].equals("-version")) {
                        System.exit(0);
                    }
                    ++n;
                }
                System.out.println("I don't understand the following arguments, continuing:");
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    System.out.print(stringArray2[n2] + " ");
                    if (stringArray2[n2].equals("-help") || stringArray2[n2].equals("-version")) {
                        System.out.println();
                        System.exit(0);
                    }
                    ++n2;
                }
                System.out.println();
                stringArray2 = null;
            }
            tauP_Path.init();
            if (tauP_Path.DEBUG) {
                System.out.println("Done reading " + tauP_Path.modelName);
            }
            tauP_Path.start();
            tauP_Path.destroy();
        }
        catch (TauModelException tauModelException) {
            System.out.println("Caught TauModelException: " + tauModelException.getMessage());
            tauModelException.printStackTrace();
        }
        catch (TauPException tauPException) {
            System.out.println("Caught TauPException: " + tauPException.getMessage());
            tauPException.printStackTrace();
        }
    }
}

