/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.io.Writer;

public class TauP_Curve
extends TauP_Time {
    protected boolean gmtScript = false;
    protected boolean reduceTime = false;
    protected double reduceVel = 0.002181661564992912;

    protected TauP_Curve() {
    }

    public TauP_Curve(TauModel tauModel) throws TauModelException {
        super(tauModel);
    }

    public TauP_Curve(String string) throws TauModelException {
        super(string);
    }

    public boolean isGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean bl) {
        this.gmtScript = bl;
    }

    public boolean isReduceTime() {
        return this.reduceTime;
    }

    public void setReduceTime(boolean bl) {
        this.reduceTime = bl;
    }

    public double getReduceVelDeg() {
        return 57.29577951308232 * this.reduceVel;
    }

    public void setReduceVelDeg(double d) {
        if (d > 0.0) {
            this.reduceVel = Math.PI / 180 * d;
        }
    }

    public double getReduceVelKm() {
        return this.reduceVel * this.tMod.getRadiusOfEarth();
    }

    public void setReduceVelKm(double d) {
        if (d > 0.0) {
            this.reduceVel = this.tMod != null ? d / this.tMod.getRadiusOfEarth() : d / 6371.0;
        }
    }

    public void calculate(double d) {
        this.recalcPhases();
    }

    public void init() throws IOException {
        super.init();
        if (this.gmtScript) {
            String string = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
            this.dos.writeBytes("#!/bin/sh\n");
            this.dos.writeBytes("#\n# This script will plot curves using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, as well as the last line.\n#\n");
            this.dos.writeBytes("/bin/rm -f " + string + "\n\n");
        }
    }

    public void printStdUsage() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        System.out.println("Usage: " + string.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\n");
    }

    public void printStdUsageTail() {
        System.out.println("\n-o outfile         -- output is redirected to \"outfile\" instead of taup_curve.gmt\n-debug             -- enable debugging output\n-verbose           -- enable verbose output\n-version           -- print the version\n-help              -- print this out, but you already know that!\n\n");
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-gmt               -- outputs curves as a complete GMT script.");
        System.out.println("-reddeg velocity   -- outputs curves with a reducing velocity (deg/sec).");
        System.out.println("-redkm velocity    -- outputs curves with a reducing velocity (km/sec).");
        this.printStdUsageTail();
    }

    public void start() throws IOException, TauModelException {
        if (this.depth != -1.7976931348623157E308) {
            this.depthCorrect(Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0")));
            this.calculate(this.degrees);
            this.printResult(this.dos);
        } else {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(System.in));
            streamTokenizer.parseNumbers();
            streamTokenizer.wordChars(44, 44);
            streamTokenizer.wordChars(95, 95);
            System.out.print("Enter Depth: ");
            streamTokenizer.nextToken();
            double d = streamTokenizer.nval;
            if (d < 0.0 || this.depth > this.tMod.getRadiusOfEarth()) {
                System.out.println("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().\ndepth = " + d);
                return;
            }
            this.depthCorrect(d);
            this.calculate(this.degrees);
            this.printResult(this.dos);
        }
    }

    public void destroy() throws IOException {
        if (this.gmtScript) {
            this.dos.writeBytes("END\n");
        }
        super.destroy();
    }

    public void printResult(Writer writer) throws IOException {
        double d;
        double d2;
        double[] dArray;
        double[] dArray2;
        SeismicPhase seismicPhase;
        int n;
        double d3 = -1.7976931348623157E308;
        double d4 = Double.MAX_VALUE;
        if (this.gmtScript) {
            String string = "";
            String string2 = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
            n = 0;
            while (n < this.phases.size()) {
                seismicPhase = (SeismicPhase)this.phases.elementAt(n);
                dArray2 = seismicPhase.getDist();
                dArray = seismicPhase.getTime();
                if (dArray2.length > 0) {
                    int n2;
                    d2 = Math.acos(Math.cos(dArray2[dArray2.length - 1]));
                    if (this.reduceTime) {
                        string = string + (float)(57.29577951308232 * d2) + "  " + (float)(dArray[dArray2.length - 1] - d2 / this.reduceVel) + " 10 0 0 9 " + seismicPhase.getName() + "\n";
                        n2 = 0;
                        while (n2 < dArray.length) {
                            d = dArray[n2] - Math.acos(Math.cos(dArray2[n2])) / this.reduceVel;
                            if (d > d3) {
                                d3 = d;
                            }
                            if (d < d4) {
                                d4 = d;
                            }
                            ++n2;
                        }
                    } else {
                        string = string + (float)(57.29577951308232 * d2) + "  " + (float)dArray[dArray2.length - 1] + " 10 0 0 1 " + seismicPhase.getName() + "\n";
                        n2 = 0;
                        while (n2 < dArray.length) {
                            if (dArray[n2] > d3) {
                                d3 = dArray[n2];
                            }
                            if (dArray[n2] < d4) {
                                d4 = dArray[n2];
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
            d3 = Math.ceil(d3 / 100.0) * 100.0;
            d4 = Math.floor(d4 / 100.0) * 100.0;
            writer.write("pstext -JX6 -P -R0/180/" + d4 + "/" + d3 + " -B20/100/:.'" + this.modelName + "': -K > " + string2 + " <<END\n");
            writer.write(string);
            writer.write("END\n\n");
            writer.write("psxy -JX -R -M -O >> " + string2 + " <<END\n");
        }
        int n3 = 0;
        while (n3 < this.phases.size()) {
            seismicPhase = (SeismicPhase)this.phases.elementAt(n3);
            dArray2 = seismicPhase.getDist();
            dArray = seismicPhase.getTime();
            double[] dArray3 = seismicPhase.getRayParams();
            if (dArray2.length > 0) {
                writer.write("> " + seismicPhase.getName() + " for a source depth of " + this.depth + " kilometers in the " + this.modelName + " model\n");
            }
            int n4 = 0;
            while (n4 < dArray2.length) {
                d2 = Math.acos(Math.cos(dArray2[n4]));
                d = this.reduceTime ? dArray[n4] - d2 / this.reduceVel : dArray[n4];
                writer.write((float)(57.29577951308232 * d2) + "  " + (float)d + "\n");
                if (n4 < dArray2.length - 1 && dArray3[n4] == dArray3[n4 + 1] && dArray3.length > 2) {
                    writer.write("> Shadow Zone\n");
                } else {
                    Arrival[] arrivalArray;
                    if (n4 < dArray2.length - 1 && Math.sin(dArray2[n4]) > 0.0 && Math.sin(dArray2[n4 + 1]) < 0.0) {
                        seismicPhase.calcTime(180.0);
                        arrivalArray = seismicPhase.getArrivals();
                        n = 0;
                        while (n < arrivalArray.length) {
                            if ((seismicPhase.rayParams[n4] - arrivalArray[n].rayParam) * (arrivalArray[n].rayParam - seismicPhase.rayParams[n4 + 1]) > 0.0) {
                                if (this.reduceTime) {
                                    writer.write("180.0  " + (float)(arrivalArray[n].time - Math.PI / this.reduceVel) + "\n");
                                    break;
                                }
                                writer.write("180.0  " + (float)arrivalArray[n].time + "\n");
                                break;
                            }
                            ++n;
                        }
                    }
                    if (n4 < dArray2.length - 1 && Math.sin(dArray2[n4]) < 0.0 && Math.sin(dArray2[n4 + 1]) > 0.0) {
                        seismicPhase.calcTime(0.0);
                        arrivalArray = seismicPhase.getArrivals();
                        n = 0;
                        while (n < arrivalArray.length) {
                            if ((seismicPhase.rayParams[n4] - arrivalArray[n].rayParam) * (arrivalArray[n].rayParam - seismicPhase.rayParams[n4 + 1]) > 0.0) {
                                writer.write("0.0  " + (float)arrivalArray[n].time + "\n");
                                break;
                            }
                            ++n;
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
    }

    public String[] parseCmdLineArgs(String[] stringArray) throws IOException {
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = super.parseCmdLineArgs(stringArray);
        String[] stringArray3 = new String[stringArray2.length];
        while (n < stringArray2.length) {
            if (stringArray2[n].equalsIgnoreCase("-gmt")) {
                this.gmtScript = true;
            } else if (stringArray2[n].equals("-reddeg")) {
                this.setReduceTime(true);
                this.setReduceVelDeg(Double.valueOf(stringArray2[n + 1]));
                ++n;
            } else if (stringArray2[n].equals("-redkm")) {
                this.setReduceTime(true);
                this.setReduceVelKm(Double.valueOf(stringArray2[n + 1]));
                ++n;
            } else {
                stringArray3[n2++] = stringArray2[n].equals("-help") ? stringArray2[n] : stringArray2[n];
            }
            ++n;
        }
        if (n2 > 0) {
            String[] stringArray4 = new String[n2];
            System.arraycopy(stringArray3, 0, stringArray4, 0, n2);
            return stringArray4;
        }
        return new String[0];
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        boolean bl = true;
        try {
            int n;
            TauP_Curve tauP_Curve = new TauP_Curve();
            tauP_Curve.outFile = "taup_curve.gmt";
            String[] stringArray2 = tauP_Curve.parseCmdLineArgs(stringArray);
            if (stringArray2.length > 0) {
                n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals("-help") || stringArray2[n].equals("-version")) {
                        System.exit(0);
                    }
                    ++n;
                }
                System.out.println("I don't understand the following arguments, continuing:");
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    System.out.print(stringArray2[n2] + " ");
                    if (stringArray2[n2].equals("-help")) {
                        System.out.println();
                        System.exit(0);
                    }
                    ++n2;
                }
                System.out.println();
                stringArray2 = null;
            }
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == "-h") {
                    bl = false;
                }
                ++n;
            }
            if (tauP_Curve.DEBUG) {
                System.out.println("Done reading " + tauP_Curve.modelName);
            }
            tauP_Curve.init();
            if (bl) {
                tauP_Curve.start();
            } else {
                tauP_Curve.depthCorrect(Double.valueOf(tauP_Curve.toolProps.getProperty("taup.source.depth", "0.0")));
                tauP_Curve.calculate(tauP_Curve.degrees);
                tauP_Curve.printResult(tauP_Curve.dos);
            }
            tauP_Curve.destroy();
        }
        catch (TauModelException tauModelException) {
            System.out.println("Caught TauModelException: " + tauModelException.getMessage());
            tauModelException.printStackTrace();
        }
    }
}

