/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.Version;
import java.io.IOException;
import java.util.Properties;

public class TauP_Create {
    public transient boolean verbose = false;
    String modelFilename = "iasp91.tvel";
    protected String velFileType = "tvel";
    String directory = ".";
    SlownessModel sMod;
    VelocityModel vMod;
    TauModel tMod;
    boolean DEBUG = false;
    protected boolean GUI = false;
    protected Properties toolProps;

    public TauP_Create() {
        Alert.setGUI(this.GUI);
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception exception) {
            Alert.warning("Unable to load properties, using defaults.", exception.getMessage());
            this.toolProps = new Properties();
        }
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setModelFilename(String string) {
        this.modelFilename = string;
    }

    public String getModelFilename() {
        return this.modelFilename;
    }

    public void setDEBUG(boolean bl) {
        this.DEBUG = bl;
    }

    public boolean getDEBUG() {
        return this.DEBUG;
    }

    public void setVelocityModel(VelocityModel velocityModel) {
        this.vMod = velocityModel;
    }

    public VelocityModel getVelocityModel() {
        return this.vMod;
    }

    public void setSlownessModel(SlownessModel slownessModel) {
        this.sMod = slownessModel;
    }

    public SlownessModel getSlownessModel() {
        return this.sMod;
    }

    public void setTauModel(TauModel tauModel) {
        this.tMod = tauModel;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public void printUsage() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        System.out.println("Usage: " + string.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("\n   To specify the velocity model:");
        System.out.println("-nd modelfile       -- \"named discontinuities\" velocity file");
        System.out.println("-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n");
        System.out.println("-debug              -- enable debugging output\n-verbose            -- enable verbose output\n-version            -- print the version\n-help               -- print this out, but you already know that!\n\n");
    }

    protected String[] parseCmdLineArgs(String[] stringArray) {
        int n = 0;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-help")) {
                this.printUsage();
                stringArray2[n2++] = stringArray[n];
                return stringArray2;
            }
            if (stringArray[n].equalsIgnoreCase("-version")) {
                System.out.println(Version.getVersion());
                stringArray2[n2++] = stringArray[n];
                return stringArray2;
            }
            if (stringArray[n].equalsIgnoreCase("-debug")) {
                this.verbose = true;
                this.DEBUG = true;
            } else if (stringArray[n].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            } else if (stringArray[n].equalsIgnoreCase("-gui")) {
                this.GUI = true;
            } else if (n < stringArray.length - 1 && stringArray[n].equalsIgnoreCase("-nd")) {
                this.velFileType = "nd";
                this.parseFileName(stringArray[n + 1]);
                ++n;
            } else if (n < stringArray.length - 1 && stringArray[n].equalsIgnoreCase("-tvel")) {
                this.velFileType = "tvel";
                this.parseFileName(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].startsWith("GB.")) {
                this.velFileType = "nd";
                this.parseFileName(stringArray[n]);
            } else if (stringArray[n].endsWith(".nd")) {
                this.velFileType = "nd";
                this.parseFileName(stringArray[n]);
            } else if (stringArray[n].endsWith(".tvel")) {
                this.velFileType = "tvel";
                this.parseFileName(stringArray[n]);
            } else {
                stringArray2[n2++] = stringArray[n];
            }
            ++n;
        }
        if (n2 > 0) {
            String[] stringArray3 = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray3, 0, n2);
            return stringArray3;
        }
        return new String[0];
    }

    public static void main(String[] stringArray) throws SlownessModelException, TauModelException {
        System.out.println("TauP_Create starting...");
        TauP_Create tauP_Create = new TauP_Create();
        String[] stringArray2 = tauP_Create.parseCmdLineArgs(stringArray);
        if (stringArray2.length > 0) {
            int n = 0;
            while (n < stringArray2.length) {
                if (stringArray2[n].equals("-help") || stringArray2[n].equals("-version")) {
                    System.exit(0);
                }
                ++n;
            }
            System.out.println("I don't understand the following arguments, continuing:");
            int n2 = 0;
            while (n2 < stringArray2.length) {
                System.out.print(stringArray2[n2] + " ");
                ++n2;
            }
            System.out.println();
            stringArray2 = null;
        }
        try {
            tauP_Create.init();
            tauP_Create.start();
            System.out.println("Done!");
        }
        catch (IOException iOException) {
            System.out.println("Tried to read!\n Caught IOException " + iOException.getMessage() + "\nCheck that the file exists and is readable.");
        }
        catch (VelocityModelException velocityModelException) {
            System.out.println("Caught VelocityModelException " + velocityModelException.getMessage() + "\nCheck your velocity model.");
        }
    }

    public void parseFileName(String string) {
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        this.modelFilename = string.substring(n + 1);
        this.directory = n == -1 ? "." : string.substring(0, n);
    }

    public void init() throws IOException, VelocityModelException {
        String string = System.getProperty("file.separator");
        this.vMod = new VelocityModel();
        this.vMod.setFileType(this.velFileType);
        if (this.verbose) {
            System.out.println("filename =" + this.directory + string + this.modelFilename);
        }
        this.vMod.readVelocityFile(this.directory + string + this.modelFilename);
        if (this.verbose) {
            System.out.println("Done reading velocity model.");
            System.out.println("Radius of model " + this.vMod.getModelName() + " is " + this.vMod.getRadiusOfEarth());
        }
        if (this.DEBUG) {
            System.out.println(this.vMod);
        }
    }

    public void start() throws SlownessModelException, TauModelException {
        block18: {
            try {
                block17: {
                    try {
                        long l = System.currentTimeMillis();
                        String string = System.getProperty("file.separator");
                        if (this.vMod.getSpherical()) {
                            this.sMod = new SphericalSModel();
                        } else {
                            System.out.println("Flat slowness model not yet implemented.\n   Using spherical slowness model.");
                            this.sMod = new SphericalSModel();
                        }
                        this.sMod.DEBUG = this.DEBUG;
                        this.sMod.setMinDeltaP(Double.valueOf(this.toolProps.getProperty("taup.create.minDeltaP", "0.1")));
                        this.sMod.setMaxDeltaP(Double.valueOf(this.toolProps.getProperty("taup.create.maxDeltaP", "11.0")));
                        this.sMod.setMaxDepthInterval(Double.valueOf(this.toolProps.getProperty("taup.create.maxDepthInterval", "115.0")));
                        this.sMod.setMaxRangeInterval(Double.valueOf(this.toolProps.getProperty("taup.create.maxRangeInterval", "1.75")));
                        this.sMod.setMaxInterpError(Double.valueOf(this.toolProps.getProperty("taup.create.maxInterpError", "0.05")));
                        this.sMod.setAllowInnerCoreS(Boolean.valueOf(this.toolProps.getProperty("taup.create.allowInnerCoreS", "true")));
                        if (this.verbose) {
                            System.out.println("Parameters are:");
                            System.out.println("taup.create.minDeltaP = " + this.sMod.getMinDeltaP() + " sec / radian");
                            System.out.println("taup.create.maxDeltaP = " + this.sMod.getMaxDeltaP() + " sec / radian");
                            System.out.println("taup.create.maxDepthInterval = " + this.sMod.getMaxDepthInterval() + " kilometers");
                            System.out.println("taup.create.maxRangeInterval = " + this.sMod.getMaxRangeInterval() + " degrees");
                            System.out.println("taup.create.maxInterpError = " + this.sMod.getMaxInterpError() + " seconds");
                            System.out.println("taup.create.allowInnerCoreS = " + this.sMod.isAllowInnerCoreS());
                        }
                        this.sMod.createSample(this.vMod);
                        long l2 = System.currentTimeMillis();
                        if (this.verbose) {
                            System.out.println("Slow model time=" + (l2 - l) + " " + this.sMod.getNumLayers(true) + " P layers," + this.sMod.getNumLayers(false) + " S layers");
                        }
                        l = l2;
                        if (this.DEBUG) {
                            System.out.println(this.sMod);
                        }
                        this.tMod = new TauModel();
                        this.tMod.DEBUG = this.DEBUG;
                        this.tMod.calcTauIncFrom(this.sMod);
                        l2 = System.currentTimeMillis();
                        if (this.verbose) {
                            System.out.println("T model time=" + (l2 - l));
                        }
                        l = l2;
                        if (this.DEBUG) {
                            System.out.println("Done calculating Tau branches.");
                        }
                        if (this.DEBUG) {
                            this.tMod.print();
                        }
                        String string2 = this.directory.equals(".") ? this.directory + string + this.vMod.getModelName() + ".taup" : this.vMod.getModelName() + ".taup";
                        this.tMod.writeModel(string2);
                        if (!this.verbose) break block17;
                        System.out.println("Done Saving " + string2);
                    }
                    catch (IOException iOException) {
                        System.out.println("Tried to write!\n Caught IOException " + iOException.getMessage() + "\nDo you have write permission in this directory?");
                        Object var8_7 = null;
                        if (this.verbose) {
                            System.out.println("Done!");
                        }
                        break block18;
                    }
                    catch (VelocityModelException velocityModelException) {
                        System.out.println("Caught VelocityModelException " + velocityModelException.getMessage());
                        Object var8_8 = null;
                        if (this.verbose) {
                            System.out.println("Done!");
                        }
                    }
                }
                Object var8_6 = null;
                if (this.verbose) {
                    System.out.println("Done!");
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (this.verbose) {
                    System.out.println("Done!");
                }
                throw throwable;
            }
        }
    }
}

