/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.SplitLayerInfo;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;

public class TauModel
implements Serializable,
Cloneable {
    public transient boolean DEBUG = false;
    public boolean spherical = true;
    protected double sourceDepth = 0.0;
    protected int sourceBranch = 0;
    protected double[] noDisconDepths = new double[0];
    protected double mohoDepth;
    protected int mohoBranch;
    protected double cmbDepth;
    protected int cmbBranch;
    protected double iocbDepth;
    protected int iocbBranch;
    protected double radiusOfEarth = 6371.0;
    public SlownessModel sMod;
    protected double[] rayParams;
    public TauBranch[][] tauBranches = new TauBranch[2][];

    public String getModelName() {
        return this.sMod.vMod.getModelName();
    }

    public SlownessModel getSlownessModel() {
        return this.sMod;
    }

    public VelocityModel getVelocityModel() {
        return this.sMod.vMod;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public int getSourceBranch() {
        return this.sourceBranch;
    }

    public double[] getNoDisconDepths() {
        return this.noDisconDepths;
    }

    public boolean isNoDisconBranch(int n) {
        int n2 = 0;
        while (n2 < this.noDisconDepths.length) {
            if (this.noDisconDepths[n2] == this.getTauBranch(n, true).getTopDepth()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isNoDisconDepth(double d) {
        int n = 0;
        while (n < this.noDisconDepths.length) {
            if (this.noDisconDepths[n] == d) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void setNoDisconDepths(double[] dArray) {
        this.noDisconDepths = dArray;
    }

    public synchronized void appendNoDisconDepth(double d) {
        double[] dArray = new double[this.noDisconDepths.length + 1];
        System.arraycopy(this.noDisconDepths, 0, dArray, 0, this.noDisconDepths.length);
        this.noDisconDepths = dArray;
        this.noDisconDepths[this.noDisconDepths.length - 1] = d;
    }

    public double getMohoDepth() {
        return this.mohoDepth;
    }

    public int getMohoBranch() {
        return this.mohoBranch;
    }

    public double getCmbDepth() {
        return this.cmbDepth;
    }

    public int getCmbBranch() {
        return this.cmbBranch;
    }

    public double getIocbDepth() {
        return this.iocbDepth;
    }

    public int getIocbBranch() {
        return this.iocbBranch;
    }

    public double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    public double getOneRayParam(int n) {
        return this.rayParams[n];
    }

    public int getNumBranches() {
        return this.tauBranches[0].length;
    }

    public TauBranch getTauBranch(int n, boolean bl) {
        if (bl) {
            return this.tauBranches[0][n];
        }
        return this.tauBranches[1][n];
    }

    public double[] getBranchDepths() {
        double[] dArray = new double[this.getNumBranches()];
        dArray[0] = this.getTauBranch((int)0, (boolean)true).topDepth;
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = this.getTauBranch((int)(n - 1), (boolean)true).botDepth;
            ++n;
        }
        return dArray;
    }

    public double findDepth(double d, boolean bl) throws TauModelException {
        try {
            return this.sMod.findDepth(d, bl);
        }
        catch (SlownessModelException slownessModelException) {
            throw new TauModelException("findDepth: caught SlownessModelException:" + slownessModelException.getMessage());
        }
    }

    public void calcTauIncFrom(SlownessModel slownessModel) throws SlownessModelException, NoSuchLayerException, TauModelException, NoSuchMatPropException {
        TimeDist timeDist = new TimeDist();
        if (this.DEBUG) {
            System.out.println("Size of slowness model: sMod.getNumLayers('P') = " + slownessModel.getNumLayers(true) + ", sMod.getNumLayers('S') = " + slownessModel.getNumLayers(false));
        }
        if (slownessModel.getNumLayers(true) == 0 || slownessModel.getNumLayers(false) == 0) {
            throw new SlownessModelException("Can't calculate tauInc when getNumLayers() = 0. I need more slowness samples.");
        }
        if (!slownessModel.validate()) {
            throw new SlownessModelException("Validation failed: Something is wrong with the slowness model.");
        }
        this.sMod = (SlownessModel)slownessModel.clone();
        this.radiusOfEarth = slownessModel.getRadiusOfEarth();
        this.sourceDepth = 0.0;
        this.sourceBranch = 0;
        int n = slownessModel.getNumCriticalDepths() - 1;
        this.tauBranches[0] = new TauBranch[n];
        this.tauBranches[1] = new TauBranch[n];
        int n2 = 0;
        double d = slownessModel.getSlownessLayerClone((int)0, (boolean)false).topP;
        double[] dArray = new double[2 * slownessModel.getNumLayers(false) + slownessModel.getNumCriticalDepths()];
        dArray[n2] = d;
        ++n2;
        int n3 = 0;
        while (n3 < slownessModel.getNumLayers(false)) {
            SlownessLayer slownessLayer = slownessModel.getSlownessLayer(n3, false);
            if (slownessLayer.topP < d) {
                dArray[n2] = slownessLayer.topP;
                ++n2;
                d = slownessLayer.topP;
            }
            if (slownessLayer.botP < d) {
                dArray[n2] = slownessLayer.botP;
                ++n2;
                d = slownessLayer.botP;
            }
            ++n3;
        }
        this.rayParams = new double[n2];
        System.arraycopy(dArray, 0, this.rayParams, 0, n2);
        dArray = null;
        if (this.DEBUG) {
            System.out.println("Number of slowness samples for tau =" + n2);
        }
        int n4 = 0;
        boolean bl = true;
        while (n4 < 2) {
            d = slownessModel.getSlownessLayerClone((int)0, (boolean)bl).topP;
            int n5 = 0;
            while (n5 < slownessModel.getNumCriticalDepths() - 1) {
                CriticalDepth criticalDepth = slownessModel.getCriticalDepth(n5);
                int n6 = criticalDepth.getLayerNum(bl);
                CriticalDepth criticalDepth2 = slownessModel.getCriticalDepth(n5 + 1);
                int n7 = criticalDepth2.getLayerNum(bl) - 1;
                if (this.DEBUG) {
                    System.out.println("Calculating " + (bl ? "P" : "S") + " tau branch for branch " + n5 + " topCritLayerNum=" + n6 + " botCritLayerNum=" + n7 + "\nminPSoFar=" + d);
                }
                this.tauBranches[n4][n5] = new TauBranch(criticalDepth.depth, criticalDepth2.depth, bl);
                this.tauBranches[n4][n5].DEBUG = this.DEBUG;
                this.tauBranches[n4][n5].createBranch(slownessModel, d, this.rayParams);
                SlownessLayer slownessLayer = slownessModel.getSlownessLayer(n6, bl);
                SlownessLayer slownessLayer2 = slownessModel.getSlownessLayer(n7, bl);
                d = Math.min(d, Math.min(slownessLayer.topP, slownessLayer2.botP));
                slownessLayer2 = slownessModel.getSlownessLayer(slownessModel.layerNumberAbove(criticalDepth2.depth, bl), bl);
                d = Math.min(d, slownessLayer2.botP);
                ++n5;
            }
            ++n4;
            bl = false;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        int n8 = 0;
        while (n8 < this.tauBranches[0].length) {
            TauBranch tauBranch = this.tauBranches[0][n8];
            if (Math.abs(tauBranch.getTopDepth() - slownessModel.vMod.getMohoDepth()) <= d2) {
                this.mohoBranch = n8;
                d2 = Math.abs(tauBranch.getTopDepth() - slownessModel.vMod.getMohoDepth());
            }
            if (Math.abs(tauBranch.getTopDepth() - slownessModel.vMod.getCmbDepth()) < d3) {
                this.cmbBranch = n8;
                d3 = Math.abs(tauBranch.getTopDepth() - slownessModel.vMod.getCmbDepth());
            }
            if (Math.abs(tauBranch.getTopDepth() - slownessModel.vMod.getIocbDepth()) < d4) {
                this.iocbBranch = n8;
                d4 = Math.abs(tauBranch.getTopDepth() - slownessModel.vMod.getIocbDepth());
            }
            ++n8;
        }
        this.mohoDepth = this.tauBranches[0][this.mohoBranch].getTopDepth();
        this.cmbDepth = this.tauBranches[0][this.cmbBranch].getTopDepth();
        this.iocbDepth = this.tauBranches[0][this.iocbBranch].getTopDepth();
        if (!this.validate()) {
            throw new TauModelException("calcTauIncFrom: Validation failed!");
        }
    }

    public int findBranch(double d) throws TauModelException {
        int n = 0;
        while (n < this.tauBranches[0].length) {
            if (this.tauBranches[0][n].topDepth <= d && this.tauBranches[0][n].botDepth > d) {
                return n;
            }
            ++n;
        }
        if (this.tauBranches[0][this.tauBranches[0].length - 1].botDepth == d) {
            return this.tauBranches[0].length - 1;
        }
        throw new TauModelException("No TauBranch contains depth=" + d);
    }

    public TauModel depthCorrect(double d) throws TauModelException {
        if (this.sourceDepth != 0.0) {
            throw new TauModelException("depthCorrect: Can't depth correct a tau model that is not for a surface source.");
        }
        if (d > this.getCmbDepth()) {
            throw new TauModelException("depthCorrect: Can't depth correct for a depth in the core.");
        }
        TauModel tauModel = this.splitBranch(d);
        tauModel.sourceDepth = d;
        tauModel.sourceBranch = tauModel.findBranch(d);
        this.validate();
        return tauModel;
    }

    public TauModel splitBranch(double d) throws TauModelException {
        TauModel tauModel;
        try {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                tauModel = (TauModel)this.clone();
                int n5 = 0;
                while (n5 < tauModel.tauBranches[0].length) {
                    if (tauModel.tauBranches[0][n5].topDepth == d || tauModel.tauBranches[0][n5].botDepth == d) {
                        TauModel tauModel2 = tauModel;
                        Object var29_8 = null;
                        return tauModel2;
                    }
                    ++n5;
                }
                int n6 = -1;
                double d2 = -1.0;
                int n7 = -1;
                double d3 = -1.0;
                int n8 = 1;
                boolean bl = false;
                while (n8 >= 0) {
                    SplitLayerInfo splitLayerInfo = tauModel.sMod.splitLayer(d, bl);
                    if (!splitLayerInfo.movedSample && splitLayerInfo.neededSplit) {
                        n4 = tauModel.sMod.layerNumberAbove(d, bl);
                        SlownessLayer slownessLayer = tauModel.sMod.getSlownessLayer(n4, bl);
                        double d4 = splitLayerInfo.getRayParam();
                        n3 = -1;
                        n2 = 0;
                        while (n2 < tauModel.rayParams.length - 1) {
                            if (tauModel.rayParams[n2] < d4 && tauModel.rayParams[n2 + 1] > d4) {
                                n3 = n2;
                                double[] dArray = tauModel.rayParams;
                                tauModel.rayParams = new double[dArray.length + 1];
                                System.arraycopy(dArray, 0, tauModel.rayParams, 0, n3);
                                tauModel.rayParams[n3] = d4;
                                System.arraycopy(dArray, n3, tauModel.rayParams, n3 + 1, dArray.length - n3);
                                if (bl) {
                                    n6 = n3;
                                    d2 = d4;
                                    break;
                                }
                                n7 = n3;
                                d3 = d4;
                                break;
                            }
                            ++n2;
                        }
                    }
                    --n8;
                    bl = true;
                }
                n4 = tauModel.findBranch(d);
                TauBranch[][] tauBranchArray = new TauBranch[2][tauModel.getNumBranches() + 1];
                int n9 = 0;
                while (n9 < n4) {
                    tauBranchArray[0][n9] = (TauBranch)tauModel.tauBranches[0][n9].clone();
                    tauBranchArray[1][n9] = (TauBranch)tauModel.tauBranches[1][n9].clone();
                    int n10 = tauModel.sMod.layerNumberBelow(tauBranchArray[0][n9].getTopDepth(), true);
                    int n11 = tauModel.sMod.layerNumberAbove(tauBranchArray[0][n9].getBotDepth(), true);
                    n = tauModel.sMod.layerNumberBelow(tauBranchArray[1][n9].getTopDepth(), false);
                    n3 = tauModel.sMod.layerNumberAbove(tauBranchArray[1][n9].getBotDepth(), false);
                    if (n7 != -1) {
                        tauBranchArray[0][n9].insert(d3, tauModel.sMod, n7);
                        tauBranchArray[1][n9].insert(d3, tauModel.sMod, n7);
                    }
                    if (n6 != -1) {
                        tauBranchArray[0][n9].insert(d2, tauModel.sMod, n6);
                        tauBranchArray[1][n9].insert(d2, tauModel.sMod, n6);
                    }
                    ++n9;
                }
                tauModel.appendNoDisconDepth(d);
                n = tauModel.sMod.layerNumberBelow(tauModel.tauBranches[1][n4].getTopDepth(), false);
                int n12 = tauModel.sMod.layerNumberAbove(d, false);
                tauBranchArray[1][n4] = new TauBranch(tauModel.tauBranches[1][n4].getTopDepth(), d, false);
                tauBranchArray[1][n4].createBranch(tauModel.sMod, tauModel.tauBranches[1][n4].getMaxRayParam(), tauModel.rayParams);
                tauBranchArray[1][n4 + 1] = tauModel.tauBranches[1][n4].difference(tauBranchArray[1][n4], n6, n7, tauModel.sMod, tauBranchArray[1][n4].getMinRayParam(), tauModel.rayParams);
                int n13 = tauModel.sMod.layerNumberBelow(tauModel.tauBranches[0][n4].getTopDepth(), true);
                n2 = tauModel.sMod.layerNumberAbove(d, true);
                tauBranchArray[0][n4] = new TauBranch(tauModel.tauBranches[0][n4].getTopDepth(), d, true);
                tauBranchArray[0][n4].createBranch(tauModel.sMod, tauModel.tauBranches[0][n4].getMaxRayParam(), tauModel.rayParams);
                tauBranchArray[0][n4 + 1] = tauModel.tauBranches[0][n4].difference(tauBranchArray[0][n4], n6, n7, tauModel.sMod, tauBranchArray[0][n4].getMinRayParam(), tauModel.rayParams);
                int n14 = n4 + 1;
                while (n14 < tauModel.tauBranches[0].length) {
                    tauBranchArray[1][n14 + 1] = tauModel.tauBranches[1][n14];
                    tauBranchArray[0][n14 + 1] = tauModel.tauBranches[0][n14];
                    if (n7 != -1) {
                        tauBranchArray[0][n14 + 1].insert(d3, tauModel.sMod, n7);
                        tauBranchArray[1][n14 + 1].insert(d3, tauModel.sMod, n7);
                    }
                    if (n6 != -1) {
                        tauBranchArray[0][n14 + 1].insert(d2, tauModel.sMod, n6);
                        tauBranchArray[1][n14 + 1].insert(d2, tauModel.sMod, n6);
                    }
                    ++n14;
                }
                tauModel.tauBranches = tauBranchArray;
                if (tauModel.sourceDepth > d) {
                    ++tauModel.sourceBranch;
                }
                if (tauModel.mohoDepth > d) {
                    ++tauModel.mohoBranch;
                }
                if (tauModel.cmbDepth > d) {
                    ++tauModel.cmbBranch;
                }
                if (tauModel.iocbDepth > d) {
                    ++tauModel.iocbBranch;
                }
                if (!tauModel.validate()) {
                    throw new TauModelException("splitBranch(" + d + "): Validation failed!");
                }
            }
            catch (NoSuchLayerException noSuchLayerException) {
                throw new TauModelException("TauModel.depthCorrect - NoSuchLayerException: " + noSuchLayerException.getMessage());
            }
            catch (SlownessModelException slownessModelException) {
                slownessModelException.printStackTrace();
                throw new TauModelException("TauModel.depthCorrect - SlownessModelException: " + slownessModelException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var29_10 = null;
            throw throwable;
        }
        Object var29_9 = null;
        return tauModel;
    }

    public void writeModel(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        try {
            objectOutputStream.writeObject(this);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            objectOutputStream.close();
            fileOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
        fileOutputStream.close();
    }

    public void writeModelToStream(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
    }

    public static TauModel readModel(String string) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        TauModel tauModel;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        try {
            tauModel = TauModel.readModelFromStream(bufferedInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            bufferedInputStream.close();
            throw throwable;
        }
        bufferedInputStream.close();
        return tauModel;
    }

    public static TauModel readModelFromStream(InputStream inputStream) throws InvalidClassException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        TauModel tauModel = (TauModel)objectInputStream.readObject();
        return tauModel;
    }

    public boolean validate() {
        int n = 0;
        while (n < this.rayParams.length - 1) {
            if (this.rayParams[n + 1] >= this.rayParams[n]) {
                System.err.println("RayParams are not monotonically decreasing. rayParams[" + n + "]=" + this.rayParams[n] + " rayParams[" + (n + 1) + "]=" + this.rayParams[n + 1]);
                return false;
            }
            ++n;
        }
        if (this.tauBranches[0].length != this.tauBranches[1].length) {
            System.err.println("TauBranches for P and S are not equal. " + this.tauBranches[0].length + " " + this.tauBranches[1].length);
            return false;
        }
        if (this.tauBranches[0][0].topDepth != 0.0 || this.tauBranches[1][0].topDepth != 0.0) {
            System.err.println("branch 0 topDepth != 0");
            return false;
        }
        if (this.tauBranches[1][0].maxRayParam != this.rayParams[0]) {
            System.err.println("branch 0 maxRayParam != rayParams[0]");
            return false;
        }
        int n2 = 1;
        while (n2 < this.getNumBranches()) {
            if (this.tauBranches[0][n2].topDepth != this.tauBranches[1][n2].topDepth) {
                System.err.println("branch " + n2 + " P topDepth != S topDepth");
                return false;
            }
            if (this.tauBranches[0][n2].botDepth != this.tauBranches[1][n2].botDepth) {
                System.err.println("branch " + n2 + " P botDepth != S botDepth");
                return false;
            }
            if (this.tauBranches[0][n2].topDepth != this.tauBranches[0][n2 - 1].botDepth) {
                System.err.println("branch " + n2 + " topDepth != botDepth of " + (n2 - 1));
                return false;
            }
            if (this.tauBranches[0][n2].maxRayParam != this.tauBranches[0][n2 - 1].minRayParam) {
                System.err.println("branch " + n2 + " P maxRayParam != minRayParam of " + (n2 - 1) + "\nmaxRayParam=" + this.tauBranches[0][n2].maxRayParam + "\nminRayParam=" + this.tauBranches[0][n2 - 1].minRayParam);
                return false;
            }
            if (this.tauBranches[1][n2].maxRayParam != this.tauBranches[1][n2 - 1].minRayParam) {
                System.err.println("branch " + n2 + " S maxRayParam != minRayParam of " + (n2 - 1) + "\nmaxRayParam=" + this.tauBranches[1][n2].maxRayParam + "\nminRayParam=" + this.tauBranches[1][n2 - 1].minRayParam + "\ndepth = " + this.tauBranches[1][n2].topDepth);
                return false;
            }
            ++n2;
        }
        if (this.tauBranches[0][this.getNumBranches() - 1].minRayParam != 0.0) {
            System.err.println("branch tauBranches[0].length-1 minRayParam != 0");
            return false;
        }
        if (this.tauBranches[1][this.getNumBranches() - 1].minRayParam != 0.0) {
            System.err.println("branch tauBranches[1].length-1 minRayParam != 0");
            return false;
        }
        return true;
    }

    public void print() {
        if (this.DEBUG) {
            System.out.println("Starting print() in TauModel");
        }
        System.out.println("Delta tau for each slowness sample and layer.");
        int n = 0;
        while (n < this.rayParams.length) {
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.getNumBranches()) {
                d += this.tauBranches[0][n2].dist[n] * 180.0 / Math.PI;
                d2 += this.tauBranches[0][n2].time[n];
                System.out.println(" i " + n2 + " j " + n + " rayParam " + this.rayParams[n] + " tau " + this.tauBranches[0][n2].tau[n] + " time " + this.tauBranches[0][n2].time[n] + " dist " + this.tauBranches[0][n2].dist[n] + " degrees " + this.tauBranches[0][n2].dist[n] * 180.0 / Math.PI);
                ++n2;
            }
            System.out.println();
            System.out.println("deg= " + d + "  time=" + d2);
            ++n;
        }
    }

    public Object clone() {
        try {
            TauModel tauModel = (TauModel)super.clone();
            tauModel.rayParams = (double[])this.rayParams.clone();
            tauModel.sMod = (SlownessModel)this.sMod.clone();
            tauModel.tauBranches = new TauBranch[2][this.getNumBranches()];
            int n = 0;
            while (n < this.getNumBranches()) {
                tauModel.tauBranches[0][n] = (TauBranch)this.tauBranches[0][n].clone();
                tauModel.tauBranches[1][n] = (TauBranch)this.tauBranches[1][n].clone();
                ++n;
            }
            return tauModel;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Caught CloneNotSupportedException: " + cloneNotSupportedException.getMessage());
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        if (this.DEBUG) {
            System.out.println("Starting toString() in TauModel");
        }
        String string = "Delta tau for each slowness sample and layer.\n";
        int n = 0;
        while (n < this.rayParams.length) {
            int n2 = 0;
            while (n2 < this.tauBranches[0].length) {
                string = string + " i " + n2 + " j " + n + " rayParam " + this.rayParams[n] + " tau " + this.tauBranches[0][n2].tau[n] + " time " + this.tauBranches[0][n2].time[n] + " dist " + this.tauBranches[0][n2].dist[n] + " degrees " + this.tauBranches[0][n2].dist[n] * 180.0 / Math.PI + "\n";
                ++n2;
            }
            string = string + "\n";
            ++n;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        block8: {
            VelocityModel velocityModel = new VelocityModel();
            SphericalSModel sphericalSModel = new SphericalSModel();
            TauModel tauModel = new TauModel();
            String string = stringArray.length == 1 ? stringArray[0] : "iasp91.tvel";
            boolean bl = false;
            try {
                try {
                    velocityModel.setFileType("tvel");
                    velocityModel.readVelocityFile(string);
                    System.out.println("Done reading.");
                    sphericalSModel.createSample(velocityModel);
                    tauModel.calcTauIncFrom(sphericalSModel);
                    StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(System.in));
                    streamTokenizer.parseNumbers();
                    System.out.println("Enter branch rayNum");
                    streamTokenizer.nextToken();
                    while (streamTokenizer.ttype == -2) {
                        int n = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        int n2 = (int)streamTokenizer.nval;
                        System.out.println("ray parameter=" + tauModel.rayParams[n2] + " distance=" + tauModel.tauBranches[0][n].dist[n2] + " time=" + tauModel.tauBranches[0][n].time[n2] + " tau=" + tauModel.tauBranches[0][n].tau[n2]);
                        System.out.println("Enter branch rayNum");
                        streamTokenizer.nextToken();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Tried to read!\n Caught IOException " + iOException.getMessage());
                    Object var13_11 = null;
                    System.out.println("Done!\n");
                    break block8;
                }
                catch (VelocityModelException velocityModelException) {
                    System.out.println("Tried to read!\n Caught VelocityModelException " + velocityModelException.getMessage());
                    Object var13_12 = null;
                    System.out.println("Done!\n");
                    break block8;
                }
                catch (SlownessModelException slownessModelException) {
                    System.out.println("Caught SlownessModelException " + slownessModelException.getMessage());
                    slownessModelException.printStackTrace();
                    Object var13_13 = null;
                    System.out.println("Done!\n");
                    break block8;
                }
                catch (TauModelException tauModelException) {
                    System.out.println("Caught TauModelException " + tauModelException.getMessage());
                    tauModelException.printStackTrace();
                    Object var13_14 = null;
                    System.out.println("Done!\n");
                }
                Object var13_10 = null;
                System.out.println("Done!\n");
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                System.out.println("Done!\n");
                throw throwable;
            }
        }
    }
}

