/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Assert;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class TauBranch
implements Serializable,
Cloneable {
    public transient boolean DEBUG = false;
    protected boolean isPWave;
    protected double topDepth;
    protected double botDepth;
    protected double maxRayParam;
    protected double minTurnRayParam;
    protected double minRayParam;
    protected double[] dist;
    protected double[] time;
    protected double[] tau;

    public TauBranch(double d, double d2, boolean bl) {
        this.topDepth = d;
        this.botDepth = d2;
        this.isPWave = bl;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBotDepth() {
        return this.botDepth;
    }

    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    public double getMinTurnRayParam() {
        return this.minTurnRayParam;
    }

    public double getMinRayParam() {
        return this.minRayParam;
    }

    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    public double[] getTime() {
        return (double[])this.time.clone();
    }

    public double[] getTau() {
        return (double[])this.tau.clone();
    }

    public void createBranch(SlownessModel slownessModel, double d, double[] dArray) throws NoSuchLayerException, SlownessModelException, TauModelException {
        int n = slownessModel.layerNumberBelow(this.topDepth, this.isPWave);
        int n2 = slownessModel.layerNumberAbove(this.botDepth, this.isPWave);
        SlownessLayer slownessLayer = slownessModel.getSlownessLayerClone(n, this.isPWave);
        SlownessLayer slownessLayer2 = slownessModel.getSlownessLayerClone(n2, this.isPWave);
        if (slownessLayer.topDepth != this.topDepth || slownessLayer2.botDepth != this.botDepth) {
            if (slownessLayer.topDepth != this.topDepth && Math.abs(slownessLayer.topDepth - this.topDepth) < 1.0E-6) {
                System.err.println("Changing topDepth: \ntopDepth: " + this.topDepth + " " + slownessLayer.topDepth + "\nbotDepth: " + this.botDepth + " " + slownessLayer2.botDepth);
                this.topDepth = slownessLayer.topDepth;
            } else if (slownessLayer2.botDepth != this.botDepth && Math.abs(slownessLayer2.botDepth - this.botDepth) < 1.0E-6) {
                System.err.println("Changing botDepth: \ntopDepth: " + this.topDepth + " " + slownessLayer.topDepth + "\nbotDepth: " + this.botDepth + " " + slownessLayer2.botDepth);
                this.botDepth = slownessLayer2.botDepth;
            } else {
                throw new TauModelException("createBranch: TauBranch not compatible with slowness sampling:\ntopDepth: " + this.topDepth + " " + slownessLayer.topDepth + "\nbotDepth: " + this.botDepth + " " + slownessLayer2.botDepth);
            }
        }
        this.maxRayParam = d;
        this.minTurnRayParam = slownessModel.getMinTurnRayParam(this.botDepth, this.isPWave);
        this.minRayParam = slownessModel.getMinRayParam(this.botDepth, this.isPWave);
        this.tau = new double[dArray.length];
        this.dist = new double[dArray.length];
        this.time = new double[dArray.length];
        int n3 = 0;
        while (n3 < dArray.length) {
            double d2 = dArray[n3];
            TimeDist timeDist = this.calcTimeDist(slownessModel, n, n2, d2);
            this.dist[n3] = timeDist.dist;
            this.time[n3] = timeDist.time;
            this.tau[n3] = this.time[n3] - d2 * this.dist[n3];
            if (this.DEBUG && n3 % (dArray.length / 10) == 0) {
                System.out.print(n3 + ", ");
            }
            ++n3;
        }
    }

    public TimeDist calcTimeDist(SlownessModel slownessModel, int n, int n2, double d) throws NoSuchLayerException, SlownessModelException {
        TimeDist timeDist = new TimeDist(d);
        if (d <= this.maxRayParam) {
            int n3 = n;
            SlownessLayer slownessLayer = slownessModel.getSlownessLayer(n3, this.isPWave);
            while (n3 <= n2 && d <= slownessLayer.topP && d <= slownessLayer.botP) {
                timeDist.add(slownessModel.layerTimeDist(d, n3, this.isPWave));
                if (++n3 > n2) continue;
                slownessLayer = slownessModel.getSlownessLayerClone(n3, this.isPWave);
            }
            if ((slownessLayer.topP - d) * (d - slownessLayer.botP) > 0.0) {
                throw new SlownessModelException("Ray turns in the middle of this layer. layerNum = " + n3 + " sphericalRayParam " + d + " layer =" + slownessLayer);
            }
        }
        return timeDist;
    }

    protected void insert(double d, SlownessModel slownessModel, int n) throws NoSuchLayerException, SlownessModelException, TauModelException {
        int n2 = slownessModel.layerNumberBelow(this.topDepth, this.isPWave);
        int n3 = slownessModel.layerNumberAbove(this.botDepth, this.isPWave);
        SlownessLayer slownessLayer = slownessModel.getSlownessLayerClone(n2, this.isPWave);
        SlownessLayer slownessLayer2 = slownessModel.getSlownessLayerClone(n3, this.isPWave);
        if (slownessLayer.topDepth != this.topDepth || slownessLayer2.botDepth != this.botDepth) {
            throw new TauModelException("insert: TauBranch depths not compatible with slowness sampling:\ntopDepth: " + this.topDepth + " " + slownessLayer.topDepth + "\nbotDepth: " + this.botDepth + " " + slownessLayer2.botDepth);
        }
        TimeDist timeDist = new TimeDist(d, 0.0, 0.0);
        if (slownessLayer.botP >= d && slownessLayer.topP >= d) {
            int n4 = n2;
            while (n4 <= n3) {
                if (slownessModel.getSlownessLayer((int)n4, (boolean)this.isPWave).botP < d) break;
                TimeDist timeDist2 = slownessModel.layerTimeDist(d, n4, this.isPWave);
                timeDist.dist += timeDist2.dist;
                timeDist.time += timeDist2.time;
                ++n4;
            }
        }
        this.shiftBranch(n);
        this.dist[n] = timeDist.dist;
        this.time[n] = timeDist.time;
        this.tau[n] = timeDist.time - d * timeDist.dist;
    }

    protected TauBranch difference(TauBranch tauBranch, int n, int n2, SlownessModel slownessModel, double d, double[] dArray) throws NoSuchLayerException, SlownessModelException, TauModelException {
        if (tauBranch.topDepth != this.topDepth || tauBranch.botDepth > this.botDepth) {
            if (tauBranch.topDepth != this.topDepth && Math.abs(tauBranch.topDepth - this.topDepth) < 1.0E-6) {
                this.topDepth = tauBranch.topDepth;
            } else {
                throw new TauModelException("createBranch: TauBranch not compatible with slowness sampling:\ntopDepth: " + this.topDepth + " " + tauBranch.topDepth + "\nbotDepth: " + this.botDepth + " " + tauBranch.botDepth);
            }
        }
        if (tauBranch.isPWave != this.isPWave) {
            throw new TauModelException("Can't difference branches: topBranch.topDepth=" + tauBranch.topDepth + " topDepth=" + this.topDepth + " topBranch.botDepth=" + tauBranch.botDepth + " botDepth=" + this.botDepth + " waveTypes:" + tauBranch.isPWave + " " + this.isPWave);
        }
        int n3 = slownessModel.layerNumberBelow(tauBranch.botDepth, this.isPWave);
        int n4 = slownessModel.layerNumberAbove(this.botDepth, this.isPWave);
        SlownessLayer slownessLayer = slownessModel.getSlownessLayer(n3, this.isPWave);
        SlownessLayer slownessLayer2 = slownessModel.getSlownessLayer(n4, this.isPWave);
        if (slownessLayer.topDepth != tauBranch.botDepth || slownessLayer2.botDepth != this.botDepth) {
            throw new TauModelException("difference: TauBranch not compatible with slowness sampling:\ntopDepth: " + tauBranch.botDepth + " " + slownessLayer.topDepth + "\nbotDepth: " + this.botDepth + " " + slownessLayer2.botDepth + "\n" + slownessLayer + "\n" + slownessLayer2);
        }
        SlownessLayer slownessLayer3 = slownessModel.getSlownessLayer(slownessModel.layerNumberBelow(tauBranch.botDepth, true), true);
        if (n >= 0 && slownessLayer3.topP != dArray[n]) {
            throw new TauModelException("difference: P wave index doesn't match top layer.\n " + slownessModel.layerNumberBelow(tauBranch.botDepth, true) + "\n" + dArray[n - 1] + "\n" + dArray[n] + "\n" + dArray[n + 1] + "\nP=" + slownessLayer3 + "\nS=" + slownessModel.getSlownessLayer(slownessModel.layerNumberBelow(tauBranch.botDepth, false), false));
        }
        slownessLayer3 = slownessModel.getSlownessLayer(slownessModel.layerNumberBelow(tauBranch.botDepth, false), false);
        if (n2 >= 0 && slownessLayer3.topP != dArray[n2]) {
            throw new TauModelException("difference: S wave index doesn't match top layer. " + slownessModel.layerNumberBelow(tauBranch.botDepth, false) + " " + dArray[n2 - 1] + " " + dArray[n2] + " " + dArray[n2 + 1] + "\n" + slownessLayer3);
        }
        slownessLayer3 = null;
        TauBranch tauBranch2 = new TauBranch(tauBranch.botDepth, this.botDepth, this.isPWave);
        tauBranch2.maxRayParam = tauBranch.minRayParam;
        tauBranch2.minTurnRayParam = this.minTurnRayParam;
        tauBranch2.minRayParam = this.minRayParam;
        double d2 = -1.0;
        double d3 = -1.0;
        TimeDist timeDist = new TimeDist();
        TimeDist timeDist2 = new TimeDist();
        int n5 = this.dist.length;
        if (n != -1) {
            ++n5;
            d2 = dArray[n];
            timeDist = tauBranch2.calcTimeDist(slownessModel, n3, n4, d2);
        }
        if (n2 != -1 && n2 != n) {
            ++n5;
            d3 = dArray[n2];
            timeDist2 = tauBranch2.calcTimeDist(slownessModel, n3, n4, d3);
        } else {
            n2 = -1;
        }
        tauBranch2.dist = new double[n5];
        tauBranch2.time = new double[n5];
        tauBranch2.tau = new double[n5];
        if (n == -1) {
            int n6 = 0;
            while (n6 < this.dist.length) {
                tauBranch2.dist[n6] = this.dist[n6] - tauBranch.dist[n6];
                tauBranch2.time[n6] = this.time[n6] - tauBranch.time[n6];
                tauBranch2.tau[n6] = this.tau[n6] - tauBranch.tau[n6];
                ++n6;
            }
        } else if (n2 == -1) {
            int n7 = 0;
            while (n7 < n) {
                tauBranch2.dist[n7] = this.dist[n7] - tauBranch.dist[n7];
                tauBranch2.time[n7] = this.time[n7] - tauBranch.time[n7];
                tauBranch2.tau[n7] = this.tau[n7] - tauBranch.tau[n7];
                ++n7;
            }
            tauBranch2.dist[n] = timeDist.dist;
            tauBranch2.time[n] = timeDist.time;
            tauBranch2.tau[n] = timeDist.time - d2 * timeDist.dist;
            int n8 = n;
            while (n8 < this.dist.length) {
                tauBranch2.dist[n8 + 1] = this.dist[n8] - tauBranch.dist[n8 + 1];
                tauBranch2.time[n8 + 1] = this.time[n8] - tauBranch.time[n8 + 1];
                tauBranch2.tau[n8 + 1] = this.tau[n8] - tauBranch.tau[n8 + 1];
                ++n8;
            }
        } else {
            int n9 = 0;
            while (n9 < n2) {
                tauBranch2.dist[n9] = this.dist[n9] - tauBranch.dist[n9];
                tauBranch2.time[n9] = this.time[n9] - tauBranch.time[n9];
                tauBranch2.tau[n9] = this.tau[n9] - tauBranch.tau[n9];
                ++n9;
            }
            tauBranch2.dist[n2] = timeDist2.dist;
            tauBranch2.time[n2] = timeDist2.time;
            tauBranch2.tau[n2] = timeDist2.time - d3 * timeDist2.dist;
            int n10 = n2;
            while (n10 < n) {
                tauBranch2.dist[n10 + 1] = this.dist[n10] - tauBranch.dist[n10 + 1];
                tauBranch2.time[n10 + 1] = this.time[n10] - tauBranch.time[n10 + 1];
                tauBranch2.tau[n10 + 1] = this.tau[n10] - tauBranch.tau[n10 + 1];
                ++n10;
            }
            tauBranch2.dist[n + 1] = timeDist.dist;
            tauBranch2.time[n + 1] = timeDist.time;
            tauBranch2.tau[n + 1] = timeDist.time - d2 * timeDist.dist;
            int n11 = n;
            while (n11 < this.dist.length) {
                tauBranch2.dist[n11 + 2] = this.dist[n11] - tauBranch.dist[n11 + 2];
                tauBranch2.time[n11 + 2] = this.time[n11] - tauBranch.time[n11 + 2];
                tauBranch2.tau[n11 + 2] = this.tau[n11] - tauBranch.tau[n11 + 2];
                ++n11;
            }
        }
        return tauBranch2;
    }

    public void shiftBranch(int n) {
        double[] dArray = new double[this.dist.length + 1];
        System.arraycopy(this.dist, 0, dArray, 0, n);
        dArray[n] = 0.0;
        System.arraycopy(this.dist, n, dArray, n + 1, this.dist.length - n);
        this.dist = dArray;
        double[] dArray2 = new double[this.time.length + 1];
        System.arraycopy(this.time, 0, dArray2, 0, n);
        dArray2[n] = 0.0;
        System.arraycopy(this.time, n, dArray2, n + 1, this.time.length - n);
        this.time = dArray2;
        double[] dArray3 = new double[this.tau.length + 1];
        System.arraycopy(this.tau, 0, dArray3, 0, n);
        dArray3[n] = 0.0;
        System.arraycopy(this.tau, n, dArray3, n + 1, this.tau.length - n);
        this.tau = dArray3;
    }

    public TimeDist[] path(double d, boolean bl, SlownessModel slownessModel) throws SlownessModelException {
        int n;
        int n2;
        if (d > this.maxRayParam) {
            return null;
        }
        Assert.isTrue(d >= 0.0, "ray parameter must not be negative.");
        try {
            n2 = slownessModel.layerNumberBelow(this.topDepth, this.isPWave);
            n = slownessModel.layerNumberAbove(this.botDepth, this.isPWave);
        }
        catch (NoSuchLayerException noSuchLayerException) {
            throw new SlownessModelException("Caught NoSuchLayerException. This likely means theSlownessModel and TauModel are out of sync. " + noSuchLayerException.getMessage());
        }
        TimeDist[] timeDistArray = new TimeDist[n - n2 + 1];
        int n3 = 0;
        SlownessLayer slownessLayer = slownessModel.getSlownessLayer(n2, this.isPWave);
        if (slownessLayer.topDepth != this.topDepth) {
            throw new SlownessModelException("Branch and Slowness model are not compatible! " + slownessLayer.topDepth + " != " + this.topDepth + "=topDepth");
        }
        slownessLayer = slownessModel.getSlownessLayer(n, this.isPWave);
        if (slownessLayer.botDepth != this.botDepth) {
            throw new SlownessModelException("Branch and Slowness model are not compatible! " + slownessLayer.botDepth + " != " + this.botDepth + "=botDepth");
        }
        if (bl) {
            int n4 = n2;
            slownessLayer = slownessModel.getSlownessLayer(n4, this.isPWave);
            while (slownessLayer.botP >= d && n4 <= n) {
                if (!slownessLayer.isZeroThickness()) {
                    timeDistArray[n3] = slownessModel.layerTimeDist(d, n4, this.isPWave);
                    timeDistArray[n3].depth = slownessLayer.botDepth;
                    ++n3;
                }
                if (++n4 > n) continue;
                slownessLayer = slownessModel.getSlownessLayer(n4, this.isPWave);
            }
            if (n4 <= n && !slownessLayer.isZeroThickness()) {
                double d2 = slownessLayer.bullenDepthFor(d, slownessModel.getRadiusOfEarth());
                SlownessLayer slownessLayer2 = new SlownessLayer(slownessLayer.topP, slownessLayer.topDepth, d, d2);
                timeDistArray[n3] = slownessLayer2.bullenRadialSlowness(d, slownessModel.getRadiusOfEarth());
                timeDistArray[n3].depth = slownessLayer2.botDepth;
                ++n3;
            }
        } else {
            int n5 = n;
            slownessLayer = slownessModel.getSlownessLayer(n5, this.isPWave);
            while (slownessLayer.topP <= d || slownessLayer.isZeroThickness()) {
                slownessLayer = slownessModel.getSlownessLayer(--n5, this.isPWave);
            }
            if (slownessLayer.botP < d) {
                double d3 = slownessLayer.bullenDepthFor(d, slownessModel.getRadiusOfEarth());
                SlownessLayer slownessLayer3 = new SlownessLayer(slownessLayer.topP, slownessLayer.topDepth, d, d3);
                timeDistArray[n3] = slownessLayer3.bullenRadialSlowness(d, slownessModel.getRadiusOfEarth());
                timeDistArray[n3].depth = slownessLayer3.topDepth;
                ++n3;
                if (--n5 >= n2) {
                    slownessLayer = slownessModel.getSlownessLayer(n5, this.isPWave);
                }
            }
            while (n5 >= n2) {
                if (!slownessLayer.isZeroThickness()) {
                    timeDistArray[n3] = slownessModel.layerTimeDist(d, n5, this.isPWave);
                    timeDistArray[n3].depth = slownessLayer.topDepth;
                    ++n3;
                }
                if (--n5 < n2) continue;
                slownessLayer = slownessModel.getSlownessLayer(n5, this.isPWave);
            }
        }
        TimeDist[] timeDistArray2 = new TimeDist[n3];
        System.arraycopy(timeDistArray, 0, timeDistArray2, 0, n3);
        return timeDistArray2;
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getClass().getName().length());
        dataOutputStream.writeBytes(this.getClass().getName());
        dataOutputStream.writeDouble(this.topDepth);
        dataOutputStream.writeDouble(this.botDepth);
        dataOutputStream.writeDouble(this.maxRayParam);
        dataOutputStream.writeDouble(this.minRayParam);
        dataOutputStream.writeDouble(this.minTurnRayParam);
        dataOutputStream.writeInt(this.dist.length);
        int n = 0;
        while (n < this.dist.length) {
            dataOutputStream.writeDouble(this.dist[n]);
            ++n;
        }
        dataOutputStream.writeInt(this.time.length);
        int n2 = 0;
        while (n2 < this.time.length) {
            dataOutputStream.writeDouble(this.time[n2]);
            ++n2;
        }
        dataOutputStream.writeInt(this.tau.length);
        int n3 = 0;
        while (n3 < this.tau.length) {
            dataOutputStream.writeDouble(this.tau[n3]);
            ++n3;
        }
    }

    public static TauBranch readFromStream(DataInputStream dataInputStream) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.read(byArray);
        Class<?> clazz = Class.forName(new String(byArray));
        TauBranch tauBranch = (TauBranch)clazz.newInstance();
        tauBranch.topDepth = dataInputStream.readDouble();
        tauBranch.botDepth = dataInputStream.readDouble();
        tauBranch.maxRayParam = dataInputStream.readDouble();
        tauBranch.minRayParam = dataInputStream.readDouble();
        tauBranch.minTurnRayParam = dataInputStream.readDouble();
        int n = dataInputStream.readInt();
        tauBranch.dist = new double[n];
        int n2 = 0;
        while (n2 < tauBranch.dist.length) {
            tauBranch.dist[n2] = dataInputStream.readDouble();
            ++n2;
        }
        n = dataInputStream.readInt();
        tauBranch.time = new double[n];
        int n3 = 0;
        while (n3 < tauBranch.time.length) {
            tauBranch.time[n3] = dataInputStream.readDouble();
            ++n3;
        }
        n = dataInputStream.readInt();
        tauBranch.tau = new double[n];
        int n4 = 0;
        while (n4 < tauBranch.tau.length) {
            tauBranch.tau[n4] = dataInputStream.readDouble();
            ++n4;
        }
        return tauBranch;
    }

    public Object clone() {
        try {
            TauBranch tauBranch = (TauBranch)super.clone();
            tauBranch.dist = (double[])this.dist.clone();
            tauBranch.time = (double[])this.time.clone();
            tauBranch.tau = (double[])this.tau.clone();
            return tauBranch;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Caught CloneNotSupportedException: " + cloneNotSupportedException.getMessage());
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        String string = "Tau Branch\n";
        string = string + " topDepth = " + this.topDepth + "\n";
        string = string + " botDepth = " + this.botDepth + "\n";
        string = string + " maxRayParam=" + this.maxRayParam + " minTurnRayParam=" + this.minTurnRayParam;
        string = string + " minRayParam=" + this.minRayParam + "\n";
        return string;
    }
}

