/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Vector;

public class SeismicPhase
implements Serializable,
Cloneable {
    public transient boolean DEBUG = false;
    public transient boolean verbose = false;
    protected TauModel tMod;
    protected static final int TURN = 0;
    protected static final int REFLECTTOP = 1;
    protected static final int REFLECTBOT = 2;
    protected static final int TRANSUP = 3;
    protected static final int TRANSDOWN = 4;
    protected double maxRefraction = 20.0;
    protected double maxDiffraction = 60.0;
    protected double sourceDepth;
    protected double[] dist = new double[0];
    protected double[] time = new double[0];
    protected double[] rayParams = new double[0];
    protected double minRayParam;
    protected double maxRayParam;
    protected int maxRayParamIndex = -1;
    protected int minRayParamIndex = -1;
    protected double minDistance = 0.0;
    protected double maxDistance = Double.MAX_VALUE;
    protected Vector arrivals = new Vector();
    protected Vector branchSeq = new Vector();
    protected String name;
    protected String puristName;
    protected Vector legs = new Vector();
    protected transient int currBranch;
    protected transient int endAction;
    protected Vector legAction = new Vector();
    protected Vector downGoing = new Vector();
    protected Vector waveType = new Vector();
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    public SeismicPhase(String string, TauModel tauModel) {
        this.name = string;
        this.sourceDepth = tauModel.sourceDepth;
        this.tMod = tauModel;
    }

    public boolean hasArrivals() {
        return this.arrivals.size() > 0;
    }

    public Arrival[] getArrivals() {
        Arrival[] arrivalArray = new Arrival[this.arrivals.size()];
        int n = 0;
        while (n < this.arrivals.size()) {
            arrivalArray[n] = (Arrival)this.arrivals.elementAt(n);
            ++n;
        }
        return arrivalArray;
    }

    public void setTauModel(TauModel tauModel) throws TauModelException {
        this.tMod = tauModel;
        this.init();
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public void setDEBUG(boolean bl) {
        this.DEBUG = bl;
    }

    public double getMinDistance() {
        return this.minDistance;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    public double getMinRayParam() {
        return this.minRayParam;
    }

    public int getMaxRayParamIndex() {
        return this.maxRayParamIndex;
    }

    public int getMinRayParamIndex() {
        return this.minRayParamIndex;
    }

    public double getMaxDiffraction() {
        return this.maxDiffraction;
    }

    public void setMaxDiffraction(double d) {
        this.maxDiffraction = d;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.name;
    }

    public String[] getLegs() {
        String[] stringArray = new String[this.legs.size()];
        int n = 0;
        while (n < this.legs.size()) {
            stringArray[n] = (String)this.legs.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    public double[] getTime() {
        return (double[])this.time.clone();
    }

    public double[] getTau() {
        double[] dArray = new double[this.dist.length];
        int n = 0;
        while (n < this.dist.length) {
            dArray[n] = this.time[n] - this.rayParams[n] * this.dist[n];
            ++n;
        }
        return dArray;
    }

    public void init() throws TauModelException {
        this.legPuller();
        this.createPuristName(this.tMod);
        this.parseName(this.tMod);
        this.sumBranches(this.tMod);
    }

    public void calcTime(double d) {
        double d2 = d;
        if (d2 < 0.0) {
            d2 *= -1.0;
        }
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        if (d2 > 180.0) {
            d2 = 360.0 - d2;
        }
        double d3 = d2 * Math.PI / 180.0;
        this.arrivals.removeAllElements();
        int n = 0;
        while ((double)n * 2.0 * Math.PI + d3 <= this.maxDistance) {
            Arrival arrival;
            double d4 = (double)n * 2.0 * Math.PI + d3;
            int n2 = 0;
            while (n2 < this.dist.length - 1) {
                if (!(d4 == this.dist[n2 + 1] && n2 + 1 != this.dist.length - 1 || !((this.dist[n2] - d4) * (d4 - this.dist[n2 + 1]) >= 0.0) || this.rayParams[n2] == this.rayParams[n2 + 1] && this.rayParams.length > 2)) {
                    if (this.DEBUG) {
                        System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[n2]) + " " + (float)(57.29577951308232 * d4) + " " + (float)(57.29577951308232 * this.dist[n2 + 1]));
                    }
                    double d5 = (d4 - this.dist[n2]) / (this.dist[n2 + 1] - this.dist[n2]) * (this.time[n2 + 1] - this.time[n2]) + this.time[n2];
                    double d6 = (d4 - this.dist[n2 + 1]) * (this.rayParams[n2] - this.rayParams[n2 + 1]) / (this.dist[n2] - this.dist[n2 + 1]) + this.rayParams[n2 + 1];
                    arrival = new Arrival(this, d5, d4, d6, n2, this.name, this.puristName, this.sourceDepth);
                    this.arrivals.addElement(arrival);
                }
                ++n2;
            }
            d4 = (double)(n + 1) * 2.0 * Math.PI - d3;
            if (d2 != 180.0) {
                int n3 = 0;
                while (n3 < this.dist.length - 1) {
                    if (!(d4 == this.dist[n3 + 1] && n3 + 1 != this.dist.length - 1 || !((this.dist[n3] - d4) * (d4 - this.dist[n3 + 1]) >= 0.0) || this.rayParams[n3] == this.rayParams[n3 + 1] && this.rayParams.length > 2)) {
                        if (this.DEBUG) {
                            System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[n3]) + " " + (float)(57.29577951308232 * d4) + " " + (float)(57.29577951308232 * this.dist[n3 + 1]));
                        }
                        double d7 = (d4 - this.dist[n3]) / (this.dist[n3 + 1] - this.dist[n3]) * (this.time[n3 + 1] - this.time[n3]) + this.time[n3];
                        double d8 = (d4 - this.dist[n3]) * (this.rayParams[n3 + 1] - this.rayParams[n3]) / (this.dist[n3 + 1] - this.dist[n3]) + this.rayParams[n3];
                        arrival = new Arrival(this, d7, d4, d8, n3, this.name, this.puristName, this.sourceDepth);
                        this.arrivals.addElement(arrival);
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    protected void phaseConversion(TauModel tauModel, int n, int n2, boolean bl) throws TauModelException {
        if (n2 == 0) {
            throw new TauModelException("Illegal endAction: endAction=" + n2 + "\nphase conversion are not allowed at turn points.");
        }
        if (n2 == 1) {
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n, bl).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n, !bl).getMaxRayParam());
        } else if (n2 == 2) {
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n, bl).getMinTurnRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n, !bl).getMinTurnRayParam());
        } else if (n2 == 3) {
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n, bl).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n - 1, !bl).getMinTurnRayParam());
        } else if (n2 == 4) {
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n, bl).getMinRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n + 1, !bl).getMaxRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + n2);
        }
    }

    protected void addToBranch(TauModel tauModel, int n, int n2, boolean bl, int n3) throws TauModelException {
        boolean bl2;
        int n4;
        this.endAction = n3;
        if (this.DEBUG) {
            System.out.print("start=" + n + " end=" + n2 + " endOffset=");
            if (n3 == 0) {
                System.out.println("TURN");
            } else if (n3 == 1) {
                System.out.println("REFLECTTOP");
            } else if (n3 == 2) {
                System.out.println("REFLECTBOT");
            } else if (n3 == 3) {
                System.out.println("TRANSUP");
            } else if (n3 == 4) {
                System.out.println("TRANSDOWN");
            } else {
                System.out.println(n3);
            }
        }
        if (n3 == 0) {
            n4 = 0;
            bl2 = true;
            this.minRayParam = Math.max(this.minRayParam, tauModel.getTauBranch(n2, bl).getMinTurnRayParam());
        } else if (n3 == 1) {
            n4 = 0;
            bl2 = false;
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n2, bl).getMaxRayParam());
        } else if (n3 == 2) {
            n4 = 0;
            bl2 = true;
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n2, bl).getMinTurnRayParam());
        } else if (n3 == 3) {
            n4 = -1;
            bl2 = false;
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n2, bl).getMaxRayParam());
        } else if (n3 == 4) {
            n4 = 1;
            bl2 = true;
            this.maxRayParam = Math.min(this.maxRayParam, tauModel.getTauBranch(n2, bl).getMinRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + n3);
        }
        if (bl2) {
            int n5 = n;
            while (n5 <= n2) {
                this.branchSeq.addElement(new Integer(n5));
                this.downGoing.addElement(new Boolean(bl2));
                this.waveType.addElement(new Boolean(bl));
                this.legAction.addElement(new Integer(n3));
                ++n5;
            }
            if (this.DEBUG) {
                int n6 = n;
                while (n6 <= n2) {
                    System.out.println("i=" + n6 + " isDownGoing=" + bl2 + " isPWave=" + bl + " startBranch=" + n + " endBranch=" + n2 + " " + n3);
                    ++n6;
                }
            }
        } else {
            int n7 = n;
            while (n7 >= n2) {
                this.branchSeq.addElement(new Integer(n7));
                this.downGoing.addElement(new Boolean(bl2));
                this.waveType.addElement(new Boolean(bl));
                this.legAction.addElement(new Integer(n3));
                --n7;
            }
            if (this.DEBUG) {
                int n8 = n;
                while (n8 >= n2) {
                    System.out.println("i=" + n8 + " isDownGoing=" + bl2 + " isPWave=" + bl + " startBranch=" + n + " endBranch=" + n2 + " " + n3);
                    --n8;
                }
            }
        }
        this.currBranch = n2 + n4;
    }

    public int closestBranchToDepth(TauModel tauModel, String string) {
        if (string.equals("m")) {
            return tauModel.getMohoBranch();
        }
        if (string.equals("c")) {
            return tauModel.getCmbBranch();
        }
        if (string.equals("i")) {
            return tauModel.getIocbBranch();
        }
        int n = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.valueOf(string);
        int n2 = 0;
        while (n2 < tauModel.getNumBranches()) {
            TauBranch tauBranch = tauModel.getTauBranch(n2, true);
            if (Math.abs(d2 - tauBranch.topDepth) < d && !tauModel.isNoDisconDepth(tauBranch.topDepth)) {
                n = n2;
                d = Math.abs(d2 - tauBranch.topDepth);
            }
            ++n2;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseName(TauModel tauModel) throws TauModelException {
        boolean bl;
        boolean bl2;
        String string;
        String string2 = string = (String)this.legs.elementAt(0);
        this.branchSeq.removeAllElements();
        boolean bl3 = bl2 = true;
        if (this.legs.size() == 2 && string.endsWith("kmps")) {
            return;
        }
        if (this.name.indexOf(74) != -1 && !tauModel.sMod.isAllowInnerCoreS()) {
            throw new TauModelException("'J' phases were not created for this model: " + this.name);
        }
        if (string.equals("p") || string.startsWith("P") || string.equals("K") || string.equals("I")) {
            bl3 = bl2 = true;
        } else if (string.equals("s") || string.startsWith("S") || string.equals("J")) {
            bl3 = bl2 = false;
        }
        if (string.startsWith("P") || string.startsWith("S")) {
            this.currBranch = tauModel.getSourceBranch();
            bl = true;
            this.endAction = 2;
        } else {
            if (!string.equals("p") && !string.equals("s")) {
                throw new TauModelException("First phase not recognized: " + string + " must be one of P, Pg, Pn, Pdiff, p or the S equivalents");
            }
            bl = false;
            this.endAction = 1;
            if (tauModel.getSourceBranch() == 0) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                return;
            }
            this.currBranch = tauModel.getSourceBranch() - 1;
        }
        this.maxRayParam = tauModel.getSourceBranch() != 0 ? Math.max(tauModel.getTauBranch(tauModel.getSourceBranch() - 1, bl2).getMinTurnRayParam(), tauModel.getTauBranch(tauModel.getSourceBranch(), bl2).getMaxRayParam()) : tauModel.getTauBranch(tauModel.getSourceBranch(), bl2).getMaxRayParam();
        this.minRayParam = 0.0;
        int n = 0;
        double d = 0.0;
        boolean bl4 = false;
        this.endAction = 4;
        string = "START";
        int n2 = 0;
        while (n2 < this.legs.size() - 1) {
            block62: {
                boolean bl5;
                block79: {
                    block77: {
                        String string3;
                        block78: {
                            block74: {
                                block76: {
                                    block75: {
                                        block65: {
                                            block72: {
                                                block73: {
                                                    block71: {
                                                        block70: {
                                                            block68: {
                                                                block69: {
                                                                    block67: {
                                                                        block66: {
                                                                            block63: {
                                                                                block64: {
                                                                                    string3 = string;
                                                                                    string = string2;
                                                                                    string2 = (String)this.legs.elementAt(n2 + 1);
                                                                                    if (this.DEBUG) {
                                                                                        System.out.println(n2 + "  " + string3 + "  " + string + "  " + string2);
                                                                                    }
                                                                                    double d2 = d;
                                                                                    bl5 = bl4;
                                                                                    try {
                                                                                        d = new Double(string2);
                                                                                        bl4 = true;
                                                                                    }
                                                                                    catch (NumberFormatException numberFormatException) {
                                                                                        d = -1.0;
                                                                                        bl4 = false;
                                                                                    }
                                                                                    bl3 = bl2;
                                                                                    if (string.equals("p") || string.startsWith("P") || string.equals("I")) {
                                                                                        bl2 = true;
                                                                                    } else if (string.equals("s") || string.startsWith("S") || string.equals("J")) {
                                                                                        bl2 = false;
                                                                                    } else if (string.equals("K")) {
                                                                                        // empty if block
                                                                                    }
                                                                                    if (this.branchSeq.size() > 0 && bl3 != bl2) {
                                                                                        this.phaseConversion(tauModel, (Integer)this.branchSeq.elementAt(this.branchSeq.size() - 1), this.endAction, bl3);
                                                                                    }
                                                                                    if (!string.equals("p") && !string.equals("s")) break block63;
                                                                                    if (string2.startsWith("v")) {
                                                                                        throw new TauModelException("p and s must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + string + " nextLeg=" + string2);
                                                                                    }
                                                                                    if (!string2.startsWith("^")) break block64;
                                                                                    n = this.closestBranchToDepth(tauModel, string2.substring(1));
                                                                                    if (this.currBranch < n) {
                                                                                        throw new TauModelException("Phase not recognized: " + string + " followed by " + string2 + " when currBranch=" + this.currBranch + " > disconBranch=" + n);
                                                                                    }
                                                                                    this.addToBranch(tauModel, this.currBranch, n, bl2, 1);
                                                                                    break block62;
                                                                                }
                                                                                if (string2.equals("m") && this.currBranch >= tauModel.getMohoBranch()) {
                                                                                    this.addToBranch(tauModel, this.currBranch, tauModel.getMohoBranch(), bl2, 3);
                                                                                    break block62;
                                                                                } else if (string2.startsWith("P") || string2.startsWith("S") || string2.equals("END")) {
                                                                                    this.addToBranch(tauModel, this.currBranch, 0, bl2, 1);
                                                                                    break block62;
                                                                                } else {
                                                                                    if (!bl4) {
                                                                                        throw new TauModelException("Phase not recognized: " + string + " followed by " + string2);
                                                                                    }
                                                                                    n = this.closestBranchToDepth(tauModel, string2);
                                                                                    this.addToBranch(tauModel, this.currBranch, n, bl2, 3);
                                                                                }
                                                                                break block62;
                                                                            }
                                                                            if (!string.equals("P") && !string.equals("S")) break block65;
                                                                            if (!string2.equals("P") && !string2.equals("S") && !string2.equals("Pn") && !string2.equals("Sn") && !string2.equals("END")) break block66;
                                                                            if (this.endAction == 4 || this.endAction == 1) {
                                                                                this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch() - 1, bl2, 0);
                                                                            }
                                                                            this.addToBranch(tauModel, this.currBranch, 0, bl2, 1);
                                                                            break block62;
                                                                        }
                                                                        if (!string2.startsWith("v")) break block67;
                                                                        n = this.closestBranchToDepth(tauModel, string2.substring(1));
                                                                        if (this.currBranch > n - 1) {
                                                                            throw new TauModelException("Phase not recognized: " + string + " followed by " + string2 + " when currBranch=" + this.currBranch + " < disconBranch=" + n);
                                                                        }
                                                                        this.addToBranch(tauModel, this.currBranch, n - 1, bl2, 2);
                                                                        break block62;
                                                                    }
                                                                    if (!string2.startsWith("^")) break block68;
                                                                    n = this.closestBranchToDepth(tauModel, string2.substring(1));
                                                                    if (!string3.equals("K")) break block69;
                                                                    this.addToBranch(tauModel, this.currBranch, n, bl2, 1);
                                                                    break block62;
                                                                }
                                                                if (string3.startsWith("^") || string3.equals("P") || string3.equals("S") || string3.equals("p") || string3.equals("s") || string3.equals("START")) {
                                                                    this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch() - 1, bl2, 0);
                                                                    this.addToBranch(tauModel, this.currBranch, n, bl2, 1);
                                                                    break block62;
                                                                } else if (string3.startsWith("v") && n < this.closestBranchToDepth(tauModel, string3.substring(1)) || string3.equals("m") && n < tauModel.getMohoBranch() || string3.equals("c") && n < tauModel.getCmbBranch()) {
                                                                    this.addToBranch(tauModel, this.currBranch, n, bl2, 1);
                                                                    break block62;
                                                                } else {
                                                                    throw new TauModelException("Phase not recognized: " + string + " followed by " + string2 + " when currBranch=" + this.currBranch + " > disconBranch=" + n);
                                                                }
                                                            }
                                                            if (!string2.equals("c")) break block70;
                                                            this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch() - 1, bl2, 2);
                                                            break block62;
                                                        }
                                                        if (!string2.equals("K")) break block71;
                                                        this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch() - 1, bl2, 4);
                                                        break block62;
                                                    }
                                                    if (!string2.equals("m") && (!bl4 || !(d < tauModel.getCmbDepth()))) break block72;
                                                    n = this.closestBranchToDepth(tauModel, string2);
                                                    if (this.DEBUG) {
                                                        System.out.println("DisconBranch=" + n + " for " + string2);
                                                        System.out.println(tauModel.getTauBranch(n, bl2).getTopDepth());
                                                    }
                                                    if (this.endAction != 0 && this.endAction != 2 && this.endAction != 3) break block73;
                                                    if (n > this.currBranch) {
                                                        throw new TauModelException("Phase not recognized: " + string + " followed by " + string2 + " when currBranch=" + this.currBranch + " > disconBranch=" + n);
                                                    }
                                                    this.addToBranch(tauModel, this.currBranch, n, bl2, 3);
                                                    break block62;
                                                }
                                                String string4 = (String)this.legs.elementAt(n2 + 2);
                                                if (string4.equals("p") || string4.equals("s")) {
                                                    this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch() - 1, bl2, 0);
                                                    this.addToBranch(tauModel, this.currBranch, n, bl2, 3);
                                                    break block62;
                                                } else {
                                                    if (!string4.equals("P") && !string4.equals("S")) {
                                                        throw new TauModelException("Phase not recognized: " + string + " followed by " + string2 + " followed by " + string4);
                                                    }
                                                    if (n > this.currBranch) {
                                                        this.addToBranch(tauModel, this.currBranch, n - 1, bl2, 4);
                                                        break block62;
                                                    } else {
                                                        this.maxRayParam = -1.0;
                                                        if (this.DEBUG) {
                                                            System.out.println("Cannot phase convert on the downgoing side if the discontinuity is above the phase leg starting point, " + string + " " + string2 + " " + string4 + ", so this phase, " + this.getName() + " is illegal for this sourceDepth.");
                                                        }
                                                        return;
                                                    }
                                                }
                                            }
                                            throw new TauModelException("Phase not recognized: " + string + " followed by " + string2);
                                        }
                                        if (!string.startsWith("P") && !string.startsWith("S")) break block74;
                                        if (!string.equals("Pdiff") && !string.equals("Sdiff")) break block75;
                                        if (this.maxRayParam >= tauModel.getTauBranch(tauModel.getCmbBranch() - 1, bl2).getMinTurnRayParam() && this.minRayParam <= tauModel.getTauBranch(tauModel.getCmbBranch() - 1, bl2).getMinTurnRayParam()) {
                                            this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch() - 1, bl2, 0);
                                            this.maxRayParam = this.minRayParam;
                                            if (string2.equals("END")) {
                                                this.addToBranch(tauModel, this.currBranch, 0, bl2, 1);
                                            }
                                            break block62;
                                        } else {
                                            this.maxRayParam = -1.0;
                                            if (this.DEBUG) {
                                                System.out.println("Cannot have the head wave " + string + " within phase " + this.name + " for this sourceDepth and/or path.");
                                            }
                                            return;
                                        }
                                    }
                                    if (!(string.equals("Pg") || string.equals("Sg") || string.equals("Pn") || string.equals("Sn"))) {
                                        throw new TauModelException("Phase not recognized: " + string + " followed by " + string2);
                                    }
                                    if (this.currBranch >= tauModel.getMohoBranch()) {
                                        this.maxRayParam = -1.0;
                                        if (this.DEBUG) {
                                            System.out.println("(currBranch >= tMod.getMohoBranch() " + this.currBranch + " " + tauModel.getMohoBranch() + " so there cannot be a " + string + " phase for this sourceDepth and/or path.");
                                        }
                                        return;
                                    }
                                    if (!string.equals("Pg") && !string.equals("Sg")) break block76;
                                    this.addToBranch(tauModel, this.currBranch, tauModel.getMohoBranch() - 1, bl2, 0);
                                    this.addToBranch(tauModel, this.currBranch, 0, bl2, 1);
                                    break block62;
                                }
                                if (!string.equals("Pn") && !string.equals("Sn")) break block62;
                                if (this.maxRayParam >= tauModel.getTauBranch(tauModel.getMohoBranch(), bl2).getMaxRayParam() && this.minRayParam <= tauModel.getTauBranch(tauModel.getMohoBranch(), bl2).getMaxRayParam()) {
                                    this.addToBranch(tauModel, this.currBranch, tauModel.getMohoBranch(), bl2, 0);
                                    this.addToBranch(tauModel, this.currBranch, tauModel.getMohoBranch(), bl2, 3);
                                    this.minRayParam = this.maxRayParam;
                                    if (string2.equals("END") || string2.startsWith("P") || string2.startsWith("S")) {
                                        this.addToBranch(tauModel, this.currBranch, 0, bl2, 1);
                                    }
                                    break block62;
                                } else {
                                    this.maxRayParam = -1.0;
                                    if (this.DEBUG) {
                                        System.out.println("Cannot have the head wave " + string + " within phase " + this.name + " for this sourceDepth and/or path.");
                                    }
                                    return;
                                }
                            }
                            if (!string.equals("K")) break block77;
                            if (!string2.equals("P") && !string2.equals("S")) break block78;
                            if (string3.equals("P") || string3.equals("S") || string3.equals("K")) {
                                this.addToBranch(tauModel, this.currBranch, tauModel.getIocbBranch() - 1, bl2, 0);
                            }
                            this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch(), bl2, 3);
                            break block62;
                        }
                        if (string2.equals("K")) {
                            if (string3.equals("P") || string3.equals("S") || string3.equals("K")) {
                                this.addToBranch(tauModel, this.currBranch, tauModel.getIocbBranch() - 1, bl2, 0);
                            }
                            this.addToBranch(tauModel, this.currBranch, tauModel.getCmbBranch(), bl2, 1);
                            break block62;
                        } else if (string2.equals("I") || string2.equals("J")) {
                            this.addToBranch(tauModel, this.currBranch, tauModel.getIocbBranch() - 1, bl2, 4);
                            break block62;
                        } else {
                            if (!string2.equals("i")) {
                                throw new TauModelException("Phase not recognized: " + string + " followed by " + string2);
                            }
                            this.addToBranch(tauModel, this.currBranch, tauModel.getIocbBranch() - 1, bl2, 2);
                        }
                        break block62;
                    }
                    if (!string.equals("I") && !string.equals("J")) break block79;
                    this.addToBranch(tauModel, this.currBranch, tauModel.getNumBranches() - 1, bl2, 0);
                    if (string2.equals("I") || string2.equals("J")) {
                        this.addToBranch(tauModel, this.currBranch, tauModel.getIocbBranch(), bl2, 1);
                        break block62;
                    } else if (string2.equals("K")) {
                        this.addToBranch(tauModel, this.currBranch, tauModel.getIocbBranch(), bl2, 3);
                    }
                    break block62;
                }
                if (!(string.equals("m") || string.equals("c") || string.equals("i") || string.startsWith("^") || string.startsWith("v") || bl5)) {
                    throw new TauModelException("Phase not recognized: " + string + " followed by " + string2);
                }
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void legPuller() throws TauModelException {
        var1_1 = 0;
        this.legs.removeAllElements();
        if (!this.name.endsWith("kmps")) ** GOTO lbl56
        try {
            var2_2 = Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.legs.addElement(this.name);
        }
        catch (NumberFormatException var2_3) {
            throw new TauModelException("Invalid phase name:\n" + this.name);
        }
lbl-1000:
        // 1 sources

        {
            if (this.name.charAt(var1_1) == 'K' || this.name.charAt(var1_1) == 'I' || this.name.charAt(var1_1) == 'J' || this.name.charAt(var1_1) == 'p' || this.name.charAt(var1_1) == 's' || this.name.charAt(var1_1) == 'm' || this.name.charAt(var1_1) == 'c' || this.name.charAt(var1_1) == 'i') {
                this.legs.addElement(this.name.substring(var1_1, var1_1 + 1));
                ++var1_1;
                continue;
            }
            if (this.name.charAt(var1_1) == 'P' || this.name.charAt(var1_1) == 'S') {
                if (var1_1 + 1 == this.name.length() || this.name.charAt(var1_1 + 1) == 'P' || this.name.charAt(var1_1 + 1) == 'S' || this.name.charAt(var1_1 + 1) == 'K' || this.name.charAt(var1_1 + 1) == 'p' || this.name.charAt(var1_1 + 1) == 's' || this.name.charAt(var1_1 + 1) == 'm' || this.name.charAt(var1_1 + 1) == 'c' || this.name.charAt(var1_1 + 1) == '^' || this.name.charAt(var1_1 + 1) == 'v' || Character.isDigit(this.name.charAt(var1_1 + 1))) {
                    this.legs.addElement(this.name.substring(var1_1, var1_1 + 1));
                    ++var1_1;
                    continue;
                }
                if (this.name.charAt(var1_1 + 1) == 'g' || this.name.charAt(var1_1 + 1) == 'b' || this.name.charAt(var1_1 + 1) == 'n') {
                    this.legs.addElement(this.name.substring(var1_1, var1_1 + 2));
                    var1_1 += 2;
                    continue;
                }
                if (this.name.length() >= var1_1 + 5 && (this.name.substring(var1_1, var1_1 + 5).equals("Sdiff") || this.name.substring(var1_1, var1_1 + 5).equals("Pdiff"))) {
                    this.legs.addElement(this.name.substring(var1_1, var1_1 + 5));
                    var1_1 += 5;
                    continue;
                }
                throw new TauModelException("Invalid phase name:\n" + this.name.substring(var1_1) + " in " + this.name);
            }
            if (this.name.charAt(var1_1) == '^' || this.name.charAt(var1_1) == 'v') {
                if (this.name.charAt(var1_1 + 1) == 'm' || this.name.charAt(var1_1 + 1) == 'c' || this.name.charAt(var1_1 + 1) == 'i') {
                    this.legs.addElement(this.name.substring(var1_1, var1_1 + 2));
                    var1_1 += 2;
                    continue;
                }
                if (Character.isDigit(this.name.charAt(var1_1 + 1))) {
                    var2_5 = 1;
                    while (var1_1 + var2_5 + 1 < this.name.length() && Character.isDigit(this.name.charAt(var1_1 + var2_5 + 1))) {
                        ++var2_5;
                    }
                    this.legs.addElement(this.name.substring(var1_1, var1_1 + var2_5 + 1));
                    var1_1 = var1_1 + var2_5 + 1;
                    continue;
                }
                throw new TauModelException("Invalid phase name:\n" + this.name.substring(var1_1) + " in " + this.name);
            }
            if (Character.isDigit(this.name.charAt(var1_1)) || this.name.charAt(var1_1) == '.') {
                var2_6 = this.name.substring(var1_1, var1_1 + 1);
                ++var1_1;
                while (Character.isDigit(this.name.charAt(var1_1)) || this.name.charAt(var1_1) == '.') {
                    var2_6 = var2_6 + this.name.substring(var1_1, var1_1 + 1);
                    ++var1_1;
                }
                try {
                    var3_7 = new Double(var2_6);
                    this.legs.addElement(var2_6);
                }
                catch (NumberFormatException var3_8) {
                    throw new TauModelException("Invalid phase name: " + var2_6 + "\n" + var3_8.getMessage() + " in " + this.name);
                }
            } else {
                throw new TauModelException("Invalid phase name:\n" + this.name.substring(var1_1) + " in " + this.name);
            }
lbl56:
            // 8 sources

            ** while (var1_1 < this.name.length())
        }
lbl57:
        // 2 sources

        this.legs.addElement(new String("END"));
        if (!this.phaseValidate()) {
            throw new TauModelException("Phase failed validation: " + this.name);
        }
    }

    protected void createPuristName(TauModel tauModel) {
        String string = (String)this.legs.elementAt(0);
        if (this.legs.size() == 2 && string.endsWith("kmps")) {
            this.puristName = this.name;
            return;
        }
        this.puristName = "";
        int n = 0;
        while (n < this.legs.size() - 1) {
            int n2;
            double d;
            int n3;
            string = (String)this.legs.elementAt(n);
            if (string.startsWith("v") || string.startsWith("^")) {
                n3 = this.closestBranchToDepth(tauModel, string.substring(1));
                d = tauModel.getTauBranch((int)n3, (boolean)true).topDepth;
                this.puristName = this.puristName + string.substring(0, 1);
                if (d == Math.rint(d)) {
                    n2 = (int)d;
                    this.puristName = this.puristName + n2;
                } else {
                    this.puristName = this.puristName + d;
                }
            } else {
                try {
                    d = new Double(string);
                    n3 = this.closestBranchToDepth(tauModel, string);
                    d = tauModel.getTauBranch((int)n3, (boolean)true).topDepth;
                    if (d == Math.rint(d)) {
                        n2 = (int)d;
                        this.puristName = this.puristName + n2;
                    } else {
                        this.puristName = this.puristName + d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.puristName = this.puristName + string;
                }
            }
            ++n;
        }
    }

    protected void sumBranches(TauModel tauModel) throws TauModelException {
        int n;
        if (this.maxRayParam < 0.0 || this.minRayParam > this.maxRayParam) {
            this.rayParams = new double[0];
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            this.dist = new double[0];
            this.time = new double[0];
            this.maxDistance = -1.0;
            return;
        }
        if (this.name.endsWith("kmps")) {
            this.dist = new double[2];
            this.time = new double[2];
            this.rayParams = new double[2];
            this.dist[0] = 0.0;
            this.time[0] = 0.0;
            this.rayParams[0] = tauModel.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.dist[1] = Math.PI * 2;
            this.time[1] = Math.PI * 2 * tauModel.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.rayParams[1] = this.rayParams[0];
            this.minDistance = 0.0;
            this.maxDistance = Math.PI * 2;
            return;
        }
        int n2 = 0;
        while (n2 < tauModel.rayParams.length) {
            if (tauModel.rayParams[n2] >= this.minRayParam) {
                this.minRayParamIndex = n2;
            }
            if (tauModel.rayParams[n2] >= this.maxRayParam) {
                this.maxRayParamIndex = n2;
            }
            ++n2;
        }
        if (this.maxRayParamIndex == 0 && this.minRayParamIndex == tauModel.rayParams.length - 1) {
            this.rayParams = new double[tauModel.rayParams.length];
            System.arraycopy(tauModel.rayParams, 0, this.rayParams, 0, tauModel.rayParams.length);
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.endsWith("kmps")) {
                this.rayParams = new double[2];
                this.rayParams[0] = 0.0;
                this.rayParams[1] = this.maxRayParam;
            } else {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            }
        } else {
            if (this.DEBUG) {
                System.out.println("maxRayParamIndex=" + this.maxRayParamIndex + " minRayParamIndex=" + this.minRayParamIndex + " tMod.rayParams.length=" + tauModel.rayParams.length + " tMod.rayParams[0]=" + tauModel.rayParams[0] + " maxRayParam=" + this.maxRayParam);
            }
            this.rayParams = new double[this.minRayParamIndex - this.maxRayParamIndex + 1];
            System.arraycopy(tauModel.rayParams, this.maxRayParamIndex, this.rayParams, 0, this.minRayParamIndex - this.maxRayParamIndex + 1);
        }
        this.dist = new double[this.rayParams.length];
        this.time = new double[this.rayParams.length];
        int[][] nArray = new int[2][tauModel.getNumBranches()];
        int n3 = 0;
        while (n3 < nArray[0].length) {
            nArray[0][n3] = 0;
            nArray[1][n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.branchSeq.size()) {
            if (((Boolean)this.waveType.elementAt(n4)).booleanValue()) {
                int[] nArray2 = nArray[0];
                int n5 = (Integer)this.branchSeq.elementAt(n4);
                nArray2[n5] = nArray2[n5] + 1;
            } else {
                int[] nArray3 = nArray[1];
                int n6 = (Integer)this.branchSeq.elementAt(n4);
                nArray3[n6] = nArray3[n6] + 1;
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < tauModel.getNumBranches()) {
            if (nArray[0][n7] != 0) {
                n = this.maxRayParamIndex;
                while (n < this.minRayParamIndex + 1) {
                    int n8 = n - this.maxRayParamIndex;
                    this.dist[n8] = this.dist[n8] + (double)nArray[0][n7] * tauModel.getTauBranch((int)n7, (boolean)true).dist[n];
                    int n9 = n - this.maxRayParamIndex;
                    this.time[n9] = this.time[n9] + (double)nArray[0][n7] * tauModel.getTauBranch((int)n7, (boolean)true).time[n];
                    ++n;
                }
            }
            if (nArray[1][n7] != 0) {
                n = this.maxRayParamIndex;
                while (n < this.minRayParamIndex + 1) {
                    int n10 = n - this.maxRayParamIndex;
                    this.dist[n10] = this.dist[n10] + (double)nArray[1][n7] * tauModel.getTauBranch((int)n7, (boolean)false).dist[n];
                    int n11 = n - this.maxRayParamIndex;
                    this.time[n11] = this.time[n11] + (double)nArray[1][n7] * tauModel.getTauBranch((int)n7, (boolean)false).time[n];
                    ++n;
                }
            }
            ++n7;
        }
        if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
            if (tauModel.sMod.depthInHighSlowness(tauModel.cmbDepth - 1.0E-10, this.minRayParam, this.name.charAt(0) == 'P')) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
                this.maxDistance = -1.0;
                this.dist = new double[0];
                this.time = new double[0];
                this.rayParams = new double[0];
                return;
            }
            this.dist[1] = this.dist[0] + this.maxDiffraction * Math.PI / 180.0;
            this.time[1] = this.time[0] + this.maxDiffraction * Math.PI / 180.0 * this.minRayParam;
        } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
            this.dist[1] = this.dist[0] + this.maxRefraction * Math.PI / 180.0;
            this.time[1] = this.time[0] + this.maxRefraction * Math.PI / 180.0 * this.minRayParam;
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            this.dist[1] = this.dist[0];
            this.time[1] = this.time[0];
        }
        this.minDistance = Double.MAX_VALUE;
        this.maxDistance = 0.0;
        n = 0;
        while (n < this.dist.length) {
            if (this.dist[n] < this.minDistance) {
                this.minDistance = this.dist[n];
            }
            if (this.dist[n] > this.maxDistance) {
                this.maxDistance = this.dist[n];
            }
            ++n;
        }
        boolean bl = false;
        int n12 = 0;
        boolean bl2 = true;
        while (n12 < 2) {
            DepthRange[] depthRangeArray = tauModel.sMod.getHighSlowness(bl2);
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            while (n15 < depthRangeArray.length) {
                if (this.maxRayParam > depthRangeArray[n15].rayParam && depthRangeArray[n15].rayParam > this.minRayParam) {
                    int n16 = tauModel.findBranch(depthRangeArray[n15].topDepth);
                    bl = false;
                    int n17 = 0;
                    while (n17 < this.branchSeq.size()) {
                        if ((Integer)this.branchSeq.elementAt(n17) == n16 && (Boolean)this.waveType.elementAt(n17) == bl2 && ((Boolean)this.downGoing.elementAt(n17)).booleanValue() && (Integer)this.branchSeq.elementAt(n17 - 1) == n16 - 1 && (Boolean)this.waveType.elementAt(n17 - 1) == bl2 && ((Boolean)this.downGoing.elementAt(n17 - 1)).booleanValue()) {
                            bl = true;
                            break;
                        }
                        ++n17;
                    }
                    if (bl) {
                        double[] dArray = new double[this.dist.length + 1];
                        double[] dArray2 = new double[this.time.length + 1];
                        double[] dArray3 = new double[this.rayParams.length + 1];
                        int n18 = 0;
                        while (n18 < this.rayParams.length) {
                            if (this.rayParams[n18] == depthRangeArray[n15].rayParam) {
                                n13 = n18;
                                break;
                            }
                            ++n18;
                        }
                        System.arraycopy(this.dist, 0, dArray, 0, n13);
                        System.arraycopy(this.time, 0, dArray2, 0, n13);
                        System.arraycopy(this.rayParams, 0, dArray3, 0, n13);
                        dArray3[n13] = depthRangeArray[n15].rayParam;
                        dArray[n13] = 0.0;
                        dArray2[n13] = 0.0;
                        int n19 = 0;
                        while (n19 < tauModel.getNumBranches()) {
                            if (nArray[0][n19] != 0 && tauModel.getTauBranch(n19, true).getTopDepth() < depthRangeArray[n15].topDepth) {
                                int n20 = n13;
                                dArray[n20] = dArray[n20] + (double)nArray[0][n19] * tauModel.getTauBranch((int)n19, (boolean)true).dist[this.maxRayParamIndex + n13 - n14];
                                int n21 = n13;
                                dArray2[n21] = dArray2[n21] + (double)nArray[0][n19] * tauModel.getTauBranch((int)n19, (boolean)true).time[this.maxRayParamIndex + n13 - n14];
                            }
                            if (nArray[1][n19] != 0 && tauModel.getTauBranch(n19, false).getTopDepth() < depthRangeArray[n15].topDepth) {
                                int n22 = n13;
                                dArray[n22] = dArray[n22] + (double)nArray[1][n19] * tauModel.getTauBranch((int)n19, (boolean)false).dist[this.maxRayParamIndex + n13 - n14];
                                int n23 = n13;
                                dArray2[n23] = dArray2[n23] + (double)nArray[1][n19] * tauModel.getTauBranch((int)n19, (boolean)false).time[this.maxRayParamIndex + n13 - n14];
                            }
                            ++n19;
                        }
                        System.arraycopy(this.dist, n13, dArray, n13 + 1, this.dist.length - n13);
                        System.arraycopy(this.time, n13, dArray2, n13 + 1, this.time.length - n13);
                        System.arraycopy(this.rayParams, n13, dArray3, n13 + 1, this.rayParams.length - n13);
                        ++n14;
                        this.dist = dArray;
                        this.time = dArray2;
                        this.rayParams = dArray3;
                    }
                }
                ++n15;
            }
            ++n12;
            bl2 = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void calcPierce(TauModel var1_1) throws TauModelException {
        var18_2 = 0;
        var33_3 = 0;
        while (var33_3 < this.arrivals.size()) {
            block20: {
                block17: {
                    block19: {
                        block18: {
                            var32_20 = (Arrival)this.arrivals.elementAt(var33_3);
                            var22_15 = 0.0;
                            var28_18 = var24_16 = 0.0;
                            var34_21 = 0;
                            while (var34_21 < var1_1.rayParams.length - 1) {
                                if (!(var1_1.rayParams[var34_21] >= var32_20.rayParam)) break;
                                var18_2 = var34_21++;
                            }
                            var32_20.pierce = new TimeDist[this.branchSeq.size() + 2];
                            var2_4 = this.rayParams[var32_20.rayParamIndex];
                            var4_5 = this.rayParams[var32_20.rayParamIndex + 1];
                            var8_7 = this.dist[var32_20.rayParamIndex];
                            var10_8 = this.dist[var32_20.rayParamIndex + 1];
                            var16_11 = (var32_20.dist - var8_7) / (var10_8 - var8_7);
                            var6_6 = var16_11 * (var4_5 - var2_4) + var2_4;
                            var32_20.pierce[0] = new TimeDist(var6_6, 0.0, 0.0, var1_1.sourceDepth);
                            var21_14 = 1;
                            var35_22 = 0;
                            while (var35_22 < this.branchSeq.size()) {
                                var19_12 = (Integer)this.branchSeq.elementAt(var35_22);
                                var20_13 = (Boolean)this.waveType.elementAt(var35_22);
                                if (this.DEBUG) {
                                    System.out.println(var35_22 + " branchNum =" + var19_12 + " downGoing=" + (Boolean)this.downGoing.elementAt(var35_22) + "  isPWave=" + var20_13);
                                }
                                try {
                                    var30_19 = var6_6 > var1_1.getTauBranch(var19_12, var20_13).getMaxRayParam() ? var1_1.getTauBranch(var19_12, var20_13).getTopDepth() : (var6_6 <= var1_1.getTauBranch(var19_12, var20_13).getMinRayParam() ? var1_1.getTauBranch(var19_12, var20_13).getBotDepth() : (var20_13 || var1_1.sMod.depthInFluid((var1_1.getTauBranch(var19_12, var20_13).getTopDepth() + var1_1.getTauBranch(var19_12, var20_13).getBotDepth()) / 2.0) ? var1_1.sMod.findDepth(var6_6, var1_1.getTauBranch(var19_12, var20_13).getTopDepth(), var1_1.getTauBranch(var19_12, var20_13).getBotDepth(), true) : var1_1.sMod.findDepth(var6_6, var1_1.getTauBranch(var19_12, var20_13).getTopDepth(), var1_1.getTauBranch(var19_12, var20_13).getBotDepth(), var20_13)));
                                }
                                catch (SlownessModelException var36_24) {
                                    System.err.println("SeismicPhase.calcPierce: Caught SlownessModelException: " + var36_24.getMessage());
                                    var36_24.printStackTrace();
                                    var30_19 = 0.0;
                                }
                                if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Sn") != -1) {
                                    var8_7 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).dist[var18_2];
                                    var12_9 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).time[var18_2];
                                    var10_8 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).dist[var18_2];
                                    var14_10 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).time[var18_2];
                                } else {
                                    var8_7 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).dist[var18_2];
                                    var12_9 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).time[var18_2];
                                    var10_8 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).dist[var18_2 + 1];
                                    var14_10 = var1_1.getTauBranch((int)var19_12, (boolean)var20_13).time[var18_2 + 1];
                                }
                                var22_15 += var16_11 * (var10_8 - var8_7) + var8_7;
                                var28_18 = var24_16;
                                var24_16 += var16_11 * (var14_10 - var12_9) + var12_9;
                                var26_17 = (Boolean)this.downGoing.elementAt(var35_22) != false ? Math.min(var1_1.getTauBranch(var19_12, var20_13).getBotDepth(), var30_19) : Math.min(var1_1.getTauBranch(var19_12, var20_13).getTopDepth(), var30_19);
                                if (Math.abs(var28_18 - var24_16) > 1.0E-10) {
                                    var32_20.pierce[var21_14++] = new TimeDist(var6_6, var24_16, var22_15, var26_17);
                                    if (this.DEBUG) {
                                        System.out.println(" branchTime=" + var24_16 + " branchDist=" + var22_15 + " branchDepth=" + var26_17);
                                        System.out.println("incrementTime = " + var16_11 * (var14_10 - var12_9) + " timeB=" + var14_10 + " timeA=" + var12_9);
                                    }
                                }
                                ++var35_22;
                            }
                            if (this.name.indexOf("Pdiff") == -1 && this.name.indexOf("Pn") == -1 && this.name.indexOf("Sdiff") == -1 && this.name.indexOf("Sn") == -1) break block17;
                            var37_25 = 0;
                            if (this.name.indexOf("Pdiff") == -1 && this.name.indexOf("Sdiff") == -1) break block18;
                            var36_23 = new TimeDist[var21_14 + 1];
                            while (var32_20.pierce[var37_25].depth != var1_1.cmbDepth) {
                                var36_23[var37_25] = var32_20.pierce[var37_25];
                                ++var37_25;
                            }
                            var36_23[var37_25] = var32_20.pierce[var37_25];
                            var38_26 = var32_20.dist - this.dist[0];
                            var36_23[var37_25 + 1] = new TimeDist(var36_23[var37_25].p, var36_23[var37_25].time + var38_26 * var36_23[var37_25].p, var36_23[var37_25].dist + var38_26, var1_1.cmbDepth);
                            System.arraycopy(var32_20.pierce, ++var37_25, var36_23, var37_25 + 1, var21_14 - var37_25);
                            var40_29 = var37_25 + 1;
                            while (var40_29 < var36_23.length) {
                                var36_23[var40_29].dist += var38_26;
                                ++var40_29;
                            }
                            ++var21_14;
                            break block19;
                        }
                        var38_27 = 0;
                        var39_28 = -1;
                        while ((var39_28 = this.name.indexOf("Pn", var39_28 + 1)) != -1) {
                            ++var38_27;
                        }
                        while ((var39_28 = this.name.indexOf("Sn", var39_28 + 1)) != -1) {
                            ++var38_27;
                        }
                        var40_30 = var32_20.dist - this.dist[0];
                        var36_23 = new TimeDist[var21_14 + var38_27];
                        var42_31 = 0;
                        ** GOTO lbl97
                        {
                            var36_23[var37_25 + var42_31] = var32_20.pierce[var37_25];
                            var36_23[var37_25 + var42_31].dist += (double)var42_31 * var40_30 / (double)var38_27;
                            ++var37_25;
                            do {
                                if (var32_20.pierce[var37_25].depth != var1_1.mohoDepth) continue block9;
                                var36_23[var37_25 + var42_31] = var32_20.pierce[var37_25];
                                var36_23[var37_25 + var42_31].dist += (double)var42_31 * var40_30 / (double)var38_27;
                                var36_23[var37_25 + var42_31 + 1] = new TimeDist(var36_23[var37_25].p, var36_23[var37_25 + var42_31].time + var40_30 / (double)var38_27 * var36_23[var37_25].p, var36_23[var37_25 + var42_31].dist + var40_30 / (double)var38_27, var1_1.mohoDepth);
                                ++var37_25;
                                ++var42_31;
lbl97:
                                // 2 sources

                            } while (var42_31 < var38_27);
                        }
                        System.arraycopy(var32_20.pierce, var37_25, var36_23, var37_25 + var42_31, var21_14 - var37_25);
                        var43_32 = var37_25 + var42_31;
                        while (var43_32 < var36_23.length) {
                            var36_23[var43_32].dist += var40_30;
                            ++var43_32;
                        }
                        var21_14 += var42_31;
                    }
                    var32_20.pierce = var36_23;
                    break block20;
                }
                var36_23 = new TimeDist[var21_14];
                System.arraycopy(var32_20.pierce, 0, var36_23, 0, var21_14);
                var32_20.pierce = var36_23;
            }
            ++var33_3;
        }
    }

    public void calcPath(TauModel tauModel) {
        Vector<TimeDist[]> vector = new Vector<TimeDist[]>(10);
        int n = 0;
        int n2 = 0;
        while (n2 < this.arrivals.size()) {
            vector.removeAllElements();
            Arrival arrival = (Arrival)this.arrivals.elementAt(n2);
            int n3 = 0;
            while (n3 < tauModel.rayParams.length) {
                if (tauModel.rayParams[n3] >= arrival.rayParam) {
                    n = n3;
                }
                ++n3;
            }
            TimeDist[] timeDistArray = new TimeDist[]{new TimeDist(arrival.rayParam, 0.0, 0.0, tauModel.sourceDepth)};
            vector.addElement(timeDistArray);
            try {
                TimeDist[] timeDistArray2;
                int n4 = 0;
                while (n4 < this.branchSeq.size()) {
                    int n5 = (Integer)this.branchSeq.elementAt(n4);
                    boolean bl = (Boolean)this.waveType.elementAt(n4);
                    if (this.DEBUG) {
                        System.out.println("i=" + n4 + " branchNum=" + n5 + " isPWave=" + bl + " downgoing=" + (Boolean)this.downGoing.elementAt(n4));
                    }
                    if ((timeDistArray = tauModel.getTauBranch(n5, bl).path(arrival.rayParam, (Boolean)this.downGoing.elementAt(n4), tauModel.sMod)) != null) {
                        vector.addElement(timeDistArray);
                    }
                    if (n5 == tauModel.cmbBranch - 1 && (Integer)this.branchSeq.elementAt(n4 + 1) == tauModel.cmbBranch - 1 && (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Sdiff") != -1)) {
                        TimeDist[] timeDistArray3 = new TimeDist[]{new TimeDist(arrival.rayParam, (arrival.dist - this.dist[0]) * arrival.rayParam, arrival.dist - this.dist[0], tauModel.cmbDepth)};
                        vector.addElement(timeDistArray3);
                    } else if (n5 == tauModel.mohoBranch - 1 && (Integer)this.branchSeq.elementAt(n4 + 1) == tauModel.mohoBranch - 1 && (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1)) {
                        int n6 = 0;
                        int n7 = -1;
                        while ((n7 = this.name.indexOf("Pn", n7 + 1)) != -1) {
                            ++n6;
                        }
                        while ((n7 = this.name.indexOf("Sn", n7 + 1)) != -1) {
                            ++n6;
                        }
                        timeDistArray2 = new TimeDist[]{new TimeDist(arrival.rayParam, (arrival.dist - this.dist[0]) / (double)n6 * arrival.rayParam, (arrival.dist - this.dist[0]) / (double)n6, tauModel.mohoDepth)};
                        vector.addElement(timeDistArray2);
                    }
                    ++n4;
                }
                int n8 = 0;
                int n9 = 0;
                while (n9 < vector.size()) {
                    n8 += ((TimeDist[])vector.elementAt(n9)).length;
                    ++n9;
                }
                arrival.path = new TimeDist[n8];
                TimeDist timeDist = new TimeDist(arrival.rayParam, 0.0, 0.0, arrival.sourceDepth);
                int n10 = 0;
                int n11 = 0;
                while (n11 < vector.size()) {
                    timeDistArray2 = (TimeDist[])vector.elementAt(n11);
                    int n12 = 0;
                    while (n12 < timeDistArray2.length) {
                        timeDist.add(timeDistArray2[n12]);
                        timeDist.depth = timeDistArray2[n12].depth;
                        arrival.path[n10] = (TimeDist)timeDist.clone();
                        ++n10;
                        ++n12;
                    }
                    ++n11;
                }
            }
            catch (SlownessModelException slownessModelException) {
                System.out.println("Caught SlownessModelException in SeismicPhase.calcPath(): " + slownessModelException.getMessage());
                slownessModelException.printStackTrace();
                System.out.println("Skipping phase " + arrival.name);
            }
            ++n2;
        }
    }

    public boolean phaseValidate() {
        String string = (String)this.legs.elementAt(0);
        boolean bl = false;
        if (this.legs.size() == 2 && (string.equals("Pdiff") || string.equals("Sdiff") || string.endsWith("kmps")) && ((String)this.legs.elementAt(1)).equals("END")) {
            return true;
        }
        if (!(string.equals("Pg") || string.equals("Pb") || string.equals("Pn") || string.equals("Pdiff") || string.equals("Sg") || string.equals("Sb") || string.equals("Sn") || string.equals("Sdiff") || string.equals("P") || string.equals("S") || string.equals("p") || string.equals("s"))) {
            return false;
        }
        int n = 1;
        while (n < this.legs.size()) {
            String string2 = string;
            string = (String)this.legs.elementAt(n);
            if (string.startsWith("^") || string.startsWith("v") || string.equals("m") || string.equals("c") || string.equals("i")) {
                if (bl) {
                    return false;
                }
                bl = true;
            } else {
                bl = false;
            }
            if (string2.equals("END")) {
                return false;
            }
            if ((string.startsWith("P") || string.startsWith("S") || string.startsWith("p") || string.startsWith("s") || string.equals("m") || string.equals("c")) && (string2.equals("I") || string2.equals("J") || string2.equals("i"))) {
                return false;
            }
            if ((string2.startsWith("P") || string2.startsWith("S") || string2.startsWith("p") || string2.startsWith("s") || string2.equals("m") || string2.equals("c")) && (string.equals("I") || string.equals("J") || string.equals("i"))) {
                return false;
            }
            if (string2.equals("m") && string.equals("K")) {
                return false;
            }
            if (string.equals("m") && string2.equals("K")) {
                return false;
            }
            ++n;
        }
        return string.equals("END");
    }

    public String toString() {
        String string = this.name + ": ";
        int n = 0;
        while (n < this.legs.size()) {
            string = string + this.legs.elementAt(n) + " ";
            ++n;
        }
        string = string + "\n";
        int n2 = 0;
        while (n2 < this.branchSeq.size()) {
            string = string + (Integer)this.branchSeq.elementAt(n2) + " ";
            ++n2;
        }
        string = string + "\n";
        string = string + "minRayParam=" + this.minRayParam + " maxRayParam=" + this.maxRayParam;
        string = string + "\n";
        string = string + "minDistance=" + this.minDistance * 180.0 / Math.PI + " maxDistance=" + this.maxDistance * 180.0 / Math.PI;
        return string;
    }

    public void dump() {
        int n = 0;
        while (n < this.dist.length) {
            System.out.println(n + "  " + this.dist[n] + "  " + this.rayParams[n]);
            ++n;
        }
    }

    public Object clone() {
        try {
            SeismicPhase seismicPhase = (SeismicPhase)super.clone();
            seismicPhase.branchSeq = new Vector(this.branchSeq.size());
            int n = 0;
            while (n < this.branchSeq.size()) {
                seismicPhase.branchSeq.addElement(new Integer((Integer)this.branchSeq.elementAt(n)));
                ++n;
            }
            int n2 = 0;
            while (n2 < this.legs.size()) {
                seismicPhase.legs.addElement(new Integer((Integer)this.legs.elementAt(n2)));
                ++n2;
            }
            seismicPhase.dist = (double[])this.dist.clone();
            seismicPhase.time = (double[])this.time.clone();
            seismicPhase.rayParams = (double[])this.rayParams.clone();
            int n3 = 0;
            while (n3 < this.arrivals.size()) {
                seismicPhase.arrivals.addElement((Arrival)((Arrival)this.arrivals.elementAt(n3)).clone());
                ++n3;
            }
            return seismicPhase;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Caught CloneNotSupportedException: " + cloneNotSupportedException.getMessage());
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 3) {
                System.out.println("Usage: SeismicPhase modelfile depth phasename [phasename ...]");
            }
            TauModel tauModel = TauModel.readModel(stringArray[0]);
            TauModel tauModel2 = tauModel.depthCorrect(Double.valueOf(stringArray[1]));
            int n = 2;
            while (n < stringArray.length) {
                boolean bl = false;
                System.out.println("-----");
                SeismicPhase seismicPhase = new SeismicPhase(stringArray[n], tauModel2);
                seismicPhase.init();
                System.out.println(seismicPhase);
                seismicPhase.dump();
                ++n;
            }
            System.out.println("-----");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            System.out.println(optionalDataException.getMessage());
        }
        catch (StreamCorruptedException streamCorruptedException) {
            System.out.println(streamCorruptedException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException.getMessage());
        }
        catch (TauModelException tauModelException) {
            System.out.println(tauModelException.getMessage());
            tauModelException.printStackTrace();
        }
    }
}

