/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPlot;
import java.awt.Color;
import java.awt.Graphics;

public class PathPlot
extends ArrivalPlot {
    public PathPlot() {
        this.setOpaque(true);
    }

    public void paintBackground(Graphics graphics) {
        int n = this.getSize().width / 2;
        int n2 = this.getSize().height / 2;
        int n3 = Math.min(n, n2);
        double d = 6371.0;
        Color color = graphics.getColor();
        Color color2 = new Color(220, 220, 220);
        Color color3 = Color.white;
        Color color4 = color2;
        boolean bl = true;
        if (this.tMod != null) {
            d = this.tMod.getRadiusOfEarth();
            int n4 = n3;
            color4 = bl ? color2 : color3;
            graphics.setColor(color4);
            bl = !bl;
            graphics.fillOval(n - n4, n2 - n4, 2 * n4, 2 * n4);
            int n5 = 0;
            while (n5 < this.tMod.tauBranches[0].length - 1) {
                if (this.tMod.tauBranches[0][n5].getBotDepth() != this.tMod.tauBranches[1][n5].getBotDepth()) {
                    n4 = (int)Math.round((this.tMod.getRadiusOfEarth() - this.tMod.tauBranches[0][n5].getBotDepth()) / d * (double)n3);
                    color4 = bl ? color2 : color3;
                    graphics.setColor(color4);
                    bl = !bl;
                    graphics.fillOval(n - n4, n2 - n4, 2 * n4, 2 * n4);
                } else {
                    n4 = (int)Math.round((this.tMod.getRadiusOfEarth() - this.tMod.tauBranches[1][n5].getBotDepth()) / d * (double)n3);
                    color4 = bl ? color2 : color3;
                    graphics.setColor(color4);
                    bl = !bl;
                    graphics.fillOval(n - n4, n2 - n4, 2 * n4, 2 * n4);
                }
                ++n5;
            }
        }
        graphics.setColor(color);
    }

    public void paintArrivals(Graphics graphics) {
        int n = 0;
        while (n < this.arrivals.size()) {
            this.paintPaths(graphics, n);
            ++n;
        }
    }

    public void paintForeground(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.red);
        this.paintPaths(graphics, this.selectedIndex);
        graphics.setColor(color);
    }

    protected void paintPaths(Graphics graphics, int n) {
        int n2 = this.getSize().width / 2;
        int n3 = this.getSize().height / 2;
        int n4 = Math.min(n2, n3);
        double d = 6371.0;
        Arrival arrival = (Arrival)this.arrivals.elementAt(n);
        int[] nArray = new int[arrival.getNumPathPoints()];
        int[] nArray2 = new int[arrival.getNumPathPoints()];
        if (arrival.dist * 180.0 / Math.PI % 360.0 > 180.0) {
            int n5 = 0;
            while (n5 < nArray.length) {
                nArray[n5] = n2 + (int)Math.rint(Math.sin(-1.0 * arrival.getPathPoint((int)n5).dist) * (d - arrival.getPathPoint((int)n5).depth) / d * (double)n4);
                nArray2[n5] = n3 - (int)Math.rint(Math.cos(-1.0 * arrival.getPathPoint((int)n5).dist) * (d - arrival.getPathPoint((int)n5).depth) / d * (double)n4);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < nArray.length) {
                nArray[n6] = n2 + (int)Math.rint(Math.sin(arrival.getPathPoint((int)n6).dist) * (d - arrival.getPathPoint((int)n6).depth) / d * (double)n4);
                nArray2[n6] = n3 - (int)Math.rint(Math.cos(arrival.getPathPoint((int)n6).dist) * (d - arrival.getPathPoint((int)n6).depth) / d * (double)n4);
                ++n6;
            }
        }
        graphics.drawPolyline(nArray, nArray2, nArray.length);
    }
}

