/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.LatLon;
import edu.sc.seis.TauP.MatArrival;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Path;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class MatTauP_Path
extends TauP_Path {
    protected MatArrival[] matArrivals;

    protected MatTauP_Path() {
        this.outFile = null;
    }

    public void init() throws IOException {
        if (this.phaseNames.size() == 0) {
            if (this.toolProps.containsKey("taup.phase.file")) {
                if (this.toolProps.containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException e) {
                    Alert.warning(String.valueOf("Caught IOException while attempting to reading phase file ").concat(String.valueOf(this.toolProps.getProperty("taup.phase.file"))), e.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
            }
        }
        this.depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null) {
            this.modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException ee) {
                Alert.error("Caught TauModelException", ee.getMessage());
            }
            catch (FileNotFoundException ee) {
                Alert.error(String.valueOf(String.valueOf("Can't find saved model file for model ").concat(String.valueOf(this.modelName))).concat(String.valueOf(".")), "");
                return;
            }
            catch (InvalidClassException ee) {
                Alert.error(String.valueOf(String.valueOf("Model file ").concat(String.valueOf(this.modelName))).concat(String.valueOf(" is not compatible with the current version.")), "Recreate using taup_create.");
                return;
            }
        }
        this.dos = null;
    }

    public void printResult(DataOutputStream dos) throws IOException {
        Writer s = null;
        this.printResult(s);
    }

    public void printResult(Writer out) throws IOException {
        double radiusOfEarth = this.tModDepth.getRadiusOfEarth();
        this.matArrivals = new MatArrival[this.arrivals.size()];
        for (int i = 0; i < this.arrivals.size(); ++i) {
            Arrival currArrival = (Arrival)this.arrivals.elementAt(i);
            this.matArrivals[i] = new MatArrival(currArrival);
            this.matArrivals[i].matPath.init_path(currArrival.path.length);
            boolean longWayRound = false;
            if (currArrival.dist * (double)180 / Math.PI % (double)360 > (double)180) {
                longWayRound = true;
            }
            double calcTime = 0.0;
            double calcDist = 0.0;
            double calcDepth = currArrival.sourceDepth;
            for (int j = 0; j < currArrival.path.length; ++j) {
                calcTime = currArrival.path[j].time;
                calcDepth = currArrival.path[j].depth;
                calcDist = currArrival.path[j].dist * 180.0 / Math.PI;
                if (longWayRound && calcDist != 0.0) {
                    calcDist = -1.0 * calcDist;
                }
                this.matArrivals[i].matPath.p[j] = currArrival.path[j].p;
                this.matArrivals[i].matPath.time[j] = calcTime;
                this.matArrivals[i].matPath.dist[j] = calcDist;
                this.matArrivals[i].matPath.depth[j] = calcDepth;
                this.matArrivals[i].matPath.lat[j] = this.calcLatLon((double)calcDist).lat;
                this.matArrivals[i].matPath.lon[j] = this.calcLatLon((double)calcDist).lon;
            }
        }
    }

    protected LatLon calcLatLon(double calcDist) {
        double lat = 0.0;
        double lon = 0.0;
        LatLon pathCoord = new LatLon();
        if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
            lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
            lat = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
            lon = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
            lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
        }
        pathCoord.lat = lat;
        pathCoord.lon = lon;
        return pathCoord;
    }

    public static MatArrival[] run_path(String[] args) throws OptionalDataException, ClassNotFoundException, StreamCorruptedException, IOException, FileNotFoundException {
        MatArrival[] matArrivals = null;
        try {
            MatTauP_Path tauPPath = new MatTauP_Path();
            String[] noComprendoArgs = tauPPath.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    MatArrival[] matArrivalArray = matArrivals;
                    return matArrivalArray;
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(String.valueOf(noComprendoArgs[i]).concat(String.valueOf(" ")));
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.out.println();
                    MatArrival[] matArrivalArray = matArrivals;
                    return matArrivalArray;
                }
                System.out.println();
                noComprendoArgs = null;
            }
            tauPPath.init();
            if (tauPPath.DEBUG) {
                System.out.println(String.valueOf("Done reading ").concat(String.valueOf(tauPPath.modelName)));
            }
            tauPPath.start();
            matArrivals = tauPPath.matArrivals;
            tauPPath.destroy();
            MatArrival[] matArrivalArray = matArrivals;
            return matArrivalArray;
        }
        catch (TauModelException e) {
            System.out.println(String.valueOf("Caught TauModelException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println(String.valueOf("Caught TauPException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
        return matArrivals;
    }

    public static void main(String[] args) throws OptionalDataException, ClassNotFoundException, StreamCorruptedException, IOException, FileNotFoundException {
        MatArrival[] matArrivals = null;
        try {
            MatTauP_Path tauPPath = new MatTauP_Path();
            String[] noComprendoArgs = tauPPath.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    return;
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(String.valueOf(noComprendoArgs[i]).concat(String.valueOf(" ")));
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.out.println();
                    return;
                }
                System.out.println();
                noComprendoArgs = null;
            }
            tauPPath.init();
            if (tauPPath.DEBUG) {
                System.out.println(String.valueOf("Done reading ").concat(String.valueOf(tauPPath.modelName)));
            }
            tauPPath.start();
            matArrivals = tauPPath.matArrivals;
            tauPPath.destroy();
            return;
        }
        catch (TauModelException e) {
            System.out.println(String.valueOf("Caught TauModelException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println(String.valueOf("Caught TauPException: ").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
    }
}

