/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import javax.swing.table.AbstractTableModel;

public class ArrivalTableModel
extends AbstractTableModel {
    protected Arrival[] arrivals = new Arrival[0];
    private static Format float6_1 = new Format("%6.1f");
    private static Format float8_1 = new Format("%8.1f");
    private static Format float8_2 = new Format("%8.2f");
    private static Format float8_3 = new Format("%8.3f");
    private static Format float8_4 = new Format("%8.4f");

    public int getRowCount() {
        return this.arrivals.length;
    }

    public int getColumnCount() {
        return 8;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return float8_1.form(this.arrivals[n].getModuloDistDeg());
            }
            case 1: {
                return float8_1.form(this.arrivals[n].getModuloDist() * this.arrivals[n].getPhase().getTauModel().getRadiusOfEarth());
            }
            case 2: {
                return float8_1.form(this.arrivals[n].getSourceDepth());
            }
            case 3: {
                return this.arrivals[n].getName();
            }
            case 4: {
                return float8_2.form(this.arrivals[n].getTime());
            }
            case 5: {
                return float8_3.form(Math.PI / 180 * this.arrivals[n].getRayParam());
            }
            case 6: {
                return float8_1.form(this.arrivals[n].getDistDeg());
            }
            case 7: {
                return this.arrivals[n].getName().equals(this.arrivals[n].getPuristName()) ? "=" : "*";
            }
            case 8: {
                return this.arrivals[n].getPuristName();
            }
        }
        return "";
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Dist";
            }
            case 1: {
                return "Dist (km)";
            }
            case 2: {
                return "Depth";
            }
            case 3: {
                return "Name";
            }
            case 4: {
                return "Time";
            }
            case 5: {
                return "Ray Param";
            }
            case 6: {
                return "Purist Dist";
            }
            case 7: {
                return "";
            }
            case 8: {
                return "Purist Name";
            }
        }
        return "";
    }

    public void setArrivals(Arrival[] arrivalArray) {
        this.arrivals = arrivalArray;
        this.fireTableDataChanged();
    }
}

