/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TimeDist;

public class Arrival
implements Cloneable {
    protected SeismicPhase phase;
    protected double time;
    protected double dist;
    protected double rayParam;
    protected int rayParamIndex;
    protected String name;
    protected String puristName;
    protected double sourceDepth;
    protected TimeDist[] pierce;
    protected TimeDist[] path;
    protected static final double TWOPI = Math.PI * 2;
    protected static final double DtoR = Math.PI / 180;
    protected static final double RtoD = 57.29577951308232;

    public Arrival(SeismicPhase seismicPhase, double d, double d2, double d3, int n, String string, String string2, double d4) {
        this.phase = seismicPhase;
        this.time = d;
        this.dist = d2;
        this.rayParam = d3;
        this.rayParamIndex = n;
        this.name = string;
        this.puristName = string2;
        this.sourceDepth = d4;
    }

    public SeismicPhase getPhase() {
        return this.phase;
    }

    public double getTime() {
        return this.time;
    }

    public double getDist() {
        return this.dist;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDist();
    }

    public double getModuloDist() {
        double d = this.getDist() % (Math.PI * 2);
        if (d > Math.PI) {
            d = Math.PI * 2 - d;
        }
        return d;
    }

    public double getModuloDistDeg() {
        double d = 57.29577951308232 * this.getDist() % 360.0;
        if (d > 180.0) {
            d = 360.0 - d;
        }
        return d;
    }

    public double getRayParam() {
        return this.rayParam;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.puristName;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public TimeDist[] getPierce() {
        return this.pierce;
    }

    public TimeDist[] getPath() {
        return this.path;
    }

    public Object clone() {
        try {
            int n;
            Arrival arrival = (Arrival)super.clone();
            if (this.pierce != null) {
                arrival.pierce = new TimeDist[this.pierce.length];
                n = 0;
                while (n < this.pierce.length) {
                    arrival.pierce[n] = this.pierce[n] != null ? (TimeDist)this.pierce[n].clone() : null;
                    ++n;
                }
            }
            if (this.path != null) {
                arrival.path = new TimeDist[this.path.length];
                n = 0;
                while (n < this.path.length) {
                    arrival.path[n] = (TimeDist)this.path[n].clone();
                    ++n;
                }
            }
            return arrival;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        String string = "time=" + this.time + " dist=" + this.dist + " rayParam=" + this.rayParam + " rayParamIndex=" + this.rayParamIndex + " name=" + this.name;
        if (this.pierce != null) {
            System.out.println("\nPierce:");
            int n = 0;
            while (n < this.pierce.length) {
                System.out.println(this.pierce[n]);
                ++n;
            }
        }
        return string;
    }

    public int getNumPiercePoints() {
        if (this.pierce != null) {
            return this.pierce.length;
        }
        return 0;
    }

    public int getNumPathPoints() {
        if (this.path != null) {
            return this.path.length;
        }
        return 0;
    }

    public TimeDist getPiercePoint(int n) {
        return this.pierce[n];
    }

    public TimeDist getFirstPiercePoint(double d) {
        int n = 0;
        while (n < this.pierce.length) {
            if (this.pierce[n].depth == d) {
                return this.pierce[n];
            }
            ++n;
        }
        throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + d);
    }

    public TimeDist getLastPiercePoint(double d) {
        TimeDist timeDist = null;
        int n = 0;
        while (n < this.pierce.length) {
            if (this.pierce[n].depth == d) {
                timeDist = this.pierce[n];
            }
            ++n;
        }
        if (timeDist == null) {
            throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + d);
        }
        return timeDist;
    }

    public TimeDist getPathPoint(int n) {
        return this.path[n];
    }
}

