       program responsee

c gets instrument response and convolves or deconvolves as you
c wish. Fourier convention: time --> freq uses exp(-iwt)
c A non-memory-efficient fft procedure is used for convenience of
c debugging; at all times both the time series and (complete) spectrum 
c is available.
c 1994 SL
c Original version (response) called pzread.f to read RESP output file from rdseed
c later the RESP format changed, and then later evalsresp was developed,
c and after that an evalresp function became avaialble. 
c This version (responsee) call the "evalresp" executable.
c 2010 SL

       parameter(pi=3.141593)
       parameter(mx=1048576)
       logical cmplt,ok,nano,disp,fslat,fslon,fsel,exist
       character*70 respfl,specfl,spe3fl,seis
       character*24 seiso
       character*190 command
       dimension x(mx)
       dimension dum(2*mx)
       dimension ned(4),tp(4)
       complex r(mx),spec(mx)
       complex resp,s,evresh
       character*8 kcmpnm,kstnm
       character*4 stns(113),ctype,nchn
       character*5 nstn
       character*8 user
       character*20 name
       data cmplt/.true./
       data nano/.true./
       data stns/
     + 'AFI ','ALQ ','ANMC','ANMO','ANTO','BCAO',
     + 'BDF ','BER ','BGIO','BJI ','BOCO','CCM ',
     + 'CHG ','CHTO','CMB ','COL ','COR ','CTA ',
     + 'CTAO','EIL ','ENH ','GAC ','GDH ','GNI ',
     + 'GRFO','GSC ','GUMO','HIA ','HON ','HRV ',
     + 'ISA ','JAS ','JAS1','KAAO','KBS ','KEV ',
     + 'KIP ','KMI ','KON ','KONO','LEM ','LON ',
     + 'LSA ','LZH ','MAIO','MAJO','MAT ','MDJ ',
     + 'NWAO','OGD ','PAS ','PFO ','PFOT','PFO_',
     + 'QIZ ','RSCP','RSNT','RSNY','RSON','RSSD',
     + 'SBC ','SCP ','SHIO','SLR ','SNZO','SPA ',
     + 'SSE ','SVD ','TATO','TAU ','TLO ','TOL ',
     + 'WMQ ','ZLP ','ZOBO','AAK ','ALE ','ARU ',
     + 'ERM ','ESK ','GAR ','KIV ','NNA ','OBN ',
     + 'PFO ','RPN ','SUR ','TLY ','AGD ','BNG ',
     + 'CAN ','CAY ','CRZF','DRV ','HDC2','HYB ',
     + 'INU ','KIP ','MBO ','NOU ','PAF ','PPT ',
     + 'RER ','SCZ ','SSB ','TAM ','WFM ','WUS ',
     + 'NOC ','SEM ','SBB ','UNM ','ECH '/
       common/information/info

       fslat = .false.
       fslon = .false.
       fsel = .false.
       disp=.false.
       exist = .false.
       call getenv('USER',user)
10     format(a,$)
       info=1
       write(6,*) "response:"
       write(6,10) "give info level min (0) or max (1): "
       read(5,*) info
       write(6,*) info
       write(6,10) "give filename of input seismogram (SAC-format): "
       read(5, fmt = '(a70)') seis
       write(6,*) seis
       write(6,10) "give filename of output seismogram (SAC-format): "
       read(5, fmt = '(a24)') seiso
       write(6,*) seiso
       call rsac1(seis,x,nlen,beg,dt,mx,nerr)
       if (nerr.gt.0) call skerr(nerr,seis)
       call getnhv("nzyear",nzyear,nerr)
       if (nerr.gt.0) call skerr(nerr,"nzyear")
       call getnhv("nzjday",nzjday,nerr)
       if (nerr.gt.0) call skerr(nerr,"nzjday")
       call getkhv("kcmpnm",kcmpnm,nerr)
       nchn = kcmpnm(1:4)
       print*, kcmpnm, nchn
       if (nerr.gt.0) call skerr(nerr,"kcmpnm")
       call equiv(kcmpnm)
       call getkhv("kstnm",kstnm,nerr)
       nstn = kstnm(1:5)
       print*, kstnm, nstn
       if (nerr.gt.0) call skerr(nerr,"kstnm")
          call getfhv("depmen",depmen,nerr)
          if (nerr.gt.0) call skerr(nerr,"depmen")
          call getfhv("depmax",depmax,nerr)
          if (nerr.gt.0) call skerr(nerr,"depmax")
          call getfhv("depmin",depmin,nerr)
          if (nerr.gt.0) call skerr(nerr,"depmin")
          if (abs(depmen/(depmax-depmin)).gt.0.001) then
   	  write(6,*) "The seismogram is offset from a zero mean."
   	  write(6,*) "This is a PROBLEM when the seismogram"
   	  write(6,*) "is padded with zeroes to reach a power-of-two"
   	  write(6,*) "number of samples. E.g. apply SAC>rmean or"
   	  write(6,*) "SAC>rtrend before applying response."
   	  nerr=-9
   	  call skerr(nerr,"zero-mean")
          endif
       depmen = 0.
       do i=1,nlen
          depmen = depmen + x(i)
       enddo
       depmen = depmen/nlen
       do i=1,nlen
          x(i) = x(i) - depmen
       enddo

       call getfhv("stla",stla,nerr)
       if (nerr.gt.0) call skerr(nerr,"stla")
       call getfhv("stlo",stlo,nerr)
       if (nerr.gt.0) call skerr(nerr,"stlo")
       call getfhv("stel",stel,nerr)
       if (nerr.gt.0) call skerr(nerr,"stel")

       call fft(mx,x,nlen,dt,-1,spec,nfrq,df,cmplt,dum)

       do i=1,nfrq
 	 x(i)=cabs(spec(i))
       enddo
       name = '/tmp/specd.'//user
       call wsac1(name,x,nfrq,0.,df,nerr)

       if (cmplt) then
	  nnyq=nfrq/2+1
       else
	  call skerr(-1,"fft")
	  nnyq=nfrq/2+1
       endif
       fnyq = (nnyq-1)*df

       iex=-1
       i=1
       do while (i.le.113.and.kstnm.ne.stns(i))
	  i=i+1
       enddo
       if (i.le.113) then
	  if (i.le.75) then
             ctype='GDSN'
	  else if (i.le.88) then
	     ctype='IDA '
	  else
	     ctype='GEO '
	  endif
          iex=0
       endif

       write(6,*) ""
       if (info.eq.1) then
          write(6,*) "where to search for instrument response?"
          write(6,*) "in a (SEED-format) response file (option 1),"
	  write(6,*) "or from a Pole-Zero file"
	  write(6,*) "response file (option 2)"
       else
	  write(6,*) "response from seed-file (1)"
	  write(6,*) "or Pole-Zero file (2)?"
       endif
       write(6,*) ""
       write(6,10) "give option: "
       read(5,*) ioption
       write(6,*) ioption
             write(6,10) "response filename: "
             read(5,fmt = '(a70)') respfl
             write(6,'(a)') respfl
             write(6,*) ""
             inquire(file=respfl,exist=ok) 
             if (ok) then
	        iex=1
	     else
	        nerr=1
	        call skerr(nerr,respfl)
	     endif

       if (iex.eq.1.and.ioption.lt.3) then
          if (ioption.eq.2) then 
              call pzfile(respfl,istat)
              do i=1,nnyq
                 if (ioption.eq.2) then
	             r(i)=resp(w)
	         endif
              enddo
          else
              specfl = 'SPECTRA'//respfl(5:)
              call getend(respfl,lend,70)
              write(command,*) 'evalresp ',nstn,' ',nchn,' ',nzyear,
     &              ' ',nzjday,' 0 ',fnyq,' ',nnyq,
     &              ' -u vel -s lin -r cs -f ',respfl
* there is actually an evresp_() function now that can be called from here.
              print*, command
              call system(command)
              print*, respfl
              print*, specfl
              open(12,file=specfl)
              rewind 12
              do i=1,nnyq
                 read(12,*) f, r1,r2
                 r(i) = cmplx(r1,r2)
              enddo
              istat = 0
	  endif
       else
	  write(6,*) "instrument response could not be found and"
	  write(6,*) "will not be used."
	  istat=0
       endif
       if (istat.eq.0.or.istat.eq.4) then
	  continue
       else
	  write(6,*) "response retrieving could not be completed"
	  write(6,*) "error=",istat
	  stop
       endif

       write(6,*) ""
20     if (info.eq.1) then
	  write(6,10) "Would you like to convolve (1) or deconvolve (2):"
       else
	  write(6,10) "convolve (1) or deconvolve (2):"
       endif
       read(5,*) iopt
       iunit=0
       if (iopt.eq.2) then
30	  if (info.eq.1) then
	     write(6,*) "would you like the output in nm/s (1),"
	     write(6,10) "or in nm (2): "
	  else
	     write(6,10) "output in nm/s (1), nm (2):"
	  endif
	  read(5,*) iunit
	  if (iunit.ne.1.and.iunit.ne.2) then
	     if (iunit.eq.3) then
		iunit=1
		nano=.false.
	     else if (iunit.eq.4) then
		iunit=2
		nano=.false.
	     else
	        call wrerr()
	        goto 30
	     endif
	  endif
       else if (iopt.ne.1) then
	  call wrerr()
	  goto 20
       endif

       do i=1,nnyq
	  f=(i-1)*df
	  w=2*pi*f
	  s=cmplx(0.,w)
	  if (disp.and.iunit.eq.1) then
	     r(i) = r(i)/s
	  endif
	  if (.not.disp.and.iunit.eq.2) then
	     r(i) = r(i)*s
	  endif
       enddo

       do i=1,nfrq
 	 x(i)=cabs(r(i))
       enddo
       name = '/tmp/specr.'//user
       call wsac1(name,x,nfrq,0.,df,nerr)

       do i=1,4
	  ned(i)=0
       enddo
       if (iopt.eq.2) then
          call getedges(nnyq,r,ifltr,ned)
	  do i=1,4
	     tp(i)=(ned(i)-1)*df
	  enddo
	  if (info.eq.1) then
	     if (ifltr.ne.1) then
		write(6,*) "automatic filter would have chosen:"
	     endif
       write(6,*) "flat filter between ",tp(2)," and ",tp(3)," Hz"
       write(6,*) "tapered filter between ",tp(1)," and ",tp(4)," Hz"
	     if (ifltr.eq.1) then
		write(6,*) "automatic setting not guaranteed to be suitable!"
		write(6,*) "check frequencies!"
	        write(6,*) "make sure these frequencies are appropriate!"
	     endif
          endif
       endif

       spec(1)=cmplx(0.,0.)
       if (iopt.eq.1) then
          do i=2,nnyq
	     f=(i-1)*df
	     w=2*pi*f
	     s=cmplx(0.,w)
c make velocity of displacement seismogram:
	     if (.not.disp) then
		spec(i)=spec(i)*s
	     endif
	     spec(i)=spec(i)*r(i)
	  enddo
          do i=nnyq+1,nfrq
	     spec(i)=conjg(spec(nnyq-(i-nnyq)))
          enddo
       else
	  if (ifltr.eq.2) then
             call chooseedges(user,df,ned,tp)
	     if (info.eq.1) then
	        write(6,*) "flat filter between ",(ned(2)-1)*df
	        write(6,*) "and ",(ned(3)-1)*df," Hz"
	        write(6,*) "tapered filter between ",(ned(1)-1)*df
	        write(6,*) "and ",(ned(4)-1)*df," Hz"
             endif
	  endif
	  if (ifltr.eq.3) then
	     call readedges(df,ned,tp)
	     if (info.eq.1) then
	        write(6,*) "clean filter between ",(ned(2)-1)*df
	        write(6,*) "and ",(ned(3)-1)*df," Hz"
	        write(6,*) "tapered filter between ",(ned(1)-1)*df
	        write(6,*) "and ",(ned(4)-1)*df," Hz"
             endif
	  endif
          call deconv(nnyq,r,spec,ned)
          do i=nnyq+1,nfrq
	     spec(i)=conjg(spec(nnyq-(i-nnyq)))
          enddo
       endif

       call fft(mx,x,nlen,dt,1,spec,nfrq,df,cmplt,dum)

* read input seismogram once more to preserve original
* header fields.
       call rsac1(seis,dum,ndum,bdum,dtdum,mx,nerr)
       if (nano) then
	  if (iopt.eq.1) then
	     do i=1,nlen
	        x(i)=x(i)*1.e-9
	     enddo
	     call setihv("IDEP","IUNKN",nerr)
	  else
	     do i=1,nlen
	        x(i)=x(i)*1.e9
	     enddo
	     if (iunit.eq.1) call setihv("IDEP","IVEL",nerr)
	     if (iunit.eq.2) call setihv("IDEP","IDISP",nerr)
             if (nerr.gt.0) call skerr(nerr,"idep")
	  endif
       else
	  call setihv("IDEP","IUNKN",nerr)
          if (nerr.gt.0) call skerr(nerr,"idep")
       endif
       if (iopt.eq.2) then
          call setfhv("T6",tp(1),nerr)
          call setfhv("T7",tp(2),nerr)
          call setfhv("T8",tp(3),nerr)
          call setfhv("T9",tp(4),nerr)
          call setkhv("KT6","llf",nerr)
          call setkhv("KT7","lf",nerr)
          call setkhv("KT8","hf",nerr)
          call setkhv("KT9","hhf",nerr)
       endif
       call setkhv("kcmpnm",kcmpnm,nerr)
       call setnhv("NPTS",nlen,nerr)
       call setfhv("B",beg,nerr)
       call setfhv("DELTA",dt,nerr)
       if (fslat) call setfhv("stla",slat,nerr)
       if (fslon) call setfhv("stlo",slon,nerr)
       if (fsel) call setfhv("stel",sel,nerr)
       call wsac0(seiso,dum,x,nerr)

       do i=1,nfrq
	 if (nano) then
	    if (iopt.eq.1) then
 	       x(i)=1.e-9*cabs(spec(i))
	    else
 	       x(i)=1.e9*cabs(spec(i))
	    endif
	 else
 	    x(i)=cabs(spec(i))
	 endif
       enddo
       name = '/tmp/spec.'//user
       call wsac1(name,x,nfrq,0.,df,nerr)

       end

*********************************************************************
