* subroutines for response.f
* SL 1994

       subroutine prerr()
	 write(6,*) ""
	 write(6,*) "response function is not well-behaved."
	 write(6,*) "edges found are not reliable."
	 write(6,*) ""
       return
       end

       subroutine skerr(nerr,ck)
       character*(*) ck
       character*1 aa

10     format(a,$)
       write(6,'(a8,i3,2a16)') "error: ",nerr," when accessing ",ck
       write(6,10) "continue? (y/n): "
       read(5,'(a)') aa
       if (aa.eq."y") return
       stop
       end

       subroutine wrerr()
	  write(6,'(a)') "not a valid option, again:"
       return
       end

*     from numerical recipes:
      SUBROUTINE FOUR1(DATA,NN,ISIGN)
      REAL*8 WR,WI,WPR,WPI,WTEMP,THETA
      DIMENSION DATA(*)
      N=2*NN
      J=1
      DO 11 I=1,N,2
        IF(J.GT.I)THEN
          TEMPR=DATA(J)
          TEMPI=DATA(J+1)
          DATA(J)=DATA(I)
          DATA(J+1)=DATA(I+1)
          DATA(I)=TEMPR
          DATA(I+1)=TEMPI
        ENDIF
        M=N/2
1       IF ((M.GE.2).AND.(J.GT.M)) THEN
          J=J-M
          M=M/2
        GO TO 1
        ENDIF
        J=J+M
11    CONTINUE
      MMAX=2
2     IF (N.GT.MMAX) THEN
        ISTEP=2*MMAX
        THETA=6.28318530717959D0/(ISIGN*MMAX)
        WPR=-2.D0*DSIN(0.5D0*THETA)**2
        WPI=DSIN(THETA)
        WR=1.D0
        WI=0.D0
        DO 13 M=1,MMAX,2
          DO 12 I=M,N,ISTEP
            J=I+MMAX
            TEMPR=SNGL(WR)*DATA(J)-SNGL(WI)*DATA(J+1)
            TEMPI=SNGL(WR)*DATA(J+1)+SNGL(WI)*DATA(J)
            DATA(J)=DATA(I)-TEMPR
            DATA(J+1)=DATA(I+1)-TEMPI
            DATA(I)=DATA(I)+TEMPR
            DATA(I+1)=DATA(I+1)+TEMPI
12        CONTINUE
          WTEMP=WR
          WR=WR*WPR-WI*WPI+WR
          WI=WI*WPR+WTEMP*WPI+WI
13      CONTINUE
        MMAX=ISTEP
      GO TO 2
      ENDIF
      RETURN
      END

      subroutine fft(mx,sig,nlen,dt,isign,spec,nfrq,df,cmplt,data)
c to complete fast fourier transform with four1.f from
c numerical recipes. assuming: t --> f with exp(-iwt)
c and: f --> t with exp(iwt).
c INPUT: isign and space defining array data and:
c input with isign -1: a real time series (sig) with
c arbitrary length (nlen) and sample separation dt; 
c output for isign=-1: spec,nfrq,df,cmplt
c input with isign=1: a complex spectrum (spec)
c with length nfrq and sample separation df, also
c cmplt (if false then the spectrum for c neg. freq. 
c will be calculated from conjg(spec frq>=0)) 
c output for isign=1: sig,nfrq,dt
c if nfrq<nxtnyq (the nyquistindex (nxt/2+1) the
c spectrum is padded with zeroes.
c SL 1994

      logical cmplt
      dimension sig(mx)
      dimension data(2*mx)
      complex spec(mx)
      complex i90
      data i90/(0.,1.)/

      if (isign.eq.-1) then
         i=0
         do while (2**i.lt.nlen) 
	    i=i+1
         enddo
         nxt=2**i
	 if (nxt.gt.mx) stop "array limit nxt exceeded"
c padding of sig with zeroes: 
         do i=nlen+1,nxt
            sig(i)=0.
         enddo
         do i=1,nxt
	    data(2*i-1)=sig(i)
	    data(2*i)=0.
         enddo
         call four1(data,nxt,isign)  
         do i=1,nxt
	    spec(i)=data(2*i-1)+i90*data(2*i)
	    spec(i)=dt*spec(i)
         enddo
         nfrq=nxt
         df=1./(nxt*dt)
      else if (isign.eq.1) then
         i=0
         do while (2**i+1.lt.nfrq) 
	    i=i+1
         enddo
	 if (cmplt) then
	    nxt=nfrq
	 else
	    nxt=2**(i+1)
            nxtnyq=2**i+1
c padding of spec with zeroes:
            do i=nfrq+1,nxtnyq
               spec(i)=cmplx(0.,0.)
	    enddo
c assume real time series, cmplx conjg symm spec:
            do i=nxtnyq+1,nxt
               spec(i)=spec(nxtnyq-(i-nxtnyq))
	    enddo
	 endif
         if (nxt.gt.mx) stop "array limit nxt exceeded"
	 do i=1,nxt
	    data(2*i-1)=real(spec(i))
	    data(2*i)=imag(spec(i))
	 enddo
         call four1(data,nxt,isign)  
	 do i=1,nxt
	    sig(i)=data(2*i-1)
	    sig(i)=df*sig(i)
	 enddo
	 nlen=nxt
	 dt=1./(nxt*df)
	 cmplt=.true.
      else
	 stop "fft direction not defined!"
      endif

      return
      end


       subroutine chooseedges(user,df,ned,tp)
       dimension ned(4),tp(4)
       character*8 user
       character*20 name,name2
       character*28 command
       common/information/info
       name = '/tmp/smac.'//user
       open(1,file=name)
       rewind 1
       write(1,*) "bd x"
       write(1,*) "qdp off"
       write(1,*) "pause"
       name = '/tmp/specd.'//user
       name2 = '/tmp/specr.'//user
       write(1,*) "r ",name,name2
       write(1,*) "xlim ",df,ned(4)*df
       write(1,*) "xlog"
       write(1,*) "ylog"
       write(1,*) "p1"
       write(1,*) "pause"
       write(1,*) "ppk"
       write(1,*) "w over"
       close(1)
       write(6,*) ""
       if (info.eq.1) then
          write(6,*) "A sac ppk-window will be opened now."
          write(6,*) "Pick 4 frequencies, T0,T1,T2 and T3,"
          write(6,*) "in the top window"
          write(6,*) "Then quit SAC"
       endif
       write(6,*) ""
       command = 'sac /tmp/smac.'//user
       write(6,*) command
       call system(command)
       name = '/tmp/specd.'//user
       call rsac1(name,x,nd,bd,dtd,mx,nerr)
       call getfhv("T0",tp(1),nerr)
       if (nerr.gt.0) call skerr(nerr,"T0")
       call getfhv("T1",tp(2),nerr)
       if (nerr.gt.0) call skerr(nerr,"T1")
       call getfhv("T2",tp(3),nerr)
       if (nerr.gt.0) call skerr(nerr,"T2")
       call getfhv("T3",tp(4),nerr)
       if (nerr.gt.0) call skerr(nerr,"T3")
       if (tp(1).gt.tp(2)) call prerr()
       if (tp(3).gt.tp(4)) call prerr()
       if (tp(3).le.tp(2)) call prerr()

       i=1
       do while ((i-1)*df.lt.tp(1))
	  i=i+1
       enddo
       ned(1)=i
       do while ((i-1)*df.lt.tp(2))
	  i=i+1
       enddo
       ned(2)=i
       ned(3)=int(tp(3)/df)+1
       ned(4)=int(tp(4)/df)+1

       return
       end


       subroutine readedges(df,ned,tp)
*       parameter(taper=0.4)
       parameter(taper=0.2)
       dimension ned(4),tp(4)
       common/information/info
       if (info.eq.1) then
          write(6,*) "T0 and T1 are lower and low frequency for"
          write(6,*) "taper edges at low frequency edge of spectrum."
          write(6,*) "T2 and T3 are high and higher frequency for"
          write(6,*) "taper edges at high frequency edge of spectrum."
       endif
       write(6,*) "give T0, T1, T2, T3:"
       read(5,*) (tp(i),i=1,4)
       if (tp(1).gt.tp(2)) call prerr()
       if (tp(1).gt.(1.-taper)*tp(2)) then
	  write(6,*) 'need a larger bottom-width for taper.'
       endif 
       if (tp(4).lt.(1.+taper)*tp(3)) then
	  write(6,*) 'need a larger top-width for taper.'
       endif 
       if (tp(3).gt.tp(4)) call prerr()
       if (tp(3).le.tp(2)) call prerr()

       i=1
       do while ((i-1)*df.lt.tp(1))
	  i=i+1
       enddo
       ned(1)=i
       do while ((i-1)*df.lt.tp(2))
	  i=i+1
       enddo
       ned(2)=i
       ned(3)=int(tp(3)/df)+1
       ned(4)=int(tp(4)/df)+1

       return
       end


       subroutine deconv(n,r,spec,ned)
       parameter(pi=3.14159)
       dimension ned(4)
       complex r(n),spec(n)
       do i=ned(2),ned(3)
          if (cabs(r(i)).eq.0.) call prerr()
          spec(i)=spec(i)/r(i)
       enddo
       do i=2,ned(1)-1
          spec(i)=cmplx(0.,0.)
       enddo
       do i=ned(4)+1,n
          spec(i)=cmplx(0.,0.)
       enddo
       do i=ned(1),ned(2)-1
          if (cabs(r(i)).eq.0.) call prerr()
          spec(i)=spec(i)/r(i)
          taper=(1-cos((i-ned(1))*pi/(ned(2)-ned(1))))/2.
	  spec(i)=spec(i)*taper
       enddo
       do i=ned(3)+1,ned(4)
	  if (cabs(r(i)).eq.0.) call prerr()
          spec(i)=spec(i)/r(i)
	  taper=(1-cos((i-ned(4))*pi/(ned(3)-ned(4))))/2.
	  spec(i)=spec(i)*taper
       enddo
       spec(n)=cmplx(0.,0.)
       return
       end


       subroutine equiv(kcmpnm)
       character*8 kcmpnm
       if(kcmpnm(1:3).eq.'LPZ') kcmpnm(1:3)='LHZ'
       if(kcmpnm(1:3).eq.'LPN') kcmpnm(1:3)='LHN'
       if(kcmpnm(1:3).eq.'LPE') kcmpnm(1:3)='LHE'
       if(kcmpnm(1:3).eq.'IPZ') kcmpnm(1:3)='BHZ'
       if(kcmpnm(1:3).eq.'IPN') kcmpnm(1:3)='BHN'
       if(kcmpnm(1:3).eq.'IPE') kcmpnm(1:3)='BHE'
       return
       end


       subroutine getedges(n,r,ifltr,ned)
       complex r(n)
       parameter(eps1=1.e-1)
       parameter(eps=1.e-2)
       parameter(eps0=1.e-3)
       dimension ned(4)
       common/information/info

       call maxr(r,n,rmx,irmx)

	write(6,*) ""
	if (info.eq.1) then
        write(6,*) "the instrument response is significant in a limited"
	   write(6,*) "frequency band. Do you want "
	   write(6,*) "interactive filtering (2) or predetermined" 
	   write(6,*) "filtering (3)?"
	   write(6,*) ""
*	   write(6,*) "(* automatic filtering sets the signal spectrum to zero"
*	   write(6,*) "when the response is smaller than",eps*100.,"% of the"
*	   write(6,*) "maximum response on the low side and",eps0*100,"% on the"
*	   write(6,*) "high side. The signal spectrum is tapered towards zero" 
*	   write(6,*) "for the frequencies where the response values are between"
*	   write(6,*) eps1*100.,"% and",eps*100.,"% of the maximum response on the"
*	   write(6,*) "low side and between",eps*100.,"% and",eps0*100.,"% on the"
*	   write(6,*) "high side)"
	   write(6,*) "P.S. interactive hasn't been used in a long time"
           write(6,*) "     and may be broken"
	   write(6,*) ""
        write(6,*) "(* interactive filtering pops up a sac-ppk window,"
	write(6,*) "in which u pick 4 freqs (T0-T3); deconvolution"
	   write(6,*) "is retained between T1 and T2, tapers to zero are"
	   write(6,*) "applied between T1 and T0 and between T2 and T3)"
	   write(6,*) ""
	write(6,*) "(* predetermined filtering asks for 2 low frequency"
	   write(6,*) "taper edges and for 2 high frequency taper edges)"
	else
*	   write(6,*) "automatic (1), interactive (2) filtering or"
	   write(6,*) "interactive (2) filtering or"
	   write(6,*) "predetermined filtering (3)?"
	   write(6,*) "P.S. intereactive is probably broken" 
	endif
        write(6,*) ""
10      format(a,$)
40      write(6,10) "give option: "
	read(5,*) ifltr
*	if (ifltr.ne.1.and.ifltr.ne.2.and.ifltr.ne.3) then
	if (ifltr.ne.2.and.ifltr.ne.3) then
	   call wrerr()
	   goto 40
	endif

c Assume response is well behaved, i.e. it has a maximum between 0 and 
c nnyq, and is zero for f-->0 and f-->fnyq.
       i=1
       rr=cabs(r(i))/(rmx*eps)
       do while (rr.lt.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps)
       enddo
       ned(1)=i
       rr=cabs(r(i))/(rmx*eps1)
       do while (rr.lt.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps1)
       enddo
       ned(2)=i
       rr=cabs(r(i))/(rmx*eps)
       do while (rr.ge.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps)
       enddo
       ned(3)=i-1
       rr=cabs(r(i))/(rmx*eps0)
       do while (rr.ge.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps0)
       enddo
       ned(4)=i-1

c check for well-behavedness:
       if (ned(1).ge.irmx) call prerr()
       if (ned(2).ge.irmx) call prerr()
c the following needs not to be related to mis-behavedness:
c       if (ned(3).le.irmx) call prerr()
c       if (ned(4).le.irmx) call prerr()
       if (ned(4).gt.n) call prerr()
       do i=1,4
	  if(ned(i).eq.0) call prerr()
       enddo

       return
       end


       subroutine maxr(r,n,rmx,irmx)
       complex r(n)

       rmx=0
       do i=1,n
	  rr=cabs(r(i))
	  if (rr.gt.rmx) then
	     rmx=rr
	     irmx=i
	  endif
       enddo
       return
       end

       subroutine getend(chrctr,length,mxc)
       character*(*) chrctr

       i = 1
       do while (chrctr(i:i).ne.' '.and.i.le.mxc)
          i = i+1
       enddo
       length = i-1
       return
       end

        subroutine pzfile(respfl,istat)
        character respfl*70
        character*15 towhat
        complex p,z
        common/poze/fmul,z(20),p(50),nz,np
 
        print*, respfl
        open(2,file=respfl,err=90)
        rewind 2
        read(2,'(i2,1x,a15)') np,towhat
        if(np.gt.50)then
           write(*,*)' warning: only read up to 50 poles'
           np=50
        endif
        read(2,*)(p(i),i=1,np)
        read(2,*) nz
        if(nz.gt.20)then
           write(*,*)' warning: only read up to 20 zeros'
           nz=20
        endif
        read(2,*)(z(i),i=1,nz)
        if (towhat.eq.'displacement') then
* change to response to velocity, subtract a zero zero:
           i = 1
           do while (z(i).ne.cmplx(0.,0.))
              i = i + 1
           enddo
           if (i.gt.nz) then
              write(6,*) 'Error, no zero zero found'
              stop
           else
              nz = nz - 1
              do j = i,nz
                 z(j) = z(j+1)
              enddo
           endif
        else if (towhat.eq.'velocity') then
           continue
        else 
           write(6,*) 'cannot determine response to what'
           call skerr(-3,respfl)
        endif
        read(2,*) fmul
        goto 100
90      write(*,'(a)') respfl,'could not be opened'
100     close(2)
        istat=0
        return
        end

       complex function resp(w)

c      gives response at complex frequency s=i*omega=i*2*pi*f
c      np poles stored in p, nz zeroes in z, normalization and
c      sensitivity combined in fmul.
c      output is response resp(w)

       complex s,zz,rr
       complex p,z
       common/poze/fmul,z(20),p(50),nz,np

       s=cmplx(0.,1.)*w
       rr = cmplx(1.,0.)
       do 10 j = 1,nz
         zz = z(j)
         rr = rr*(s-zz)
10     continue
       do 20 j = 1,np
         zz = p(j)
         rr = rr/(s-zz)
20     continue
       resp=fmul*rr
       return
       end
