function [a] = write_kml_locs(fid,sta_name,tmp,tstart,tend,col)
% Function to write out a set of TA stations as Google Earth placemarks
%
% assumes you have already called write_kml_preamble to set up the KML
% preamble and set the placemark definitions that are used below.
%
% Input:
%   fid = fileid
%   sta_name = array of station names
%   tstart = array of station installation dates
%   tend = array of station end dates
%   lat  = station latitudes
%   lon = station longitudes
%
% Output:
%   KML code written to fid
%
a = -1;

for i = 1:size(tmp,1)
[iy1,imo1,id1,ih1,im1,ss1] = datevec(tstart(i));
[iy2,imo2,id2,ih2,im2,ss2] = datevec(tend(i));

    if isfinite(tmp(i,2))
    c = fprintf(fid,'%s%s%s\n','<Placemark id="TA-',sta_name{i,1},'">'); % provide an identifier for this placemark
%
% next two lines define text used in the lefhand panel that appears on the
% google earth display
    c = fprintf(fid,'%s%s%s\n','       <name>', sta_name{i,1},'</name>');  % this is text that appears in the left side of the google earth display
    c = fprintf(fid,'%s%4d%s%4d%s\n','       <Snippet maxLines="1">', iy1,' - ',iy2,'</Snippet>'); % additional text that appears on the left panel
%
% select the style of this placemark    
    c = fprintf(fid,'%s%02d%s\n','    <styleUrl>#TA',col(i),'</styleUrl>');  % select placemark style based on values in col()
%
% here is where we define the timespan of this symbol    
    c = fprintf(fid,'%s\n','    <TimeSpan>');
    c = fprintf(fid,'%s%d%s%02d%s%02d%s%02d%s%02d%s%02d%s\n','        <begin>',iy1,'-',imo1,'-',id1,'T',ih1,':',im1,':',ss1,'Z</begin>');
    c = fprintf(fid,'%s%d%s%02d%s%02d%s%02d%s%02d%s%02d%s\n','        <end>  ',iy2,'-',imo2,'-',id2,'T',ih2,':',im2,':',ss2,'Z</end>');
    c = fprintf(fid,'%s\n','    </TimeSpan>');
%
% set coordinates of the placemark    
    c = fprintf(fid,'%s\n','    <Point>');
    c = fprintf(fid,'%s\n','    <altitudeMode>absolute</altitudeMode>');
% note that we are using a bogus altitude, so we can use an oblique view
% to see vertical separation of the different styles of placemarks
    c = fprintf(fid,'%s%f%s%f%s%d%s\n','        <coordinates>',tmp(i,2),',',tmp(i,1),',',col(i)*10000,'</coordinates>');
    c = fprintf(fid,'%s\n','    </Point>');
%
% text that appears in the balloon if you click on a placemark 
    c = fprintf(fid,'%s\n', '    <description>');
    
    c = fprintf(fid,'%s%s%s\n','<p>',sta_name{i,1},'</p>');
    
    c = fprintf(fid,'%s', '<p>Start Acquisition - ');
    c = fprintf(fid,'%s',sta_name{i,9});
    c = fprintf(fid,'%s\n', '(GMT)</p>');
    
    c = fprintf(fid,'%s', '<p>Declination - ');
    c = fprintf(fid,'%d',tmp(i,4));
    c = fprintf(fid,'%s\n', 'W</p>');
    
    c = fprintf(fid,'%s', '<p>Elevation - ');
    c = fprintf(fid,'%d',tmp(i,3));
    c = fprintf(fid,'%s\n', 'm</p>');
    
    c = fprintf(fid,'%s', '<p>Sensor - ');
    c = fprintf(fid,'%s',sta_name{i,6});
    c = fprintf(fid,'%s\n', '</p>');
    
    c = fprintf(fid,'%s', '<p>');
    c = fprintf(fid,'%s',sta_name{i,8});
    c = fprintf(fid,'%s\n', '</p>');
    
    c = fprintf(fid, '%s', '<br/><img src=" /Users/trevor/Desktop/pics/');
    c = fprintf(fid,'%s', sta_name{i,12}); 
    c = fprintf(fid, '%s\n', '" width="100" height="100" /><br/>');
    
    %c = fprintf(fid,'%s', '<p><link>'); 
    %c = fprintf(fid,'%s', sta_name{i,11}); 
    %c = fprintf(fid,'%s\n', '</link></p>');
    
    c = fprintf(fid, '%s', '<![CDATA[<a href="http://www.iris.edu">Here is the IRIS Website</a>]]>');
      
    c = fprintf(fid,'%s\n', '    </description>');    
    c = fprintf(fid,'%s\n','</Placemark>');
    end;
end;
a = 0;


