      function [epoch] = epoch(iy,id,ih,im,sec)
% Converts yr,day,hr,mn,sec to epochal time which is defined by CSS to
% be the time in seconds from 1970 day 0.
% Note that this version computes the real*8 number of seconds since
% 1970.
% On input, sec can be greater than 60.
%
% input:
%  iy = year
%  id = day of year (often called Julian day)
%  ih = hour
%  im = minute
%  sec = seconds
% output:
%  epoch = time, in seconds, since the beginning of 1970
%
      ky = iy;
      if ky < 100
          ky = ky + 1900;
      end;
      if ky<1970 
          error('ERROR: year < 1970 in ipoch');
      end;
      time = (( (id-1)*24.d0 + ih)*60.d0 + im)*60.d0+sec;
      while ky > 1970
          ky   = ky-1;
          idpy = 365;
          if mod(ky,4) == 0
              idpy=366;
          end;
          time = time + 86400.d0 * idpy;
      end;
      epoch = time;