#!/bin/python
# Generate kml file for vertical slices of a tomographic model.
### xlou 08/25/2010

from numpy import *
import os,sys
import geo
import color

try:
	iv = int(sys.argv[1])
except:
	usage = 'Usage: %s profile-id' % sys.argv[0]
	print usage
	sys.exit()

### get slices of tomographic model
idir = './na04/'
ifile = 'NA04_t' + str(iv)
mfile = 'mhNA04_t' + str(iv)
ifilenm = idir + ifile
mfilenm = idir + mfile
ofilenm = 'v'+ifile+'.kml'


xfile = idir + 'xsec.txt'
xx = loadtxt(xfile,usecols=(1,2,3,4))
lat0,lon0,lat1,lon1 = xx[iv-1,:]

print ifilenm, mfilenm, ofilenm
print lat0,lon0,lat1,lon1

### load model
dx = .25
dr = 30*1000
dt,az = geo.deltaz(lat0,lon0,lat1,lon1)


vvalues = loadtxt(ifilenm)
mvalues = loadtxt(mfilenm)
 
ntomo = len(vvalues)
vmax = 0
for i in arange(ntomo):
    vel=vvalues[i,2]
    if vel < 9000 and abs(vel) > vmax:
        vmax = abs(vel)

# brighter the scale
vmax *= .7

### generate kml
ofile = open(ofilenm,'w')
ofile.write('<kml>\n')
ofile.write('<Document>\n')
ofile.write('<name>')
ofile.write(ofilenm[:-4])
ofile.write('</name>\n')

white = color.kmlhex(255,255,255)
black = color.kmlhex(0,0,0)
green = color.kmlhex(0,255,0)

# depth above the ground
adep = 1000
a410 = abs(adep-410)*1000
a660 = abs(adep-660)*1000

### polygons for tomographic model
for i in arange(ntomo):
	delta = -vvalues[i,0] + 90 + dt*.5
	depth = 6400 - vvalues[i,1]
	vel = vvalues[i,2]
	alt = abs(adep-depth)*1000
	
	plat0, plon0 = geo.azdelt(lat0,lon0,delta-dx*.5,az)
	plat1, plon1 = geo.azdelt(lat0,lon0,delta+dx*.5,az)
	
	if vel >  9000:
	    continue
	ratio = vel/vmax
	r,g,b = color.rgb(ratio)
	col = color.kmlhex(r,g,b)

	ofile.write('<Placemark>\n')
	ofile.write('<Style>\n')
	ofile.write('<LineStyle>')
	ofile.write('<width>0</width>')
	ofile.write('</LineStyle>')
	ofile.write('<PolyStyle>\n')
	ofile.write('<color>' + col + '</color>\n')
	ofile.write('</PolyStyle>\n')   
	ofile.write('</Style>\n')
	ofile.write('<name>'+str(i)+'</name>\n')
	ofile.write('<Polygon>\n')
	ofile.write('<altitudeMode>absolute</altitudeMode>\n')
	ofile.write('<outerBoundaryIs>\n')
	ofile.write('<LinearRing>\n')
	ofile.write('<coordinates>\n')
	ofile.write('%f, %f, %f \n' % (plon0,plat0,alt-dr*.5))
	ofile.write('%f, %f, %f \n' % (plon1,plat1,alt-dr*.5))
	ofile.write('%f, %f, %f \n' % (plon1,plat1,alt+dr*.5))
	ofile.write('%f, %f, %f \n' % (plon0,plat0,alt+dr*.5))
	ofile.write('</coordinates>\n')
	ofile.write('</LinearRing>\n')
	ofile.write('</outerBoundaryIs>\n')
	ofile.write('</Polygon>\n') 
	ofile.write('</Placemark>\n')

### add lines
linecol = white


# add moho line
ofile.write('<Placemark>\n')
ofile.write('<Style>\n')
ofile.write('<LineStyle>')
ofile.write('<width>1</width>')
ofile.write('<color>' + linecol + '</color>\n')
ofile.write('</LineStyle>')
ofile.write('</Style>\n')
ofile.write('<name>Moho</name>\n')
ofile.write('<LineString>\n')
ofile.write('<altitudeMode>absolute</altitudeMode>\n')
ofile.write('<coordinates>\n')

nmoho = len(mvalues)
for i in arange(nmoho):
	delta = -mvalues[i,0] + 90 + dt*.5
	depth = 6400 - mvalues[i,1]
	alt = abs(adep-depth)*1000
	plat0, plon0 = geo.azdelt(lat0,lon0,delta-dx*.5,az)
	plat1, plon1 = geo.azdelt(lat0,lon0,delta+dx*.5,az)
	ofile.write('%f, %f, %f \n' % (plon0,plat0,alt))
	ofile.write('%f, %f, %f \n' % (plon1,plat1,alt))
ofile.write('</coordinates>\n')
ofile.write('</LineString>\n') 
ofile.write('</Placemark>\n')

# add 410d and 660d lines
mand = ['410d','660d']
altd = [a410,a660]
for j in arange(len(mand)):
	ofile.write('<Placemark>\n')
	ofile.write('<Style>\n')
	ofile.write('<LineStyle>')
	ofile.write('<width>1</width>')
	ofile.write('<color>' + linecol + '</color>\n')
	ofile.write('</LineStyle>')
	ofile.write('</Style>\n')
	ofile.write('<name>' + mand[j] + '</name>\n')
	ofile.write('<LineString>\n')
	ofile.write('<altitudeMode>absolute</altitudeMode>\n')
	ofile.write('<coordinates>\n')
	for i in arange(nmoho):
		delta = -mvalues[i,0] + 90 + dt*.5
		depth = 6400 - mvalues[i,1]
		alt = abs(adep-depth)*1000
		plat0, plon0 = geo.azdelt(lat0,lon0,delta-dx*.5,az)
		plat1, plon1 = geo.azdelt(lat0,lon0,delta+dx*.5,az)
		ofile.write('%f, %f, %f \n' % (plon0,plat0,altd[j]))
		ofile.write('%f, %f, %f \n' % (plon1,plat1,altd[j]))
	ofile.write('</coordinates>\n')
	ofile.write('</LineString>\n') 
	ofile.write('</Placemark>\n')

# extend to surface

for ll in ((lon0,lat0),(lon1,lat1)):
	ofile.write('<Placemark>\n')
	ofile.write('<Style>\n')
	ofile.write('<LineStyle>')
	ofile.write('<width>1</width>')
	ofile.write('<color>' + linecol + '</color>\n')
	ofile.write('</LineStyle>')
	ofile.write('</Style>\n')
	ofile.write('<name>Moho</name>\n')
	ofile.write('<LineString>\n')
	ofile.write('<altitudeMode>absolute</altitudeMode>\n')
	ofile.write('<coordinates>\n')
	ofile.write('%f, %f, %f \n' % (ll[0],ll[1],adep*1000))
	ofile.write('%f, %f, %f \n' % (ll[0],ll[1],0))
	ofile.write('</coordinates>\n')
	ofile.write('</LineString>\n') 
	ofile.write('</Placemark>\n')

# add marker on surface
for ll in ((lon0,lat0),(lon1,lat1)):
	ofile.write('<Placemark>\n')
	ofile.write('<Style>\n')
	ofile.write('<PolyStyle>\n')
	ofile.write('<color>' + col + '</color>\n')
	ofile.write('</PolyStyle>\n')   
	ofile.write('</Style>\n')
	ofile.write('<name>'+str(i)+'</name>\n')
	ofile.write('<Polygon>\n')
	ofile.write('<altitudeMode>absolute</altitudeMode>\n')
	ofile.write('<outerBoundaryIs>\n')
	ofile.write('<LinearRing>\n')
	ofile.write('<coordinates>\n')
	plon = ll[0]
	plat = ll[1]
	dx,dy = .25,.25
	ofile.write('%f, %f \n' % (plon+dx,plat+dy))
	ofile.write('%f, %f \n' % (plon-dx,plat+dy))
	ofile.write('%f, %f \n' % (plon-dx,plat-dy))
	ofile.write('%f, %f \n' % (plon+dx,plat-dy))
	ofile.write('</coordinates>\n')
	ofile.write('</LinearRing>\n')
	ofile.write('</outerBoundaryIs>\n')
	ofile.write('</Polygon>\n') 
	ofile.write('</Placemark>\n')

### end of kml
ofile.write('</Document>\n')
ofile.write('</kml>\n')
ofile.close()
