#!/bin/python
# Generate kml file for horizontal slices of a tomographic model.
### xlou 08/25/2010

from numpy import *
import os,sys
import geo
import color

try:
	tdep = sys.argv[1]
except:
	usage = 'Usage: %s depth(70/90/110...) above/below ' % sys.argv[0]
	print usage
	sys.exit()

# above ground?
try:
	above = sys.argv[2]
except:
	above = 'a'

if len(above) > 0 and above[0] == 'a':
	abg = 'a'
else:
	abg = 'b'
	

### get slices of tomographic model
idir = './na04/'
ifile = 'NA04_d' + tdep
ifilenm = idir + ifile


ofilenm = abg + 'h'+ifile+'.kml'
print ifilenm, ofilenm

### load model
dx = .25
dy = .25

vvalues = loadtxt(ifilenm)
 
ntomo = len(vvalues)
vmax = 0
for i in arange(ntomo):
    vel=vvalues[i,2]
    if vel < 9000 and abs(vel) > vmax:
        vmax = abs(vel)

# brighter the scale
vmax *= .7

### generate kml
ofile = open(ofilenm,'w')
ofile.write('<kml>\n')
ofile.write('<Document>\n')
ofile.write('<name>')
ofile.write(ofilenm[:-4])
ofile.write('</name>\n')

# depth above the ground
adep = 1000
a410 = abs(adep-410)*1000
a660 = abs(adep-660)*1000

tdep = int(tdep)
alt = abs(adep-tdep)*1000

# opacity
opa = '7f'
opa = 'ff'

### polygons for tomographic model
for i in arange(ntomo):
	plon = vvalues[i,0]
	plat = vvalues[i,1]
	vel = vvalues[i,2]
	if vel >  9000:
	    continue
	ratio = vel/vmax
	r,g,b = color.rgb(ratio)
	col = color.kmlhex(r,g,b,opa)

	ofile.write('<Placemark>\n')
	ofile.write('<Style>\n')
	ofile.write('<LineStyle>')
	ofile.write('<width>0</width>')
	ofile.write('</LineStyle>')
	ofile.write('<PolyStyle>\n')
	ofile.write('<color>' + col + '</color>\n')
	ofile.write('</PolyStyle>\n')   
	ofile.write('</Style>\n')
	ofile.write('<name>'+str(i)+'</name>\n')
	ofile.write('<Polygon>\n')
	ofile.write('<altitudeMode>absolute</altitudeMode>\n')
	ofile.write('<outerBoundaryIs>\n')
	ofile.write('<LinearRing>\n')
	ofile.write('<coordinates>\n')
	if abg == 'a':
		ofile.write('%f, %f, %f \n' % (plon+dx,plat+dy,alt))
		ofile.write('%f, %f, %f \n' % (plon-dx,plat+dy,alt))
		ofile.write('%f, %f, %f \n' % (plon-dx,plat-dy,alt))
		ofile.write('%f, %f, %f \n' % (plon+dx,plat-dy,alt))
	else:
		ofile.write('%f, %f \n' % (plon+dx,plat+dy))
		ofile.write('%f, %f \n' % (plon-dx,plat+dy))
		ofile.write('%f, %f \n' % (plon-dx,plat-dy))
		ofile.write('%f, %f \n' % (plon+dx,plat-dy))
	ofile.write('</coordinates>\n')
	ofile.write('</LinearRing>\n')
	ofile.write('</outerBoundaryIs>\n')
	ofile.write('</Polygon>\n') 
	ofile.write('</Placemark>\n')

### end of kml
ofile.write('</Document>\n')
ofile.write('</kml>\n')
ofile.close()
