#!/bin/python
# Module for color format conversion and generation of color scale.
# rgb --> hexadecimal notation
### xlou 08/25/2010

from numpy import *
from pylab import *

def rgb2hex(r,g,b):
	"""
	Convert RGB value to hex for *ml.
	From  http://blog.affien.com/archives/2004/12/20/rgb-to-hex-and-why-the-python-interactive-mode-is-so-damned-handy/
	"""
	hexchars = "0123456789ABCDEF"
	r = int(r)
	g = int(g)
	b = int(b)
	h = hexchars[r/16] + hexchars[r%16] + hexchars[g/16] + hexchars[g%16] + hexchars[b/16] + hexchars[b%16]
	return h

def kmlhex(r,g,b,a='FF'):
	"""
	KML: Color and opacity (alpha) values are expressed in hexadecimal notation: aabbggrr.
	Example: 7fff0000--> 50% opacity blue.
	"""
	h = rgb2hex(b,g,r)
	return a + h

def rgb(x,mag=1,rev=1):
	"""
	cpt: dark blue to red or reversed (default)
	4 segments: xmin - x1 - x0 - x2 - xmax
	"""
	xmin = -mag
	xmax = mag
	dx = xmax - xmin
	x0 = 0.5*(xmax+xmin)
	x1 = xmin + .2*dx
	x2 = xmin + .8*dx
	b1 = 100
	r1 = 100
	if x < xmin:
		r,g,b = 0,0,b1
	elif x < x1:
		r = 0
		g = 0
		b = b1 + (255.-b1)/(x1-xmin)*(x-xmin)
	elif x < x0:
		b = 255
		r = 255./(x0-x1)*(x-x1)
		g = 255./(x0-x1)*(x-x1)
	elif x < x2:
		r = 255
		g = 255 - 255./(x2-x0)*(x-x0)
		b = 255 - 255./(x2-x0)*(x-x0)
	elif x < xmax:
		g,b = 0,0
		r = 255 - (255.-b1)/(xmax-x2)*(x-x2)
	else:
		r,g,b = r1,0,0

	# reverse red and blue
	if rev == 1:
		bb = b
		b = r
		r = bb
	return int(r),int(g),int(b)

### load and plot cpt
if __name__ == '__main__':
	fig = figure(figsize=(8,6))
	ax = fig.add_subplot(111)

	mag = 4
	n = 101
	dx = mag*1.0/(n-1)
	for i in arange(-n+1,n):
		x = i*dx
		r,g,b = rgb(x,mag)
		if i%10 == 0:
			print x,r,g,b
		hex = rgb2hex(r,g,b)
		col = '#' + hex
		plot(x,r,'r.')
		plot(x,g,'g.')
		plot(x,b,'b.')
		ax.broken_barh([(x-dx/2,dx)],(265,30),facecolors=col,edgecolor=col)
	ax.set_xlim(-mag,mag)
	ax.set_ylim(-10,300)
	
	grid()
	title('Color Scale')
	xlabel('X')
	ylabel('RGB values')
	fignm = 'cpt.png'
	fig.savefig(fignm,format='png')
	show()
	

