% Splitlab Configureation GUI helper function


h.panel(3) = uipanel('Units','pixel','Title','Earthquake window',...
    'BackgroundColor', [224   223   227]/255 ,'FontSize',10,'Position',[130 5 425 410]);

x = 212;
y = 160;
tmp=uipanel('Parent',h.panel(3),'Units','pixel','Title','start date',...
    'FontSize',10,'Position',[113 340 190 50],'TitlePosition','centertop', 'BackgroundColor', [224   223   227]/255 );

axes( 'parent',h.panel(3), 'Units','pixel','position', [10 330 48 48] )
image(icon.calendar)
axis off



h.eqdata(1) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[7 7 50 20],...
    'String', {num2str((1:31)')},...
    'Value',config.twin(1),...
    'Callback','config.twin(1)= get(gcbo,''Value'');');
h.eqdata(2) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[62 7 55 20],...
    'String', {'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Okt','Nov','Dec'},...
    'Callback','config.twin(2)= get(gcbo,''Value'');',...
    'Value',config.twin(2));
today=datevec(now);
h.eqdata(3) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[122 7 60 20],...
    'String', {num2str((1976:today(1))')},...
    'Value',config.twin(3)-1975,...
    'Callback','config.twin(3)= get(gcbo,''Value'')+1975;');

tmp=uipanel('Parent',h.panel(3),'Units','pixel','Title','end date',...
    'FontSize',10,'Position',[113 280 190 50],'TitlePosition','centertop', 'BackgroundColor', [224   223   227]/255 );
h.eqdata(4) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[7 7 50 20],...
    'String', {num2str((1:31)')},...
    'Callback','config.twin(4)= get(gcbo,''Value'');',...
    'Value',config.twin(4));

h.eqdata(5) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[62 7 55 20],...
    'String', {'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Okt','Nov','Dec'},...
    'Value',config.twin(5),...
    'Callback','config.twin(5)= get(gcbo,''Value'');');

h.eqdata(6) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[122 7 60 20],...
    'String', {num2str((1976:today(1))')},...
    'Value',config.twin(6)-1975,...
    'Callback','config.twin(6)= get(gcbo,''Value'')+1975;');


%% Magnitude
tmpM=uipanel('Parent',h.panel(3),'Units','pixel','Title','Magnitude window',...
    'FontSize',10,'Position',[15  210 200 50],'TitlePosition','centertop', 'BackgroundColor', [224   223   227]/255 );

h.eqdata(99) = uicontrol('Parent',tmpM,'Units','pixel',...
    'Style','text',...
    'Position',[75 7 50 15],...
    'String', '<= Mw <=');

mag= 4:.25:10;
val= find(mag==config.Mw(1));
h.eqdata(7) = uicontrol('Parent',tmpM,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[10 7 60 20],...
    'String', {num2str(mag','%4.2f')},...
    'Value',val,...
    'Callback','v=get(gcbo,''Value''); s=get(gcbo,''String'');config.Mw(1)=str2num(char(s(v))); clear s v');%, set(get(gcbo,''Userdata''),''String'',num2str(config.Mw(1),3))');


mag= 4:.25:10;
val= find(mag==config.Mw(2));
h.eqdata(9) = uicontrol('Parent',tmpM,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[130 7 60 20],...
    'String', {num2str(mag','%4.2f')},...
    'Value',val,...
    'Callback','v=get(gcbo,''Value''); s=get(gcbo,''String'');config.Mw(2)=str2num(char(s(v))); clear s v');%, set(get(gcbo,''Userdata''),''String'',num2str(config.Mw(2),3))');


%% Distance
tmp=uipanel('Parent',h.panel(3),'Units','pixel','Title','distance window [\circ]',...
    'FontSize',10,'Position',[230  210 180 50],'TitlePosition','centertop', 'BackgroundColor', [224   223   227]/255 );
h.eqdata(99) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','text',...
    'Position',[10 7 30 15],...
    'String', 'min:');
h.eqdata(99) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','text',...
    'Position',[93 7 30 15],...
    'String', 'max:');

h.eqdata(11) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[35 7 55 20],...
    'String', {num2str((0:179)')},...
    'Value',config.eqwin(1)+1,...
    'Callback','config.eqwin(1)=get(gcbo,''Value'')-1;');
h.eqdata(12) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[120 7 55 20],...
    'String', {num2str((1:180)')},...
    'Value',config.eqwin(2),...
    'Callback','config.eqwin(2)=get(gcbo,''Value'');');

%% Depth
tmp=uipanel('Parent',h.panel(3),'Units','pixel','Title','depth window [km]',...
    'FontSize',10,'Position',[123 140 180 50],'TitlePosition','centertop', 'BackgroundColor', [224   223   227]/255 );
h.eqdata(99) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','text',...
    'Position',[10 7 30 15],...
    'String', 'min:');
h.eqdata(99) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','text',...
    'Position',[93 7 30 15],...
    'String', 'max:');

h.eqdata(11) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','edit',...
    'BackgroundColor','w',...
    'Position',[35 7 50 20],...
    'String', num2str(config.z_win(1)),....
    'Callback','config.z_win(1)=str2num(get(gcbo,''String''));');
h.eqdata(12) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','edit',...
    'BackgroundColor','w',...
    'Position',[120 7 50 20],...
    'String', num2str(config.z_win(2)),...
    'Callback','config.z_win(2)=str2num(get(gcbo,''String''));');

%% Catalogue
tmp= uipanel('Parent',h.panel(3),'Units','pixel','Title','Earthquake Catalogue file',...
    'FontSize',8,'Position',[10 10 405 50], 'BackgroundColor', [224   223   227]/255 );

if strcmp(config.catformat,'CMT')
    val=2;
else
    val=1;
end
h.eqdata(15) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','Popupmenu',...
    'BackgroundColor','w',...
    'Position',[10 12 55 18],...
    'String', {'NEIC','CMT'},...
    'Value',val,...
    'ToolTipString', 'calalogue format: NEIC or quickCMT (Harvard)',...
    'Callback','v=get(gcbo,''Value''); s=get(gcbo,''String'');config.catformat=char(s(v)); clear s v');
h.eqdata(17) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','Edit',...
    'BackgroundColor','w',...
    'Position',[100 10 230 20],...
    'ToolTipString',[' ' config.catalogue ' '],...
    'String', config.catalogue,...
    'Callback','if exist(get(gcbo,''String''),''file''),config.catalogue=get(gcbo,''String'');else, beep,set(gcbo,''String'',config.catalogue),end');

str = '{''*.mat'',''*.mat - catalogue files'';  ''*.*'',''*.* - All files''}';
def = '[fileparts(config.catalogue) filesep]';
h.eqdata(16) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','Pushbutton',...
    'Position',[70 10 25 20],...
    'CData', icon.folder,...
    'ToolTipString','Browse',...
    'Userdata',h.eqdata(17),...
    'Callback',['[tmp1,tmp2]=uigetfile(' str ',''Request file'', ' def ');',...
    'if isstr(tmp2), config.catalogue=fullfile(tmp2,tmp1);',...
    '  set(get(gcbo,''Userdata''), ''String'',config.catalogue);',...%update edit field
    'end, clear tmp*']);

h.eqdata(15) = uicontrol('Parent',tmp,'Units','pixel',...
    'Style','Pushbutton',...
    'Position',[340 10 55 20],...
    'String', 'Update',...
    'ToolTipString', 'Update catalogue',...
    'Callback',...
    ['if strcmp(config.catformat,''CMT'');'...
    '   SL_cmtread((config.catalogue));'...
    ' else;'...
    '   SL_neic2mat(config.catalogue);'...
    ' end']);

uicontrol('Parent',h.panel(3),'Units','pixel',...
    'Style','Pushbutton',...
    'Position',[10 70 405 30],...
    'String', 'Search earthquakes',...
    'Callback',['config.db_index=1;',...
    'eq=SL_eqwindow;',...
    'if ~config.showstats, ',...
    '   helpdlg([''Found '' num2str(length(eq)) '' earthquakes! ''], ''Info'');',...
    'else,',...
    '   if ~isempty(eq) , SL_showeqstats,end;',...
    'end;',...
    ' tmp(1) = findobj(''String'', ''Manually associate SAC-files''); tmp(2) = findobj(''String'', ''Automatically associate SAC-files'');',...
    'set(tmp,''Enable'',''on''); clear tmp']);

uicontrol('Parent',h.panel(3),'Units'  ,'pixel',...
    'Style'    ,'checkbox',...
    'Value'    ,config.showstats,...
    'Position' ,[10 110 140 20],...
    'String'   , 'Show statistic plot',...
    'Tag',      'ShowStatsCheck',...
    'Callback' ,'config.showstats=get(gcbo,''Value'');set(findobj(''Tag'',''ShowStatsCheck'') ,''Value'',config.showstats)');