% Splitlab Configureation GUI helper function

Plist={'P','Pdiff','PP','PPP','PcP','PcS','ScS','ScP','PS','SP','S','Sdiff','SS','SKP','PKS','SKS','SKKS','SKiKS','sSKS','pSKS'};

if isempty(config.phases)
    phaseval=15;
else
    phaseval =[];
    %find selected phases in Plist
    for k= 1:length(config.phases)
        ind = strmatch(config.phases(k), Plist, 'exact');
    phaseval = [phaseval ind];
    end
end
config.phases=Plist(phaseval);

    %% Phase data
    h.panel(2) = uipanel('Units','pixel','Title','Phases','FontSize',10,'Position',[130 5 425 410], 'BackgroundColor', [224   223   227]/255 );
    h.phase(1) = uicontrol('Parent',h.panel(2),'Units','pixel',...
                             'Style','PopupMenu',...
                             'BackgroundColor','w',...
                             'Position',[105 250 80 20],...
                             'String', {'PREM','IASP91'},...
                             'Value', strcmp(config.earthmodel,'iasp91')+1,...
                             'CallBack','tmp1=get(gcbo,''Value''); tmp2=lower(get(gcbo,''String'')); config.earthmodel=char(tmp2(tmp1)); clear tmp1 tmp2');
                                                      
    h.phase(2) = uicontrol('Parent',h.panel(2),'Units','pixel',...
                             'Style','List','Min',1,'Max',20,...
                             'BackgroundColor','w',...
                             'Position',[15 15 70 pos(4)-50],...
                             'Value',phaseval,...
                             'String', Plist,...
                             'Callback', 'val=get(gcbo,''Value''); str=get(gcbo,''String''); config.phases=str(val);clear val str ');

 
 h.button(1) = uicontrol('Parent',h.panel(2),'Units','pixel',...
                             'Style','Pushbutton',...
                             'Position',[95 210 100 20],...
                             'String', 'View travel times',...
                             'Callback','SL_ttcurves(config.earthmodel,config.phases, config.z_win(1), mean(config.eqwin), config.eqwin)');

                         
axes( 'parent',h.panel(2), 'Units','pixel','position', [250 200 90 90] )
image(icon.Wclock)
axis off