% Splitlab Configureation GUI helper function

%% GENERAL
%========================================================================

h.panel(6) = uipanel('Units','pixel','Title','General','FontSize',10,...
    'Position',pos + [0 250 0 -250], 'BackgroundColor', [224   223   227]/255 );
h.eqdata(19) = uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','Edit',...
    'BackgroundColor','w',...
    'Position',[50 120 170 20],...
    'ToolTipString','Name of the Project',...
    'String', config.project,...
    'Callback', ['config.project = get(gcbo, ''String'');',...
    'if length(config.project)<4||~strcmp(config.project(end-3:end),''.pjt'');',...
    '  config.project = [config.project ''.pjt''];',...
    '  set(gcbo,''String'',config.project);end'] );


h.eqdata(21) = uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','Edit',...
    'BackgroundColor','w',...
    'Position',[50 80 170 20],...
    'ToolTipString','Seismic data directory' ,...
    'String', config.datadir,...
    'Callback', 'config.datadir=get(gcbo,''String'');');
h.eqdata(20) = uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','Pushbutton',...
    'Position',[15 80 25 20],...
    'cdata', icon.folder,...
    'ToolTipString','Browse',...
    'Userdata',h.eqdata(21),...
    'Callback','tmp2=uigetdir(config.datadir);if isstr(tmp2), config.datadir=tmp2;set(get(gcbo,''Userdata''), ''String'',config.datadir);end,clear tmp*');
uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','text',...
    'Position',[230 75 110 20],...
    'String', 'Seismic data directory',...
    'HorizontalAlignment','left');



h.eqdata(23) = uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','Edit',...
    'BackgroundColor','w',...
    'Position',[50 50 170 20],...
    'ToolTipString','Output directory',...
    'String', config.savedir,...
    'Callback', 'config.savedir=get(gcbo,''String'');');

h.eqdata(22) = uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','Pushbutton',...
    'Position',[15 50 25 20],...
    'cdata', icon.folder,...
    'ToolTipString','Browse',...
    'Userdata',h.eqdata(23),...
    'Callback',['if exist(config.savedir)==7, tmp1=config.savedir;else, tmp1=config.datadir;end;',...
    'tmp=uigetdir(tmp1,''Please select output directory'');',...
    'if isstr(tmp),  if ~isdir(tmp), mkdir(tmp),end; config.savedir=tmp;',...
    'set(get(gcbo,''Userdata''), ''String'',config.savedir);end, clear tmp*' ]);

uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','text',...
    'Position',[230 45 100 20],...
    'String', 'Output directory',...
    'HorizontalAlignment','left');

formats = {'.ai','.eps','.fig','.jpg','.pdf','.ps','.png', '.tiff'};
val     =  strmatch(config.exportformat, formats);
h.eqdata(22) = uicontrol(...
    'Parent',h.panel(6),'Units','pixel',...
    'Style','PopupMenu',...
    'Position',[160 20 60 20],...
    'Value', val, ...
    'BackgroundColor','w',...
    'String', formats,...
    'ToolTipString','Figure export format',...
    'Callback', ['tmp1 = get(gcbo,''Value'');', ...
    'tmp2 = get(gcbo,''String'');',...
    'config.exportformat = char(tmp2(tmp1));',...
    'clear tmp1 tmp2;']);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~ispc %for PCs files are opened with Matlabs "winopen" function
    uicontrol(...
        'Parent',h.panel(6),'Units','pixel',...
        'Style','Pushbutton',...
        'Position',[340 19 80 22],...
        'String', 'Open with',...
        'Userdata',formats,...
        'Callback', ...
        ['defaults = getpref(''Splitlab'',''Associations'');', ...
        'answer = inputdlg(defaults(:,1),  ''Enter program to open format'' ,1,defaults(:,2));',...
        'if isempty(answer); answer=defaults(:,2);end,',...
        'defaults(:,2)= answer(:)'';  ',...
        'setpref(''Splitlab'',''Associations'',defaults);',...
        '%clear answer defaults new;']);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

uicontrol('Parent',h.panel(6),'Units','pixel',...
    'Style','text',...
    'Position',[230 15 100 20],...
    'String', 'Image output format',...
    'HorizontalAlignment','left'); 

str = {'A4','A3','A5','usletter','uslegal'};
val =strmatch( config.PaperType, str,'exact');
uicontrol(...
    'Parent',h.panel(6),'Units','pixel',...
    'Style','PopupMenu',...
    'Position',[50 19 90 22],...
    'String', str,...
    'Value',val,...
    'BackgroundColor','w',...
    'Callback', ['tmp1 = get(gcbo,''Value'');', ...
    'tmp2 = get(gcbo,''String'');',...
    'config.PaperType = char(tmp2(tmp1));',...
    'clear tmp1 tmp2;']);

axes( 'parent',h.panel(6), 'Units','pixel','position', [340 95 72 47])
image(icon.logo)
axis off

%% Comment
h.panel(8) = uipanel('Units','pixel','Title','Comments',...
    'FontSize',10,'Position',[133 5 425 230], 'BackgroundColor', [224   223   227]/255 );

x = 60;
y = 190;
w = 60;
v = 20;


uicontrol('Parent',h.panel(8),'Units','pixel',...
    'Style','Edit',...
    'Position',[30 10 340 190],...
    'String', config.comment,...
    'BackgroundColor','w',...
    'Max',999,...
    'HorizontalAlignment','Left',...
    'Callback','config.comment=get(gcbo, ''String'');')


% EOF %