function viewphases
global config thiseq

pos = [100 100 300 300];
mpos =get(0,'PointerLocation');

figpos = [mpos(1)-50 mpos(2)-370 200 380];
fig = figure('Position',figpos,'NumberTitle','off','Name','Select phase','Toolbar','None','menubar','none');

Plist={'P','Pdiff','PP','PPP','PcP','PcS','ScS','ScP','PS','SP','S','Sdiff','SS','SKP','PKS','SKS','SKKS','SKiKS','sSKS','pSKS'};
%% Phase data

button=  uicontrol('Units','pixel',...
    'Style','Pushbutton',...
    'Position',[90 325 100 20],...
    'Tag',config.earthmodel,...
    'String', 'View travel times',...
    'Callback','model=get(gcbo,''Tag'');phases=get(gcbo,''UserData'');SL_ttcurves(model,phases, thiseq.depth, thiseq.dis, config.eqwin);clear model phases,close(gcbf)');

uicontrol('Units','pixel',...
    'Style','PopupMenu',...
    'BackgroundColor','w',...
    'Position',[90 295 100 20],...
    'String', {'PREM','IASP91'},...
    'Userdata',button,...
    'Value', strcmp(config.earthmodel,'iasp91')+1,...
    'CallBack','tmp1=get(gcbo,''Value''); tmp2=lower(get(gcbo,''String''));tmp3=get(gcbo,''UserData'');tmp=char(tmp2(tmp1)); set(tmp3, ''Tag'',tmp); clear tmp* ');


uicontrol('Units','pixel',...
    'Style','List','Min',1,'Max',20,...
    'BackgroundColor','w',...
    'Userdata',button,...
    'Position',[15 15 70 figpos(4)-50],...
    'Value',[],...
    'String', Plist,...
    'Callback', ['tmp1=get(gcbo,''Value''); tmp2=get(gcbo,''String'');',...
    'tmpHandle=get(gcbo,''UserData'');',...
    'set(tmpHandle, ''Userdata'', tmp2(tmp1));',...
    'clear tmp* ']);
