function postcardware
F=mfilename('fullpath');
p=fileparts(F);

[im, map] = imread([p filesep 'postcard.gif']);



postcardtxt = {'Splitlab is PostCard ware!',...
    ['If you like SplitLab, if you work with it, or simply want to make me happy, ',...
    'please send a postcard of the place you live at to:'],...
    ' ',....
    'Andreas Wstefeld',...
    'Laboratoire de Tectonophysique',...
    'Place Eugne Bataillon',...
    '34095 Montpellier cedex 05',...
    'FRANCE',...
    ' ',....
    'A collection of the nicest postcards will be presented on the SplitLab homepage '};

h=msgbox(postcardtxt, 'PostCard Ware', 'custom', im, map);

set(h,'Color', 'w','units','Pixel');
pos = get(h,'position');

u   = uicontrol('String','Print',...
    'style','Pushbutton',...
    'Position',[pos(3)-40 10 30 20],...
    'parent',h,...
    'Callback',@printaddress);
waitfor(h)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function printaddress(dummy1, dummy2)
fig=figure(99);
set(fig,'visible','off')

axis off
text(0,0,{'\fontsize{16}Andreas Wstefeld','\fontsize{6} ',...
    '\fontsize{14}Laboratoire de Tectonophysique',...
    'Place Eugne Bataillon - CC 049','\fontsize{10} ',...
    '\fontsize{16}34095 Montpellier cedex 05','\fontsize{6} ',...
    '\fontsize{16}FRANCE'},...
    'Interpreter',      'tex',...
    'VerticalAlignment','bottom')

print(['-f' num2str(fig)])
close(fig)


