/* This is required to define the module name that defines the package
   name for the scripting language interface.*/
%module cwp
/* This says use the cwp.h include file as the basis for the interface.  This is 
   mainly a direction to put cwp.h as a header for the wrapper procedures 
   swig will produce.. */
%{
#include "cwp.h"
%}
/* C programmers will recognize these as nothing more than C function prototypes.
   The cwp.h include file contains many many more prototypes, but this defines 
   which of these are to be wrapped and made available to the scripting language.*/
float fsinc (float x);
double dsinc (double x);
void mksinc (float d, int lsinc, float sinc[]);

/* Butterworth filters */
void bfhighpass (int npoles, float f3db, int n, float p[], float q[]);
void bflowpass (int npoles, float f3db, int n, float p[], float q[]);
void bfdesign (float fpass, float apass, float fstop, float astop,
	int *npoles, float *f3db);
/* Toeplitz inversion routines */
void stoepd (int n, double r[], double g[], double f[], double a[]);
void stoepf (int n, float r[], float g[], float f[], float a[]);
