* error routines for response.f
* SL 1994

       subroutine prerr()
	 write(6,*) ""
	 write(6,*) "response function is not well-behaved."
	 write(6,*) "edges found are not reliable."
	 write(6,*) ""
       return
       end

       subroutine skerr(nerr,ck)
       character*(*) ck
       character*1 aa

10     format(a,$)
       write(6,'(a8,i3,2a16)') "error: ",nerr," when accessing ",ck
       write(6,10) "continue? (y/n): "
       read(5,'(a)') aa
       if (aa.eq."y") return
       stop
       end

       subroutine wrerr()
	  write(6,'(a)') "not a valid option, again:"
       return
       end

*     from numerical recipes:
      SUBROUTINE FOUR1(DATA,NN,ISIGN)
      REAL*8 WR,WI,WPR,WPI,WTEMP,THETA
      DIMENSION DATA(*)
      N=2*NN
      J=1
      DO 11 I=1,N,2
        IF(J.GT.I)THEN
          TEMPR=DATA(J)
          TEMPI=DATA(J+1)
          DATA(J)=DATA(I)
          DATA(J+1)=DATA(I+1)
          DATA(I)=TEMPR
          DATA(I+1)=TEMPI
        ENDIF
        M=N/2
1       IF ((M.GE.2).AND.(J.GT.M)) THEN
          J=J-M
          M=M/2
        GO TO 1
        ENDIF
        J=J+M
11    CONTINUE
      MMAX=2
2     IF (N.GT.MMAX) THEN
        ISTEP=2*MMAX
        THETA=6.28318530717959D0/(ISIGN*MMAX)
        WPR=-2.D0*DSIN(0.5D0*THETA)**2
        WPI=DSIN(THETA)
        WR=1.D0
        WI=0.D0
        DO 13 M=1,MMAX,2
          DO 12 I=M,N,ISTEP
            J=I+MMAX
            TEMPR=SNGL(WR)*DATA(J)-SNGL(WI)*DATA(J+1)
            TEMPI=SNGL(WR)*DATA(J+1)+SNGL(WI)*DATA(J)
            DATA(J)=DATA(I)-TEMPR
            DATA(J+1)=DATA(I+1)-TEMPI
            DATA(I)=DATA(I)+TEMPR
            DATA(I+1)=DATA(I+1)+TEMPI
12        CONTINUE
          WTEMP=WR
          WR=WR*WPR-WI*WPI+WR
          WI=WI*WPR+WTEMP*WPI+WI
13      CONTINUE
        MMAX=ISTEP
      GO TO 2
      ENDIF
      RETURN
      END

      subroutine fft(mx,sig,nlen,dt,isign,spec,nfrq,df,cmplt,data)
c to complete fast fourier transform with four1.f from
c numerical recipes. assuming: t --> f with exp(-iwt)
c and: f --> t with exp(iwt).
c INPUT: isign and space defining array data and:
c input with isign -1: a real time series (sig) with
c arbitrary length (nlen) and sample separation dt; 
c output for isign=-1: spec,nfrq,df,cmplt
c input with isign=1: a complex spectrum (spec)
c with length nfrq and sample separation df, also
c cmplt (if false then the spectrum for c neg. freq. 
c will be calculated from conjg(spec frq>=0)) 
c output for isign=1: sig,nfrq,dt
c if nfrq<nxtnyq (the nyquistindex (nxt/2+1) the
c spectrum is padded with zeroes.
c SL 1994

      logical cmplt
      dimension sig(mx)
      dimension data(2*mx)
      complex spec(mx)
      complex i90
      data i90/(0.,1.)/

      if (isign.eq.-1) then
         i=0
         do while (2**i.lt.nlen) 
	    i=i+1
         enddo
         nxt=2**i
	 if (nxt.gt.mx) stop "array limit nxt exceeded"
c padding of sig with zeroes: 
         do i=nlen+1,nxt
            sig(i)=0.
         enddo
         do i=1,nxt
	    data(2*i-1)=sig(i)
	    data(2*i)=0.
         enddo
         call four1(data,nxt,isign)  
         do i=1,nxt
	    spec(i)=data(2*i-1)+i90*data(2*i)
	    spec(i)=dt*spec(i)
         enddo
         nfrq=nxt
         df=1./(nxt*dt)
      else if (isign.eq.1) then
         i=0
         do while (2**i+1.lt.nfrq) 
	    i=i+1
         enddo
	 if (cmplt) then
	    nxt=nfrq
	 else
	    nxt=2**(i+1)
            nxtnyq=2**i+1
c padding of spec with zeroes:
            do i=nfrq+1,nxtnyq
               spec(i)=cmplx(0.,0.)
	    enddo
c assume real time series, cmplx conjg symm spec:
            do i=nxtnyq+1,nxt
               spec(i)=spec(nxtnyq-(i-nxtnyq))
	    enddo
	 endif
         if (nxt.gt.mx) stop "array limit nxt exceeded"
	 do i=1,nxt
	    data(2*i-1)=real(spec(i))
	    data(2*i)=imag(spec(i))
	 enddo
         call four1(data,nxt,isign)  
	 do i=1,nxt
	    sig(i)=data(2*i-1)
	    sig(i)=df*sig(i)
	 enddo
	 nlen=nxt
	 dt=1./(nxt*df)
	 cmplt=.true.
      else
	 stop "fft direction not defined!"
      endif

      return
      end
