       program responsee

c gets instrument response and convolves or deconvolves as you
c wish. Fourier convention: time --> freq uses exp(-iwt)
c uses pz.f (existing accurate instrument responses, coded last
c at Scripps) and pzread.f (to read fresh instrument responses
c from seed-response files.
c input time series assumed in SAC-format
c A non-memory-efficient fft procedure is used for convenience of
c debugging; at all times both the time series and (complete) spectrum 
c is available.
c 1996 SL
c response.a contains: pz.f pzread.f four1.f fft.f errs.f 

       parameter(pi=3.141593)
*       parameter(mx=16384)
       parameter(mx=1048576)
       logical cmplt,ok,nano,disp,fslat,fslon,fsel,exist
       character*70 respfl,specfl,spe3fl,seis
       character*24 seiso
       character*190 command
       dimension x(mx)
       dimension dum(2*mx)
       dimension ned(4),tp(4)
       complex r(mx),spec(mx)
       complex resp,s,evresh
       character*8 kcmpnm,kstnm
       character*4 stns(113),ctype,nchn
       character*5 nstn
       character*8 user
       character*20 name
       data cmplt/.true./
       data nano/.true./
       data stns/
     + 'AFI ','ALQ ','ANMC','ANMO','ANTO','BCAO',
     + 'BDF ','BER ','BGIO','BJI ','BOCO','CCM ',
     + 'CHG ','CHTO','CMB ','COL ','COR ','CTA ',
     + 'CTAO','EIL ','ENH ','GAC ','GDH ','GNI ',
     + 'GRFO','GSC ','GUMO','HIA ','HON ','HRV ',
     + 'ISA ','JAS ','JAS1','KAAO','KBS ','KEV ',
     + 'KIP ','KMI ','KON ','KONO','LEM ','LON ',
     + 'LSA ','LZH ','MAIO','MAJO','MAT ','MDJ ',
     + 'NWAO','OGD ','PAS ','PFO ','PFOT','PFO_',
     + 'QIZ ','RSCP','RSNT','RSNY','RSON','RSSD',
     + 'SBC ','SCP ','SHIO','SLR ','SNZO','SPA ',
     + 'SSE ','SVD ','TATO','TAU ','TLO ','TOL ',
     + 'WMQ ','ZLP ','ZOBO','AAK ','ALE ','ARU ',
     + 'ERM ','ESK ','GAR ','KIV ','NNA ','OBN ',
     + 'PFO ','RPN ','SUR ','TLY ','AGD ','BNG ',
     + 'CAN ','CAY ','CRZF','DRV ','HDC2','HYB ',
     + 'INU ','KIP ','MBO ','NOU ','PAF ','PPT ',
     + 'RER ','SCZ ','SSB ','TAM ','WFM ','WUS ',
     + 'NOC ','SEM ','SBB ','UNM ','ECH '/
       common/information/info

       fslat = .false.
       fslon = .false.
       fsel = .false.
       disp=.false.
       exist = .false.
       call getenv('USER',user)
10     format(a,$)
       info=1
       write(6,*) "response:"
       write(6,10) "give info level min (0) or max (1): "
       read(5,*) info
       write(6,*) info
       write(6,10) "give filename of input seismogram (SAC-format): "
       read(5, fmt = '(a70)') seis
       write(6,*) seis
       write(6,10) "give filename of output seismogram (SAC-format): "
       read(5, fmt = '(a24)') seiso
       write(6,*) seiso
       call rsac1(seis,x,nlen,beg,dt,mx,nerr)
       if (nerr.gt.0) call skerr(nerr,seis)
       call getnhv("nzyear",nzyear,nerr)
       if (nerr.gt.0) call skerr(nerr,"nzyear")
       call getnhv("nzjday",nzjday,nerr)
       if (nerr.gt.0) call skerr(nerr,"nzjday")
       call getkhv("kcmpnm",kcmpnm,nerr)
       nchn = kcmpnm(1:4)
       print*, kcmpnm, nchn
       if (nerr.gt.0) call skerr(nerr,"kcmpnm")
       call equiv(kcmpnm)
       call getkhv("kstnm",kstnm,nerr)
       nstn = kstnm(1:5)
       print*, kstnm, nstn
       if (nerr.gt.0) call skerr(nerr,"kstnm")
*USArray*       call getfhv("depmen",depmen,nerr)
*USArray*       if (nerr.gt.0) call skerr(nerr,"depmen")
*USArray*       call getfhv("depmax",depmax,nerr)
*USArray*       if (nerr.gt.0) call skerr(nerr,"depmax")
*USArray*       call getfhv("depmin",depmin,nerr)
*USArray*       if (nerr.gt.0) call skerr(nerr,"depmin")
*USArray*       if (abs(depmen/(depmax-depmin)).gt.0.001) then
*USArray*	  write(6,*) "The seismogram is offset from a zero mean."
*USArray*	  write(6,*) "This is a PROBLEM when the seismogram"
*USArray*	  write(6,*) "is padded with zeroes to reach a power-of-two"
*USArray*	  write(6,*) "number of samples. E.g. apply SAC>rmean or"
*USArray*	  write(6,*) "SAC>rtrend before applying response."
*USArray*	  nerr=-9
*USArray*	  call skerr(nerr,"zero-mean")
*USArray*       endif
       depmen = 0.
       do i=1,nlen
          depmen = depmen + x(i)
       enddo
       depmen = depmen/nlen
       do i=1,nlen
          x(i) = x(i) - depmen
       enddo

       call getfhv("stla",stla,nerr)
       if (nerr.gt.0) call skerr(nerr,"stla")
       call getfhv("stlo",stlo,nerr)
       if (nerr.gt.0) call skerr(nerr,"stlo")
       call getfhv("stel",stel,nerr)
       if (nerr.gt.0) call skerr(nerr,"stel")

       call fft(mx,x,nlen,dt,-1,spec,nfrq,df,cmplt,dum)

       do i=1,nfrq
 	 x(i)=cabs(spec(i))
       enddo
       name = '/tmp/specd.'//user
       call wsac1(name,x,nfrq,0.,df,nerr)

       if (cmplt) then
	  nnyq=nfrq/2+1
       else
	  call skerr(-1,"fft")
	  nnyq=nfrq/2+1
       endif
       fnyq = (nnyq-1)*df

       iex=-1
       i=1
       do while (i.le.113.and.kstnm.ne.stns(i))
	  i=i+1
       enddo
       if (i.le.113) then
	  if (i.le.75) then
             ctype='GDSN'
	  else if (i.le.88) then
	     ctype='IDA '
	  else
	     ctype='GEO '
	  endif
          iex=0
       endif

       write(6,*) ""
*USArray*       if (info.eq.1) then
*USArray*          write(6,*) "where to search for instrument response?"
*USArray*          write(6,*) "in a (SEED-format) response file (option 1),"
*USArray*          write(6,*) "or from given accurate (GDSN, IDA and GEOSCOPE)"
*USArray*          write(6,*) "responses for 1974 through 1992 (option 2)"
*USArray*          write(6,*) "(option 2 needs sac header values)"
*USArray*	  write(6,*) "or from a Caltech Terrascope Instrument"
*USArray*	  write(6,*) "response file (option 3)"
*USArray*	  write(6,*) "or from a USNSN Instrument"
*USArray*	  write(6,*) "response file (option 4)"
*USArray*	  write(6,*) "or from a Pole-Zero file"
*USArray*	  write(6,*) "response file (option 5)"
*USArray*	  write(6,*) "or from programmed USNSN long period"
*USArray*	  write(6,*) "responses (option 6)"
*USArray*       else
*USArray*	  write(6,*) "response from seed-file (1) or pz-code (2)"
*USArray*	  write(6,*) "or Terrascope file (3) or USNSN file (4)"
*USArray*	  write(6,*) "or Pole-Zero file (5) or programmed USNSN (6) ?"
*USArray*       endif
       write(6,*) ""
*USArray*       write(6,10) "give option: "
*USArray*       read(5,*) ioption
* for USArray course:
		ioption = 1
       write(6,*) ioption
       if (ioption.eq.2.and.iex.ne.0) then
	  write(6,*) "No response found for ",kstnm
	  ioption=1
       endif
       if (ioption.eq.6) iex = 0
       if (ioption.ne.2.and.ioption.ne.6) then
             write(6,10) "response filename: "
             read(5,fmt = '(a70)') respfl
             write(6,'(a)') respfl
             write(6,*) ""
             inquire(file=respfl,exist=ok) 
             if (ok) then
	        iex=1
	     else
	        nerr=1
	        call skerr(nerr,respfl)
	     endif
       endif

       if (iex.eq.0) then
	  if (ioption.eq.2) then
	     write(6,*) "calling pz with:",kstnm,' ',nchn,' ',ctype,' ',nzyear,nzjday
*USArray*	     call pznall(kstnm,nchn,ctype,nzyear,nzjday,istat)
	  else if (ioption.eq.6) then
*USArray*             call stats(kstnm,slat,slon,sel,istat)
             if (istat.eq.0) then
                write(6,*) kstnm,slat,slon,sel
		write(6,*) 'SAC says: ',stla,stlo,stel
		int1 = nint(stla*100.)
		int2 = nint(slat*100.)
		if (int1.ne.int2) then 
		   write(6,*) 'ERROR in slat corrected'
		   fslat = .true.
		endif
		int1 = nint(stlo*100.)
		int2 = nint(slon*100.)
		if (int1.ne.int2) then
		   write(6,*) 'ERROR in slon corrected'
		   fslon = .true.
		endif
		int1 = nint(stel*100.)
		int2 = nint(sel*100.)
		if (int1.ne.int2) then
		   write(6,*) 'ERROR in stel corrected'
		   fsel = .true.
	        endif
             else
                write(6,*) 'error: ',kstnm,': coordinates not found'
             endif
	     write(6,*) 'calling pzusnsn with:'
	     write(6,*) kstnm,' ',nchn,' ',nzyear,nzjday
*USArray*	     call pzusnsn(kstnm,nchn,nzyear,nzjday,istat)
	  else
	     write(6,*) 'no such option'
	  endif
       else if (iex.eq.1) then
	  if (ioption.eq.3) then
*USArray*             call pzcal(respfl,istat)
	  else if (ioption.eq.4) then
*USArray*	     call pzusn(respfl,istat)
	     disp = .true.
	  else if (ioption.eq.5) then
*USArray*	     call pzfile(respfl,istat)
	  else
*             call pzltst(respfl,istat)
              specfl = 'SPECTRA'//respfl(5:)
              call getend(respfl,lend,70)
              write(command,*) 'evalresp ',nstn,' ',nchn,' ',nzyear,
     &              ' ',nzjday,' 0 ',fnyq,' ',nnyq,
     &              ' -u vel -s lin -r cs -f ',respfl
* there is actually an evresp_() function now that can be called from here.
              print*, command
              call system(command)
              print*, respfl
              print*, specfl
              spe3fl = 'SPECTRE'//respfl(5:)
              call getend(specfl,lend,70)
*              write(command,*) "awk '{if (NR>3) print $0}' ", 
*     &                          specfl(1:lend)," > ", spe3fl
              write(command,*) "awk '{if (NR>0) print $0}' ", 
     &                          specfl(1:lend)," > ", spe3fl
              print*, command
              call system(command)
              print*, spe3fl
              respfl = spe3fl
              open(12,file=respfl)
              rewind 12
              do i=1,nnyq
                 read(12,*) f, r1,r2
                 r(i) = cmplx(r1,r2)
              enddo
              istat = 0
	  endif
       else
	  write(6,*) "instrument response could not be found and"
	  write(6,*) "will not be used."
	  istat=0
       endif
       if (istat.eq.0.or.istat.eq.4) then
	  continue
       else
	  write(6,*) "response retrieving could not be completed"
	  write(6,*) "error=",istat
	  stop
       endif

       write(6,*) ""
20     if (info.eq.1) then
	  write(6,10) "Would you like to convolve (1) or deconvolve (2):"
       else
	  write(6,10) "convolve (1) or deconvolve (2):"
       endif
       read(5,*) iopt
       iunit=0
       if (iopt.eq.2) then
30	  if (info.eq.1) then
	     write(6,*) "would you like the output in nm/s (1),"
	     write(6,10) "or in nm (2): "
	  else
	     write(6,10) "output in nm/s (1), nm (2):"
	  endif
	  read(5,*) iunit
	  if (iunit.ne.1.and.iunit.ne.2) then
	     if (iunit.eq.3) then
		iunit=1
		nano=.false.
	     else if (iunit.eq.4) then
		iunit=2
		nano=.false.
	     else
	        call wrerr()
	        goto 30
	     endif
	  endif
       else if (iopt.ne.1) then
	  call wrerr()
	  goto 20
       endif

       do i=1,nnyq
	  f=(i-1)*df
	  w=2*pi*f
	  s=cmplx(0.,w)
          if (ioption.ne.1) then
	     if (iex.eq.1.or.ioption.eq.6) then
*USArray*	        r(i)=resp(w)
	     else if (iex.eq.0) then
*USArray*	        r(i)=evresh(w)
	     else
*USArray*	        r(i)=cmplx(1.,0.)
	     endif
	  endif
	  if (disp.and.iunit.eq.1) then
	     r(i) = r(i)/s
	  endif
	  if (.not.disp.and.iunit.eq.2) then
	     r(i) = r(i)*s
	  endif
       enddo

       do i=1,nfrq
 	 x(i)=cabs(r(i))
       enddo
       name = '/tmp/specr.'//user
       call wsac1(name,x,nfrq,0.,df,nerr)

       do i=1,4
	  ned(i)=0
       enddo
       if (iopt.eq.2) then
          call getedges(nnyq,r,ifltr,ned)
	  do i=1,4
	     tp(i)=(ned(i)-1)*df
	  enddo
	  if (info.eq.1) then
	     if (ifltr.ne.1) then
		write(6,*) "automatic filter would have chosen:"
	     endif
       write(6,*) "clean filter between ",tp(2)," and ",tp(3)," Hz"
       write(6,*) "tapered filter between ",tp(1)," and ",tp(4)," Hz"
	     if (ifltr.eq.1) then
		write(6,*) "automatic setting not guaranteed to be suitable!"
		write(6,*) "check frequencies!"
	        write(6,*) "make sure these frequencies are appropriate!"
	     endif
          endif
       endif

c possible DC component removed from signal:
       spec(1)=cmplx(0.,0.)
       if (iopt.eq.1) then
          do i=2,nnyq
	     f=(i-1)*df
	     w=2*pi*f
	     s=cmplx(0.,w)
c make velocity of displacement seismogram:
	     if (.not.disp) then
		spec(i)=spec(i)*s
	     endif
	     spec(i)=spec(i)*r(i)
	  enddo
          do i=nnyq+1,nfrq
	     spec(i)=conjg(spec(nnyq-(i-nnyq)))
          enddo
       else
	  if (ifltr.eq.2) then
             call chooseedges(user,df,ned,tp)
	     if (info.eq.1) then
	        write(6,*) "clean filter between ",(ned(2)-1)*df
	        write(6,*) "and ",(ned(3)-1)*df," Hz"
	        write(6,*) "tapered filter between ",(ned(1)-1)*df
	        write(6,*) "and ",(ned(4)-1)*df," Hz"
             endif
	  endif
	  if (ifltr.eq.3) then
	     call readedges(df,ned,tp)
	     if (info.eq.1) then
	        write(6,*) "clean filter between ",(ned(2)-1)*df
	        write(6,*) "and ",(ned(3)-1)*df," Hz"
	        write(6,*) "tapered filter between ",(ned(1)-1)*df
	        write(6,*) "and ",(ned(4)-1)*df," Hz"
             endif
	  endif
          call deconv(nnyq,r,spec,ned)
          do i=nnyq+1,nfrq
	     spec(i)=conjg(spec(nnyq-(i-nnyq)))
          enddo
       endif

       call fft(mx,x,nlen,dt,1,spec,nfrq,df,cmplt,dum)

* read input seismogram once more to preserve original
* header fields.
       call rsac1(seis,dum,ndum,bdum,dtdum,mx,nerr)
       if (nano) then
	  if (iopt.eq.1) then
	     do i=1,nlen
	        x(i)=x(i)*1.e-9
	     enddo
	     call setihv("IDEP","IUNKN",nerr)
	  else
	     do i=1,nlen
	        x(i)=x(i)*1.e9
	     enddo
	     if (iunit.eq.1) call setihv("IDEP","IVEL",nerr)
	     if (iunit.eq.2) call setihv("IDEP","IDISP",nerr)
             if (nerr.gt.0) call skerr(nerr,"idep")
	  endif
       else
	  call setihv("IDEP","IUNKN",nerr)
          if (nerr.gt.0) call skerr(nerr,"idep")
       endif
       if (iopt.eq.2) then
          call setfhv("T6",tp(1),nerr)
          call setfhv("T7",tp(2),nerr)
          call setfhv("T8",tp(3),nerr)
          call setfhv("T9",tp(4),nerr)
          call setkhv("KT6","llf",nerr)
          call setkhv("KT7","lf",nerr)
          call setkhv("KT8","hf",nerr)
          call setkhv("KT9","hhf",nerr)
       endif
       call setkhv("kcmpnm",kcmpnm,nerr)
       call setnhv("NPTS",nlen,nerr)
       call setfhv("B",beg,nerr)
       call setfhv("DELTA",dt,nerr)
       if (fslat) call setfhv("stla",slat,nerr)
       if (fslon) call setfhv("stlo",slon,nerr)
       if (fsel) call setfhv("stel",sel,nerr)
       call wsac0(seiso,dum,x,nerr)

       do i=1,nfrq
	 if (nano) then
	    if (iopt.eq.1) then
 	       x(i)=1.e-9*cabs(spec(i))
	    else
 	       x(i)=1.e9*cabs(spec(i))
	    endif
	 else
 	    x(i)=cabs(spec(i))
	 endif
       enddo
       name = '/tmp/spec.'//user
       call wsac1(name,x,nfrq,0.,df,nerr)

       end

*********************************************************************

       subroutine chooseedges(user,df,ned,tp)
       dimension ned(4),tp(4)
       character*8 user
       character*20 name,name2
       character*28 command
       common/information/info
       name = '/tmp/smac.'//user
       open(1,file=name)
       rewind 1
       write(1,*) "bd x"
       write(1,*) "qdp off"
       write(1,*) "pause"
       name = '/tmp/specd.'//user
       name2 = '/tmp/specr.'//user
       write(1,*) "r ",name,name2
       write(1,*) "xlim ",df,ned(4)*df
       write(1,*) "xlog"
       write(1,*) "ylog"
       write(1,*) "p1"
       write(1,*) "pause"
       write(1,*) "ppk"
       write(1,*) "w over"
       close(1)
       write(6,*) ""
       if (info.eq.1) then
          write(6,*) "A sac ppk-window will be opened now."
          write(6,*) "Pick 4 frequencies, T0,T1,T2 and T3,"
          write(6,*) "in the top window"
          write(6,*) "Then quit SAC"
       endif
       write(6,*) ""
       command = 'sac /tmp/smac.'//user
       write(6,*) command
       call system(command)
       name = '/tmp/specd.'//user
       call rsac1(name,x,nd,bd,dtd,mx,nerr)
       call getfhv("T0",tp(1),nerr)
       if (nerr.gt.0) call skerr(nerr,"T0")
       call getfhv("T1",tp(2),nerr)
       if (nerr.gt.0) call skerr(nerr,"T1")
       call getfhv("T2",tp(3),nerr)
       if (nerr.gt.0) call skerr(nerr,"T2")
       call getfhv("T3",tp(4),nerr)
       if (nerr.gt.0) call skerr(nerr,"T3")
       if (tp(1).gt.tp(2)) call prerr()
       if (tp(3).gt.tp(4)) call prerr()
       if (tp(3).le.tp(2)) call prerr()

       i=1
       do while ((i-1)*df.lt.tp(1))
	  i=i+1
       enddo
       ned(1)=i
       do while ((i-1)*df.lt.tp(2))
	  i=i+1
       enddo
       ned(2)=i
       ned(3)=int(tp(3)/df)+1
       ned(4)=int(tp(4)/df)+1

       return
       end


       subroutine readedges(df,ned,tp)
*       parameter(taper=0.4)
       parameter(taper=0.2)
       dimension ned(4),tp(4)
       common/information/info
       if (info.eq.1) then
          write(6,*) "T0 and T1 are lower and low frequency for"
          write(6,*) "taper edges at low frequency edge of spectrum."
          write(6,*) "T2 and T3 are high and higher frequency for"
          write(6,*) "taper edges at high frequency edge of spectrum."
       endif
       write(6,*) "give T0, T1, T2, T3:"
       read(5,*) (tp(i),i=1,4)
       if (tp(1).gt.tp(2)) call prerr()
       if (tp(1).gt.(1.-taper)*tp(2)) then
	  write(6,*) 'need a larger bottom-width for taper.'
       endif 
       if (tp(4).lt.(1.+taper)*tp(3)) then
	  write(6,*) 'need a larger top-width for taper.'
       endif 
       if (tp(3).gt.tp(4)) call prerr()
       if (tp(3).le.tp(2)) call prerr()

       i=1
       do while ((i-1)*df.lt.tp(1))
	  i=i+1
       enddo
       ned(1)=i
       do while ((i-1)*df.lt.tp(2))
	  i=i+1
       enddo
       ned(2)=i
       ned(3)=int(tp(3)/df)+1
       ned(4)=int(tp(4)/df)+1

       return
       end


       subroutine deconv(n,r,spec,ned)
       parameter(pi=3.14159)
       dimension ned(4)
       complex r(n),spec(n)
       do i=ned(2),ned(3)
          if (cabs(r(i)).eq.0.) call prerr()
          spec(i)=spec(i)/r(i)
       enddo
       do i=2,ned(1)-1
          spec(i)=cmplx(0.,0.)
       enddo
       do i=ned(4)+1,n
          spec(i)=cmplx(0.,0.)
       enddo
       do i=ned(1),ned(2)-1
          if (cabs(r(i)).eq.0.) call prerr()
          spec(i)=spec(i)/r(i)
          taper=(1-cos((i-ned(1))*pi/(ned(2)-ned(1))))/2.
	  spec(i)=spec(i)*taper
       enddo
       do i=ned(3)+1,ned(4)
	  if (cabs(r(i)).eq.0.) call prerr()
          spec(i)=spec(i)/r(i)
	  taper=(1-cos((i-ned(4))*pi/(ned(3)-ned(4))))/2.
	  spec(i)=spec(i)*taper
       enddo
       spec(n)=cmplx(0.,0.)
       return
       end


       subroutine equiv(kcmpnm)
       character*8 kcmpnm
       if(kcmpnm(1:3).eq.'LPZ') kcmpnm(1:3)='LHZ'
       if(kcmpnm(1:3).eq.'LPN') kcmpnm(1:3)='LHN'
       if(kcmpnm(1:3).eq.'LPE') kcmpnm(1:3)='LHE'
       if(kcmpnm(1:3).eq.'IPZ') kcmpnm(1:3)='BHZ'
       if(kcmpnm(1:3).eq.'IPN') kcmpnm(1:3)='BHN'
       if(kcmpnm(1:3).eq.'IPE') kcmpnm(1:3)='BHE'
       return
       end


       subroutine getedges(n,r,ifltr,ned)
       complex r(n)
       parameter(eps1=1.e-1)
       parameter(eps=1.e-2)
       parameter(eps0=1.e-3)
       dimension ned(4)
       common/information/info

       call maxr(r,n,rmx,irmx)

	write(6,*) ""
	if (info.eq.1) then
        write(6,*) "the instrument response is significant in a limited"
	   write(6,*) "frequency band. Do you want "
	   write(6,*) "interactive filtering (2) or predetermined" 
	   write(6,*) "filtering (3)?"
	   write(6,*) ""
*	   write(6,*) "(* automatic filtering sets the signal spectrum to zero"
*	   write(6,*) "when the response is smaller than",eps*100.,"% of the"
*	   write(6,*) "maximum response on the low side and",eps0*100,"% on the"
*	   write(6,*) "high side. The signal spectrum is tapered towards zero" 
*	   write(6,*) "for the frequencies where the response values are between"
*	   write(6,*) eps1*100.,"% and",eps*100.,"% of the maximum response on the"
*	   write(6,*) "low side and between",eps*100.,"% and",eps0*100.,"% on the"
*	   write(6,*) "high side)"
	   write(6,*) "P.S. interactive hasn't been used in a long time"
           write(6,*) "     and may be broken"
	   write(6,*) ""
        write(6,*) "(* interactive filtering pops up a sac-ppk window,"
	write(6,*) "in which u pick 4 freqs (T0-T3); deconvolution"
	   write(6,*) "is retained between T1 and T2, tapers to zero are"
	   write(6,*) "applied between T1 and T0 and between T2 and T3)"
	   write(6,*) ""
	write(6,*) "(* predetermined filtering asks for 2 low frequency"
	   write(6,*) "taper edges and for 2 high frequency taper edges)"
	else
*	   write(6,*) "automatic (1), interactive (2) filtering or"
	   write(6,*) "interactive (2) filtering or"
	   write(6,*) "predetermined filtering (3)?"
	   write(6,*) "P.S. intereactive is probably broken" 
	endif
        write(6,*) ""
10      format(a,$)
40      write(6,10) "give option: "
	read(5,*) ifltr
*	if (ifltr.ne.1.and.ifltr.ne.2.and.ifltr.ne.3) then
	if (ifltr.ne.2.and.ifltr.ne.3) then
	   call wrerr()
	   goto 40
	endif

c Assume response is well behaved, i.e. it has a maximum between 0 and 
c nnyq, and is zero for f-->0 and f-->fnyq.
       i=1
       rr=cabs(r(i))/(rmx*eps)
       do while (rr.lt.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps)
       enddo
       ned(1)=i
       rr=cabs(r(i))/(rmx*eps1)
       do while (rr.lt.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps1)
       enddo
       ned(2)=i
       rr=cabs(r(i))/(rmx*eps)
       do while (rr.ge.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps)
       enddo
       ned(3)=i-1
       rr=cabs(r(i))/(rmx*eps0)
       do while (rr.ge.1.and.i.lt.n)
	  i=i+1
          rr=cabs(r(i))/(rmx*eps0)
       enddo
       ned(4)=i-1

c check for well-behavedness:
       if (ned(1).ge.irmx) call prerr()
       if (ned(2).ge.irmx) call prerr()
c the following needs not to be related to mis-behavedness:
c       if (ned(3).le.irmx) call prerr()
c       if (ned(4).le.irmx) call prerr()
       if (ned(4).gt.n) call prerr()
       do i=1,4
	  if(ned(i).eq.0) call prerr()
       enddo

       return
       end


       subroutine maxr(r,n,rmx,irmx)
       complex r(n)

       rmx=0
       do i=1,n
	  rr=cabs(r(i))
	  if (rr.gt.rmx) then
	     rmx=rr
	     irmx=i
	  endif
       enddo
       return
       end

       subroutine getend(chrctr,length,mxc)
       character*(*) chrctr

       i = 1
       do while (chrctr(i:i).ne.' '.and.i.le.mxc)
          i = i+1
       enddo
       length = i-1
       return
       end

