      program evinhdr
c to add event info to SAC header of raw data file.
      parameter(mx=20000000)
      logical dtm,neic
      character*72 argv
      character ha*1,ho*1,hm*2
      character*40 text
      real s(mx) 
      real lm
      integer ndttmo(6),ndttmb(6)

      inquire(file='event.list', exist=dtm)
      inquire(file='eqinfo', exist=neic)
20    format(5(i2,1x),f3.0,f6.2,a1,f7.2,a1,f6.1,f4.1,a2,a40)
      bm = 0.
      sm = 0.
      lm = 0.
      wm = 0.

      if (dtm) then
         open(1, file='event.list')
         rewind 1
         read(1,*) at,on,symsize,dp,iye,nday,ihr,imin,fsec,bm,sm,
     +		   cdist,cbaz,month,ndotm
	 close(1)
      else if (neic) then
         open(1, file='eqinfo')
         rewind 1
         read(1,20) iye,month,ndotm,ihr,imin,fsec,at,ha,on,ho,dp,
     +              aa, hm, text
	 if (iye.lt.60) then
	    iye = 2000 + iye
	 else
	    iye = 1900 + iye
	 endif
         call jul(iye,month,ndotm,nday)
         if (ha.eq.'S') at = -1.*at
         if (ho.eq.'W') on = -1.*on
	 if (hm.eq.'Mb') bm = aa
	 if (hm.eq.'Ms') sm = aa
	 if (hm.eq.'Ml') lm = aa
	 if (hm.eq.'Mw') wm = aa
	 close(1)
      else
	 write(6,*) 'create "event.list" or "eqinfo (NEIC)" first'
	 stop
      endif
      isec = int(fsec)
      fmsec = fsec - isec
      imsec = nint(fmsec*1000.)
      ndttmo(1) = iye
      ndttmo(2) = nday
      ndttmo(3) = ihr
      ndttmo(4) = imin
      ndttmo(5) = isec
      ndttmo(6) = imsec
      open(2,file='evinhdr.log',status='unknown',access='append')
      write(2,*) "-------------------------------------------"
      write(2,*) at,on,symsize,dp,iye,nday,ihr,imin,fsec,bm,sm,
     +		cdist,cbaz,month,ndotm

      narg = iargc()
      do i=1,narg
	 call getarg(i,argv)
	 call rsac1(argv,s,nlen,b,dt,mx,nerr)
         call getnhv('NZYEAR',ndttmb(1),nerr)
         call getnhv('NZJDAY',ndttmb(2),nerr)
         call getnhv('NZHOUR',ndttmb(3),nerr)
         call getnhv('NZMIN',ndttmb(4),nerr)
         call getnhv('NZSEC',ndttmb(5),nerr)
         call getnhv('NZMSEC',ndttmb(6),nerr)
         call setnhv('NZYEAR',ndttmo(1),nerr)
         call setnhv('NZJDAY',ndttmo(2),nerr)
         call setnhv('NZHOUR',ndttmo(3),nerr)
         call setnhv('NZMIN',ndttmo(4),nerr)
         call setnhv('NZSEC',ndttmo(5),nerr)
         call setnhv('NZMSEC',ndttmo(6),nerr)
	 write(2,*) argv,': read time from SAC file:'
	 write(2,*) (ndttmb(j),j=1,6)
	 write(2,*) argv,': inserted origin time:'
	 write(2,*) (ndttmo(j),j=1,6)
         call ddttm(ndttmb,ndttmo,diff)
         call setfhv('O',0.0,nerr)
         call setfhv('B',b+diff,nerr)
	 write(2,*) argv,': begin time shifted by', diff,' s'
         call setfhv('E',b+(nlen-1)*dt,nerr)
         call setihv('IZTYPE','IO',nerr)
         call setihv('idep','IUNKN',nerr)
         call setfhv('EVLA',at,nerr)
         call setfhv('EVLO',on,nerr)
         call setfhv('EVDP',dp,nerr)
         call setfhv('EVEL',-12345.,nerr)
	 write(2,*) argv,': event coordinates:', at,on,dp
	 call setfhv('USER8',bm,nerr)
	 call setfhv('USER9',sm,nerr)
	 call setfhv('USER7',wm,nerr)
	 call setfhv('USER6',lm,nerr)
         call setlhv('LCALDA',.true.,nerr)
         call setlhv('LOVROK',.true.,nerr)
         call setlhv('LEVEN',.true.,nerr)
         call setihv('IFTYPE','ITIME',nerr)
	 print*, "writing sac file ",argv
         call wsac0(argv,x,s,nerr)
	 if (nerr.ne.0) then
	    write(6,*) "ERROR writing sac-file:", nerr
	 endif
      enddo
      end

      subroutine ddttm(nb,no,diff)
      dimension nb(6),no(6)
	 if (nb(1).ne.no(1)) then
	    write(6,*) "ERROR: unequal years"
	    diff = 0.
	    return
	 endif
	 tb = float(nb(5)) + 0.001*nb(6)
	 to = float(no(5)) + 0.001*no(6)
	 diff = tb - to
	 diff = diff + 60.*(nb(4)-no(4))
	 diff = diff + 3600.*(nb(3)-no(3))
	 diff = diff + 24.*3600.*(nb(2)-no(2))
      return
      end

      subroutine jul(iy,im,id,jday)
      parameter(nys=13)
      dimension idays(12)
      data idays(1)/31/
      data (idays(i),i=3,12)/31,30,31,30,31,31,30,31,30,31/

      idays(2) = 28
      if (mod(iy,4).eq.0) idays(2) = 29
      jday = id
      do i = 1,im-1
         jday = jday + idays(i)
      enddo
      return
      end
