#! /bin/sh

## Demo of IGeoS web service.
## These jobs send requests to http://seisweb.usask.ca/igeos/ps.php
## This server executes the requested jobs 
## using an identical copy of IGeoS system and returns results to us
#######################################################################

## Obtain info about the server package itself

sia web-info-server.job

sia web-info-item.job defs
sia web-info-item.job colors
sia web-info-item.job fonts
sia web-info-item.job palettes
sia web-info-item.job ldrives		# "logical drives"

## Obtain usage examples for modules:

sia web-info-module.job agc
sia web-info-module.job filter
sia web-info-module.job sort

## obtain usage example for a flow installed on server:

sia web-flow-usage.job USArray get-data

	# then look in download.get-data/log.txt

## Execute a flow installed on server and download results:

sia web-flow-exec.job USArray list-stations BHE

	# Ignore message and look in download.list-stations/log.txt

## Send a local flow 'remote-get-data.job' to the server, execute it there
## and download results:

sia web-flow-send.job USArray remote-get-data BHZ 20
