#! /bin/sh

## examine the database by sending various queries to it:

sia show-db.job

## extract all waveforms into the processing flow:

sia extract-waveforms.job

## make two 0.5-degree wide "corridors":

sia make-corridor.job 1 corridor1.txt 0.5
sia make-corridor.job 2 corridor2.txt 0.5

## Use the database to list various data subsets:

sia list-stations.job
sia list-events.job
sia list-corridor.job 1
sia list-waveforms.job
sia list-waveforms-corridor.job 80 1	# params: event,corridor

## plot events, stations, and live channels maps using GMT:

sia map-events.job
sia map-stations.job
sia map-channels.job '2005/04/22' '2006/04/22' 2008
sia map-channels.job '2006/04/22' '2007/04/22' 2006
sia map-channels.job '2007/04/22' '2009/04/22' 2007

## plot corridors:

sia map-corridor.job 1
sia map-corridor.job 2

## plot all stations which recorded a given event
## (the same command is used in event-gathers.job)

sia map-event.job 80 P GMT/PS show

## plot seismic records from all stations recording an event,
## versus source-receiver distance:

sia plot-event.job 80 P 3

## plot seismic records from an event and along a corridor:

sia plot-event-corridor.job 2 P 1 3
	# params: event, arrival, corridor number, component to plot


 
