#! /bin/sh

## Start this sequence once you have created the gzipped SAC dataset
######################################################################

## Create SQL database

sia make_tables.job

## Put event table in the database:

sia events.job

# Read data in, save in four big SIA files,
# compile stations, channels, networks, and waveforms tables
# in the database:

sia read_sac.job 2005 'SAC/*/2005*.SAC_ASC.gz'
sia read_sac.job 2006 'SAC/*/2006*.SAC_ASC.gz'
sia read_sac.job 2007 'SAC/*/2007*.SAC_ASC.gz'
sia read_sac.job 2008 'SAC/*/2008*.SAC_ASC.gz'

# Edit the resulting tables
########################################

# remove duplicate waveforms

sia edit_tables.job

# locate continuations of each segment and save them in the db

sia connect_waveforms.job
