## plotting in source-receiver distance scale ('dist' in trace headers)

*call	refmod	iasp91		# this helps plotting reference travel times
linear	Lg	3.5

*call	trcscal	0	600

*define
redvel	10.0		# reduction velocity used below

*call	plot	WGVA	up	mean		10		2
offset	dist	0.2
setamp	peak
gain	1.5

reduce	dist	redvel		# 10-km/s time reduction by source-receiver distance
#align	drop	dist	0.0	P	iasp91		# align on IASP91 P-wave

trange	-200	700

window	6	9	1.5	1.	0	8.5	11

font	14				black
	
line	dash	0.5
1	3
timlab	50	%1.0f
timtitl	left	Time - Dist/{redvel} (s)

ticks		0		0		0
margins	1.1	1	.7

line	solid	0.5
scale	2.0	5		%1.0f
Range (deg)

gain	1
ps	300	{pspref}.range.ps
show

	# this is to plot 'ttime' from trace headers:

#line	solid	1.0		green
3draw	none	0	events	off-tim	
#ttime

	# plot IASP91 times directly from the model:

drawph	dist	0.0	iasp91
P		solid	1.0		red
S		solid	1.0		blue
Lg		solid	2.0		green


