
# read seed data
# SAC output
# organize into RESP, PZ and SACfile dirs
# request file on command line

#test
#file=test_request/Phillips.08_19_07.test
#file=Request_08_20_07/Phillips.08_20_07.921
file=$1

if test -f getseed.out; then rm getseed.out; fi

# clean up

rm RESP.*.*.*.*
rm SAC_PZs_*
rm *_*.SAC

# rdseed input file
# tricky, must have BHZ, if date format no result ...
# start and end time in SAC file name

cat << END > rdseed.in
$file
getseed.out
1
d


BHZ


1
Y
Y





Y
Quit
END

RDseed/rdseed < rdseed.in

# RESP files
# put time limits in file name
# throw error if more than one start or end time in file
# group by station dirs

if test ! -d RESP; then mkdir RESP; fi

for file in RESP.*.*.*.*
do
   net=`echo $file | gawk -F. '{print $2}'`
   sta=`echo $file | gawk -F. '{print $3}'`
   chan=`echo $file | gawk -F. '{print $5}'`

   if test ! -d RESP/$sta; then mkdir RESP/$sta; fi

   jdate1=`grep "Start date:" $file | gawk '{print $4}' | sort | head -1`
   jdate2=`grep "End date:" $file | gawk '$4!="No" {print $4} $4=="No" {print "2999,001,00:00:00"}' | sort -r | head -1`

   n1=`echo $jdate1 | wc -c | gawk '{print $1}'`
   n2=`echo $jdate2 | wc -c | gawk '{print $1}'`

   if test $n1 -eq 18
   then

      if test $n2 -eq 18
      then
         if test ! -f RESP/$sta/RESP.$net.$sta.$chan.$jdate1.$jdate2; then mv $file RESP/$sta/RESP.$net.$sta.$chan.$jdate1.$jdate2; fi
      else
         echo ERROR $n2 End dates $file $jdate2
      fi

   else
      echo ERROR $n1 Start dates $file $jdate1
   fi
done

# SAC PZs

if test ! -d SACPZ; then mkdir SACPZ; fi

for file in SAC_PZs_*
do
   sta=`echo $file | gawk -F_ '{print $4}'`
   if test ! -d SACPZ/$sta; then mkdir SACPZ/$sta; fi
   if test ! -f  SACPZ/$sta/$file; then mv $file SACPZ/$sta; fi
done

# SAC waveforms
# organized by start time, not event/origin!

if test ! -d SACfiles; then mkdir SACfiles; fi

for file in *_*.SAC
do
   year=`echo $file | gawk -F. '{print $1}'`
   jday=`echo $file | gawk -F. '{print $2}'`
   if test ! -d SACfiles/$year; then mkdir SACfiles/$year; fi
   if test ! -d SACfiles/$year/$jday; then mkdir SACfiles/$year/$jday; fi
   mv $file SACfiles/$year/$jday  
done

rm rdseed.in
