#!/bin/sh

# get station info from dataless seed file
# dataless seed file on command line
# standard output

# many offdates 2999365
# dataless seed must be updated to get TA stations that turn off?

sfile=$1

if test -f dataless.out; then rm dataless.out; fi

# rdseed input file

echo $sfile > rdseed.in
echo dataless.out >> rdseed.in
echo 1 >> rdseed.in
echo s >> rdseed.in
# default ALLs next -> no result
echo >> rdseed.in
echo BHZ >> rdseed.in
echo >> rdseed.in
echo >> rdseed.in
echo N >> rdseed.in
# response <Y/N> answer not needed
echo Quit >> rdseed.in

rdseed < rdseed.in > rdseed.out

# parse output
# get station header by requiring 9 spaces

grep "         Station code:" dataless.out | awk '{print $4}' > temp1.out
grep "         Latitude:" dataless.out  | awk '{print $3}' > temp2.out
grep "         Longitude:" dataless.out | awk '{print $3}' > temp3.out
grep "         Elevation:" dataless.out | awk '{print int($3)/1000.}' > temp4.out
grep "         Starting date:" dataless.out | awk '{print $4}' | awk -F, '{print $1 $2}' > temp5.out
grep "         Ending date:" dataless.out | awk '{print $4}' | awk '$1!="(null)" {print $1} $1=="(null)" {print "2999,365"}' | awk -F, '{print $1 $2}' > temp6.out
grep "         Network Code:" dataless.out | awk '{print $4}' > temp7.out

# check temp file lengths same pre-paste

n=`cat temp1.out | wc -l | gawk '{print $1}'`
i=2
while test $i -le 7
do
   if test $n -ne `cat temp$i.out | wc -l | gawk '{print $1}'`
   then
      echo bad file length $n `cat temp$i.out | wc -l | gawk '{print $1}'` exit
      exit
   fi
   i=`expr $i + 1`
done

# add length check

paste temp1.out temp2.out temp3.out temp4.out temp5.out temp6.out temp7.out | awk '{print $1,$2,$3,$4,$5,$6,$7}' | sort -k 1,1

rm rdseed.in dataless.out temp?.out rdseed.out
