! calc the P, SH, and SV radiation pattern, using
! aki and richards formulation.  
! code modified by EJG, from an original
! code written by CHUNPENG ZHAO
! summer 2009
!
! input: strike, dip, rake ("fi,delta,lamda")
! output: 3 files, one each for P, SV, SH
!        radiation pattern, named
!           P_radiation
!           SV_radiation
!           SH_radiation

         character*40 outputfile
         real fi,lamda,delta,amp_theo

! fi = strike, delta = dip, lamda = rake

         READ(*,*)fi,delta,lamda

         deg2rad=3.1415926/180
         rad2deg=1/deg2rad
         fi=fi*deg2rad
         delta=delta*deg2rad
         lamda=lamda*deg2rad
    
!========================================================
!        P radiation Pattern
!========================================================
! Calculate radiation for:
! Take off angle ranging from 0 to 90
! Azimuth angle ranging from 0 to 360

         outputfile='P_radiation'
         open(11,file=outputfile,status='UNKNOWN')
         do 19 i=0,90
             takeoff=i*deg2rad
             do 20 j=0,360
                 azi=j*deg2rad
                 amp_theo=cos(lamda)*sin(delta)*(sin(takeoff)**2.)
     c           *sin(2.*(azi-fi))-cos(lamda)*cos(delta)*sin(2*takeoff)
     c           *cos(azi-fi)+sin(lamda)*sin(2.*delta)*(cos(takeoff)**2.
     c           -sin(takeoff)**2.*sin(azi-fi)**2.)+sin(lamda)
     c           *cos(2.*delta)*sin(2.*takeoff)*sin(azi-fi)
                 proj=takeoff*rad2deg 
                 azi=azi*rad2deg
                 if(abs(amp_theo) .lt. 0.0001) amp_theo=0.0
                 write(11,*)azi,proj,amp_theo
20           continue
19       continue    
         close(11)

!========================================================
!        SV radiation Pattern
!========================================================
! pretty much as w/ P, 'cept different math

         outputfile='SV_radiation'
         open(11,file=outputfile,status='UNKNOWN')
         do 22 i=0,90
             takeoff=i*deg2rad
              do 23 j=0,360
                  azi=j*deg2rad
                  amp_theo=sin(lamda)*cos(2.*delta)*cos(takeoff*2.)
     c            *sin(azi-fi)-cos(lamda)*cos(delta)*cos(2.*takeoff)
     c            *cos(azi-fi)+1./2.*cos(lamda)*sin(delta)
     c            *sin(takeoff*2)*sin(2.*(azi-fi))-1./2.*sin(lamda)
     c            *sin(2.*delta)*sin(2.*takeoff)*(1+sin(azi-fi)**2.)
                  proj=takeoff*rad2deg
                 if(abs(amp_theo) .lt. 0.0001) amp_theo=0.0
                  azi=azi*rad2deg
                  write(11,*)azi,proj,amp_theo
23            continue
22       continue    
         close(11)

!========================================================
!        SH radiation Pattern
!========================================================
! pretty much as w/ P, 'cept different math

         outputfile='SH_radiation'
         open(11,file=outputfile,status='UNKNOWN')
         do 25 i=0,90
             takeoff=i*deg2rad
             do 26 j=0,360
                 azi=j*deg2rad
                 amp_theo=cos(lamda)*cos(delta)*cos(takeoff)
     c           *sin(azi-fi)+cos(lamda)*sin(delta)*sin(takeoff)
     c           *cos(2.*(azi-fi))+sin(lamda)*cos(2.*delta)*cos(takeoff)
     c           *cos(azi-fi)-1./2.*sin(lamda)*sin(2.*delta)
     c           *sin(takeoff)*sin(2.*(azi-fi))
                 if(abs(amp_theo) .lt. 0.0001) amp_theo=0.0
                 proj=takeoff*rad2deg
                 azi=azi*rad2deg
                 write(11,*)azi,proj,amp_theo
26           continue
25       continue    
         close(11)

        end

