
from edu.sc.seis.bag import EventGrabber
from edu.sc.seis.bag import ChannelGrabber
from edu.sc.seis.bag import ResponseGrabber
from edu.sc.seis.bag import SeismogramGrabber

from edu.iris.Fissures.model import TimeInterval, UnitImpl
from edu.iris.Fissures.IfNetwork import Channel, Response, ChannelId

from edu.sc.seis.fissuresUtil.dataset import DataSetEventOrganizer
from edu.sc.seis.fissuresUtil.xml import MemoryDataSet, MemoryDataSetSeismogram
from edu.sc.seis.fissuresUtil.bag import PhaseRequest
from edu.sc.seis.fissuresUtil.namingService import FissuresNamingService
from edu.sc.seis.fissuresUtil.simple import Initializer


__all__ = ['grabchannels',
           'grabresponse',
           'getPhaseRequest',
           'grabseis',
	   'EventGrabber',
	   'ChannelGrabber',
           'fisname']

fisname = Initializer.getNS()
     
def grabchannels(netCode, staCode, siteCode, chanCode):
   channelGrab = ChannelGrabber()
   channelGrab.netCode=netCode
   channelGrab.staCode=staCode
   channelGrab.siteCode=siteCode
   channelGrab.chanCode=chanCode
   return channelGrab

def grabresponse(channel):
    if isinstance(channel, Channel):
	return grabresponse(channel.get_id())
    elif isinstance(channel, ChannelId):
	return ResponseGrabber().grabResponse(channel)

def getPhaseRequest(event, channel, beginPhase, beginOffset, endPhase, endOffset, model='prem'):
    return PhaseRequest(beginPhase, 
			TimeInterval(beginOffset, UnitImpl.SECOND),
			endPhase, TimeInterval(endOffset, UnitImpl.SECOND),
			model).generateRequest( event,
						channel)
	
def grabseis(requests):
   return SeismogramGrabber().grabSeismograms(requests)

def grabdataset(eventgrabber, channelgrabber, beginPhase, beginOffset, endPhase, endOffset, model='prem'):
    ds = MemoryDataSet('id', 'temp', 'me', None)
    organizer = DataSetEventOrganizer(ds)
    for e in eventgrabber:
	for c in channelgrabber:
	   request = dhi.getPhaseRequest(e, c, beginPhase,beginOffset, endPhase, endOffset)
	   seismograms = dhi.grabseis(request)
	   dss=MemoryDataSetSeismogram(request, ds)
	   for s in seismograms:
	       dss.add(s)
	   ds.addSeismogram(dss, e, None)
	   ds.addChannel(c)
    return ds
