from edu.iris.Fissures.network import ChannelIdUtil
from edu.iris.Fissures.IfEvent import EventAccessOperations
from edu.iris.Fissures.IfNetwork import Instrumentation, Response

from edu.sc.seis.seisFile.sac import SacTimeSeries

from edu.sc.seis.fissuresUtil.sac import SacToFissures, FissuresToSac

from edu.sc.seis.fissuresUtil.bag import RMean
from edu.sc.seis.fissuresUtil.bag import RTrend
from edu.sc.seis.fissuresUtil.bag import Taper
from edu.sc.seis.fissuresUtil.bag import ButterworthFilter
from edu.sc.seis.fissuresUtil.bag import Transfer
from edu.sc.seis.fissuresUtil.bag import Statistics
from edu.sc.seis.fissuresUtil.chooser import ClockUtil
from edu.sc.seis.fissuresUtil.freq import Cmplx
import inspect

import test, dhi

__all__ = ['read',
           'writesac',
           'test',
           'dhi',
           'rmean',
           'rtrend',
           'taper',
           'bp',
           'transfer',
           'sacpz',
           'fft',
           'stat',
           'grabevents',
           'grabchannels',
           'getPhaseRequest',
           'grabseis',
           'ClockUtil',
           'help']

def help(item):
   if inspect.ismethod(item) or inspect.isfunction(item):
      sig = inspect.getargspec(item)[0]
      sig = str(sig)[1:-1]
      print '%s(%s)'%(item.__name__, sig)
   elif inspect.isclass(item):
      list = dir(item)
      for l in list:
         print l
   else:
      print "I'm no help..."

rmean = RMean().apply
rtrend = RTrend().apply

def stat(seis):
   return Statistics(seis)

def bp(seis, lowCorner, highCorner, numPoles=2):
   return ButterworthFilter(lowCorner, highCorner, numPoles).apply(seis)

def fft(seis):
   out=[]
   cmplxVals = Cmplx.fft(seis.get_as_floats())
   for c in cmplxVals:
      out.append(complex(c.real(), c.imag()))
   return out

def read(fn):
   sac = SacTimeSeries()
   sac.read(fn)
   return SacToFissures.getSeismogram(sac)

def writesac(seis, filename, channel=None, event=None):
   sac = FissuresToSac.getSAC(seis)
   if channel != None:
         FissuresToSac.addChannel(sac, channel)
   if event != None:
      if isinstance(event, EventAccessOperations):
         origin = event.get_preferred_origin()
      else:
         origin = event
      FissuresToSac.addOrigin(sac, origin)
   sac.write(filename)

def taper(seis, type=Taper().HANNING, width=0.05):
   return Taper(type, width).apply(seis)

def sacpz(resp):
   if isinstance(resp, Instrumentation):
      return tosacpolezero(resp.the_response)
   else:
      return FissuresToSac.getPoleZero(resp)

def transfer(seis, resp, lowcut, lowpass, highcut, highpass):
   if isinstance(resp, Instrumentation) or isinstance(resp, Response):
      pz = tosacpolezero(resp)
   else:
      pz = resp
   return Transfer().apply(seis, pz, lowcut, lowpass, highcut, highpass)

