clear
figure('Position',[1 100 400 400],'Color','white');
hold on
xlim ([-1 1]);
ylim ([-1 3]);
%
% plot static part of image
%
plot([-.5 .5],[0 0]); % plot a little line for the ball to bounce on
title('Bouncing Ball Movie')
zlabel('height');
%
% loop over frames of movie, plotting the bouncing ball
%
k = 0;
for t=0.0 : 5.0 : 500.0
    amp = cos(2*pi*0.01*t) + 1;
    h   = scatter(0,amp,100,[1 amp/2 amp/2],'filled','markeredgecolor','k');
    pause(0.1);
    k = k + 1;
    F(k) = getframe(gcf);
    delete(h)    % use object graphics to delete the ball
end


% View the movie in matlab using
% movie(F);

% Or, write the movie to disk (matlab appends the .avi extension)
% movie2avi(F,'junk');